/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#ifndef MAIN_H
#define MAIN_H

#include <gnome.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#ifdef _FREEBSD
	#include <stdlib.h>
#else
	#include <malloc.h>
#endif
#include <interface.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#ifdef _NETBSD
	#include "gnu-regex.h"
	#include "strcasestr.h"
#endif

#include "gtkextext.h"
#include "gtksourceeditor.h"
#include "support.h"
#include "general.h"
#include "proyecto.h"
#include "archivos.h"
#include "cefv.h"
#include "editor.h"
#include "compilar.h"
#include "preferencias.h"
#include "buscar.h"
#include "autoconf.h"
#include "autodetect.h"
#include "glade.h"
#include "pixmaps.h"
#include "callbacks.h"

//*******************************************************************

#define VERSION_PROYECTO "0.99"

#define VERSION_PREFERENCIAS "0.99"

#define ULTIMA_FASE_AUTODETECCION 46

//*******************************************************************

//#define DEBUG
#ifdef DEBUG
	#define DEBUG_MSG(msg) g_print("%s\n",#msg)
#else
	#define DEBUG_MSG(msg)
#endif

//*******************************************************************

#define AUTO_CONF 0x01
#define AUTO_MAKE 0x02
#define AUTO_HEADER 0x04
#define ACLOCAL 0x08
#define CONFIGURE 0X10

//*******************************************************************

enum e_estado_archivos_ventana {PROYECTO_ABRIR,PROYECTO_ANADIR};

enum e_estado_proyecto_ventana {NUEVO,PROPIEDADES};

//*******************************************************************

GtkWidget *david_ventana;

GtkWidget *ventana_inicio;

enum e_estado_archivos_ventana estado_archivos_ventana;

enum e_estado_proyecto_ventana estado_proyecto_ventana;

guchar autoconfiguracion;

//*******************************************************************

gboolean david_init(gpointer datos);

#ifndef _FREEBSD
extern gchar *strcasestr(gchar *,gchar *);
#endif

#endif
