/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void pref_crear(void)
{
	xmlNodePtr xmlnode;
	xmlNodePtr nodo;
	struct passwd *info;
	gchar *directorio;
	gchar *color;
	
	DEBUG_MSG(->pref_crear);
	preferencias.xml=xmlNewDoc("1.0");
	xmlnode=xmlNewNode(NULL,"Preferencias_diasce2");
	(preferencias.xml)->xmlRootNode=xmlnode;
	xmlNewProp(xmlnode,"version",VERSION_PREFERENCIAS);
	
	xmlNewChild(xmlnode,NULL,"general",NULL);
	xmlNewChild(xmlnode,NULL,"editor",NULL);
	xmlNewChild(xmlnode,NULL,"documentacion",NULL);
	xmlNewChild(xmlnode,NULL,"colores",NULL);
	xmlNewChild(xmlnode,NULL,"ultimos",NULL);
	
	//preferencias de general
	xmlnode=xmlnode->xmlChildrenNode;
	xmlNewProp(xmlnode,"nombre",NULL);
	xmlNewProp(xmlnode,"e-mail",NULL);
	info=getpwuid(getuid());
	directorio=g_strdup_printf("%s/",info->pw_dir);
	xmlNewProp(xmlnode,"directorio",directorio);
	g_free(directorio);
	xmlNewProp(xmlnode,"texto_barras","0");
	
	//preferencias de editor
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"auto","1");
	xmlNewProp(xmlnode,"super","1");
	xmlNewProp(xmlnode,"llaves","1");
	xmlNewProp(xmlnode,"tabulador","5");
	xmlNewProp(xmlnode,"fuente","");
	xmlNewProp(xmlnode,"numeros","0");
	
	//preferencias de documentacion
	xmlnode=xmlnode->next;
	xmlNewChild(xmlnode,NULL,"gtk","http://developer.gnome.org/doc/API/2.0/gtk/index.html");
	xmlNewChild(xmlnode,NULL,"xml",NULL);
	xmlNewChild(xmlnode,NULL,"glib","http://developer.gnome.org/doc/API/2.0/glib/index.html");
	xmlNewChild(xmlnode,NULL,"orbit",NULL);
	xmlNewChild(xmlnode,NULL,"gnome",NULL);
	xmlNewChild(xmlnode,NULL,"gnomeui",NULL);
	xmlNewChild(xmlnode,NULL,"gnorba",NULL);
	
	//preferencias de colores
	xmlnode=xmlnode->next;
	nodo=xmlNewChild(xmlnode,NULL,"c_fondo",NULL);
	color=g_strdup_printf("%i",c_fondo.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_fondo.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_fondo.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_nada",NULL);
	color=g_strdup_printf("%i",c_nada.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_nada.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_nada.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_comentario",NULL);
	color=g_strdup_printf("%i",c_comentario.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_comentario.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_comentario.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_directiva",NULL);
	color=g_strdup_printf("%i",c_directiva.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_directiva.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_directiva.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cs",NULL);
	color=g_strdup_printf("%i",c_cadena_cs.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cs.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cs.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cd",NULL);
	color=g_strdup_printf("%i",c_cadena_cd.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cd.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cd.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_etiqueta",NULL);
	color=g_strdup_printf("%i",c_etiqueta.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_etiqueta.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_etiqueta.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_entero",NULL);
	color=g_strdup_printf("%i",c_entero.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_entero.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_entero.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_real",NULL);
	color=g_strdup_printf("%i",c_real.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_real.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_real.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_hexadecimal",NULL);
	color=g_strdup_printf("%i",c_hexadecimal.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_hexadecimal.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_hexadecimal.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");
	nodo=xmlNewChild(xmlnode,NULL,"c_octal",NULL);
	color=g_strdup_printf("%i",c_octal.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_octal.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_octal.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	xmlSetProp(nodo,"negrita","0");
	xmlSetProp(nodo,"cursiba","0");

	DEBUG_MSG(<-pref_crear);
}

/* esta funicon tiene que ser llamada despues de edit_inicializar() para que los punteros a los colores de la estructura de preferencias
   esten asignados */
void pref_abrir(guint estado)
{
	struct passwd *info;
	gchar *archivoconf;
	gboolean crear;
	gint cont;
	gchar *version;
	xmlNodePtr nodo;
	
	crear=FALSE;

	if (estado==0) {
		DEBUG_MSG(abriendo preferencias);
		preferencias.nombre=NULL;
		preferencias.e_mail=NULL;
		preferencias.directorio=NULL;
		preferencias.fuente=NULL;
		for (cont=0;cont<TOTAL_AYUDAS;cont++) {
			preferencias.ayuda[cont]=NULL;
		}
		preferencias.ultimos[0]=NULL;
		preferencias.ultimos[1]=NULL;
		preferencias.ultimos[2]=NULL;
		preferencias.ultimos[3]=NULL;
		preferencias.ultimos[4]=NULL;
		for (cont=0;cont<LTOTALES;cont++) {
			preferencias.inc[cont]=NULL;
		}
		for (cont=0;cont<LTOTALES;cont++) {
			preferencias.lib[cont]=NULL;
		}
		preferencias.lib_electric_fence=NULL;
		info=getpwuid(getuid());
		archivoconf=g_strdup_printf("%s/.diasce2",info->pw_dir);
		preferencias.xml=xmlParseFile(archivoconf);
		g_free(archivoconf);
		if (preferencias.xml==NULL) {
			pref_crear();
			crear=TRUE;
		}
		nodo=preferencias.xml->xmlRootNode;
		version=xmlGetProp(nodo,"version");
		if (!g_strcasecmp(version,"1.1")) {
			xmlSetProp(nodo,"version",VERSION_PREFERENCIAS);
			nodo=buscar_nodo_xml(nodo,"colores");
			nodo=nodo->xmlChildrenNode->next;
			while (nodo!=NULL) {
				xmlNewProp(nodo,"negrita","0");
				xmlNewProp(nodo,"cursiba","0");
				nodo=nodo->next;
			}
			nodo=buscar_nodo_xml(preferencias.xml->xmlRootNode,"editor");
			xmlNewProp(nodo,"fuente","");
			xmlNewProp(nodo,"numeros","0");
		}
		det_autodetectar(preferencias.xml,crear,estado);
		pref_xml_struct();
		chdir(preferencias.directorio);
	} else {
		det_autodetectar(preferencias.xml,FALSE,estado);
		if (estado==ULTIMA_FASE_AUTODETECCION) {
			pref_xml_struct();
			pref_guardar();
		}
	}
}

void pref_guardar(void)
{
	struct passwd *info;
	gchar *archivoconf;

	info=getpwuid(getuid());
	archivoconf=g_strdup_printf("%s/.diasce2",info->pw_dir);
	xmlSaveFile(archivoconf,preferencias.xml);
	g_free(archivoconf);
}

void pref_actualizar(GtkWidget *widget)
{	
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;
	guint cont;
	gchar *directorio;
	struct passwd *info;
	gushort gamma;
	
	widget=gtk_widget_get_toplevel(widget);
	xmlnode=(preferencias.xml)->xmlRootNode->xmlChildrenNode;
	
	//propiedades generales
	fuente=glade_xml_get_widget(preferencias_ventana,"nombre_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"nombre",texto);
	g_free(texto);

	fuente=glade_xml_get_widget(preferencias_ventana,"e_mail_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"e-mail",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(preferencias_ventana,"directorio_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		info=getpwuid(getuid());
		directorio=g_strdup_printf("%s/",info->pw_dir);
	} else {
		for (cont=0;texto[cont]!=0;cont++);
		if (texto[cont-1]!='/') {
			directorio=g_strdup_printf("%s/",texto);
		} else {
			directorio=g_strdup(texto);
		}
	}
	g_free(texto);
	xmlSetProp(xmlnode,"directorio",directorio);
	g_free(directorio);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_barras_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"texto_barras","1");
	} else {
		xmlSetProp(xmlnode,"texto_barras","0");
	}

	//propiedades editor
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"auto_indentacion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"auto","1");
	} else {
		xmlSetProp(xmlnode,"auto","0");
	}
	
	fuente=glade_xml_get_widget(preferencias_ventana,"super_indentacion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"super","1");
	} else {
		xmlSetProp(xmlnode,"super","0");
	}
	
	fuente=glade_xml_get_widget(preferencias_ventana,"cerrar_llaves_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"llaves","1");
	} else {
		xmlSetProp(xmlnode,"llaves","0");
	}
	
	fuente=glade_xml_get_widget(preferencias_ventana,"tabulador_size");
	texto=g_strdup_printf("%i",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente)));
	xmlSetProp(xmlnode,"tabulador",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(preferencias_ventana,"fuente_selector");
	texto=(gchar *)gnome_font_picker_get_font_name(GNOME_FONT_PICKER(fuente));
	xmlSetProp(xmlnode,"fuente",texto);
//	g_free(texto); La cadena de la fuente no hay que liberarla

	fuente=glade_xml_get_widget(preferencias_ventana,"numeros_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"numeros","1");
	} else {
		xmlSetProp(xmlnode,"numeros","0");
	}
	
	//propiedades ayuda
	xmlnode=xmlnode->next->xmlChildrenNode;
	fuente=glade_xml_get_widget(preferencias_ventana,"gtk_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if ((texto==NULL) || (texto[0]==0)) {
		g_free(texto);
		texto=g_strdup("http://developer.gnome.org/doc/API/2.0/gtk/index.html");
	}
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"xml_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"glib_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if ((texto==NULL) || (texto[0]==0)) {
		g_free(texto);
		texto=g_strdup("http://developer.gnome.org/doc/API/2.0/glib/index.html");
	}
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"orbit_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);

	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"gnome_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"gnomeui_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(preferencias_ventana,"gnorba_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);

	//propiedades colores
	xmlnode=xmlnode->parent->next->xmlChildrenNode;
	fuente=glade_xml_get_widget(preferencias_ventana,"fondo_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_fondo.red,&c_fondo.green,&c_fondo.blue,&gamma);
	texto=g_strdup_printf("%i",c_fondo.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_fondo.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_fondo.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_nada.red,&c_nada.green,&c_nada.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_nada.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_nada.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_nada.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_comentario.red,&c_comentario.green,&c_comentario.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_comentario.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_comentario.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_comentario.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_directiva.red,&c_directiva.green,&c_directiva.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_directiva.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_directiva.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_directiva.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_cadena_cs.red,&c_cadena_cs.green,&c_cadena_cs.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_cadena_cs.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cs.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cs.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_cadena_cd.red,&c_cadena_cd.green,&c_cadena_cd.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_cadena_cd.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cd.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cd.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_etiqueta.red,&c_etiqueta.green,&c_etiqueta.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_etiqueta.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_etiqueta.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_etiqueta.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_entero.red,&c_entero.green,&c_entero.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_entero.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_entero.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_entero.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_real.red,&c_real.green,&c_real.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_real.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_real.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_real.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_hexadecimal.red,&c_hexadecimal.green,&c_hexadecimal.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_hexadecimal.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_hexadecimal.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_hexadecimal.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_octal.red,&c_octal.green,&c_octal.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_octal.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_octal.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_octal.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_bold");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"negrita","1");
	} else {
		xmlSetProp(xmlnode,"negrita","0");
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_italic");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cursiba","1");
	} else {
		xmlSetProp(xmlnode,"cursiba","0");
	}

	pref_guardar();
	pref_xml_struct();
}

void pref_mostrar(GtkWidget *widget)
{
	GtkWidget *fuente;

	DEBUG_MSG(->pref_mostrar);
	
	widget=gtk_widget_get_toplevel(widget);
	
	//propiedades generales
	if (preferencias.nombre != NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"nombre_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.nombre);
	}
	if (preferencias.e_mail != NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"e_mail_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.e_mail);
	}
	if (preferencias.directorio != NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"directorio_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.directorio);
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_barras_checkbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.texto_barras);
	
	//propiedades editor
	fuente=glade_xml_get_widget(preferencias_ventana,"auto_indentacion_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.auto_indentacion);
	fuente=glade_xml_get_widget(preferencias_ventana,"super_indentacion_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.super_indentacion);
	fuente=glade_xml_get_widget(preferencias_ventana,"cerrar_llaves_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.completar_llaves);
	fuente=glade_xml_get_widget(preferencias_ventana,"tabulador_size");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),preferencias.tabulador);
	if ((preferencias.fuente!=NULL) && (preferencias.fuente[0]!=0)) {
		fuente=glade_xml_get_widget(preferencias_ventana,"fuente_selector");
		gnome_font_picker_set_font_name(GNOME_FONT_PICKER(fuente),preferencias.fuente);
	}
	fuente=glade_xml_get_widget(preferencias_ventana,"numeros_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.numeros);
	
	//propiedades ayuda
	if (preferencias.ayuda[GTK]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"gtk_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[GTK]);
	}
	if (preferencias.ayuda[XML]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"xml_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[XML]);
	}
	if (preferencias.ayuda[GLIB]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"glib_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[GLIB]);
	}
	if (preferencias.ayuda[ORBIT]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"orbit_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[ORBIT]);
	}
	if (preferencias.ayuda[GNOME]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"gnome_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[GNOME]);
	}
	if (preferencias.ayuda[GNOMEUI]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"gnomeui_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[GNOMEUI]);
	}
	if (preferencias.ayuda[GNORBA]!=NULL) {
		fuente=glade_xml_get_widget(preferencias_ventana,"gnorba_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda[GNORBA]);
	}	
	//propiedades colores
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_nada.red,c_nada.green,c_nada.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_nada);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_nada);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_directiva.red,c_directiva.green,c_directiva.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_directiva);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_directiva);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_etiqueta.red,c_etiqueta.green,c_etiqueta.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_etiqueta);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_etiqueta);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_comentario.red,c_comentario.green,c_comentario.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_comentario);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_comentario);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cd.red,c_cadena_cd.green,c_cadena_cd.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_cadena_cd);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_cadena_cd);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cs.red,c_cadena_cs.green,c_cadena_cs.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_cadena_cs);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_cadena_cs);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_entero.red,c_entero.green,c_entero.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_entero);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_entero);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_real.red,c_real.green,c_real.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_real);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_real);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_hexadecimal.red,c_hexadecimal.green,c_hexadecimal.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_hexadecimal);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_hexadecimal);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_octal.red,c_octal.green,c_octal.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.negrita_octal);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.cursiba_octal);
	fuente=glade_xml_get_widget(preferencias_ventana,"fondo_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_fondo.red,c_fondo.green,c_fondo.blue,0);
	DEBUG_MSG(<-pref_mostrar);
}

void pref_xml_struct(void)
{
	xmlNodePtr xmlnode;
	gchar *texto;
	gint cont;
	
	DEBUG_MSG(->pref_xml_struct);
	xmlnode=preferencias.xml->xmlRootNode->xmlChildrenNode;

	texto=xmlGetProp(xmlnode,"nombre");
	g_free(preferencias.nombre);
	preferencias.nombre=texto;
	texto=xmlGetProp(xmlnode,"e-mail");
	g_free(preferencias.e_mail);
	preferencias.e_mail=texto;
	texto=xmlGetProp(xmlnode,"directorio");
	g_free(preferencias.directorio);
	preferencias.directorio=texto;
	texto=xmlGetProp(xmlnode,"texto_barras");
	preferencias.texto_barras=texto[0]-48;
	g_free(texto);

	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"auto");
	preferencias.auto_indentacion=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"super");
	preferencias.super_indentacion=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"llaves");
	preferencias.completar_llaves=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"tabulador");
	preferencias.tabulador=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"fuente");
	g_free(preferencias.fuente);
	preferencias.fuente=texto;
	texto=xmlGetProp(xmlnode,"numeros");
	preferencias.numeros=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next->xmlChildrenNode;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[GTK]);
	preferencias.ayuda[GTK]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[XML]);
	preferencias.ayuda[XML]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[GLIB]);
	preferencias.ayuda[GLIB]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[ORBIT]);
	preferencias.ayuda[ORBIT]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[GNOME]);
	preferencias.ayuda[GNOME]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[GNOMEUI]);
	preferencias.ayuda[GNOMEUI]=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda[GNORBA]);
	preferencias.ayuda[GNORBA]=texto;
	
	xmlnode=xmlnode->parent->next->xmlChildrenNode;
	texto=xmlGetProp(xmlnode,"rojo");
	c_fondo.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_fondo.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_fondo.blue=atoi(texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_nada.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_nada.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_nada.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_nada=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_nada=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_comentario.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_comentario.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_comentario.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_comentario=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_comentario=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_directiva.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_directiva.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_directiva.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_directiva=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_directiva=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_cadena_cs.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_cadena_cs.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_cadena_cs.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_cadena_cs=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_cadena_cs=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_cadena_cd.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_cadena_cd.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_cadena_cd.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_cadena_cd=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_cadena_cd=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_etiqueta.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_etiqueta.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_etiqueta.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_etiqueta=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_etiqueta=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_entero.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_entero.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_entero.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_entero=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_entero=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_real.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_real.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_real.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_real=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_real=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_hexadecimal.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_hexadecimal.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_hexadecimal.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_hexadecimal=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_hexadecimal=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_octal.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_octal.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_octal.blue=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"negrita");
	preferencias.negrita_octal=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"cursiba");
	preferencias.cursiba_octal=texto[0]-48;
	g_free(texto);
	
	xmlnode=xmlnode->parent->next->xmlChildrenNode;
	if (xmlnode!=NULL) {
		preferencias.ultimos[0]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[1]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[2]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[3]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[4]=xmlNodeGetContent(xmlnode);
	}
	
	xmlnode=buscar_nodo_xml((preferencias.xml)->xmlRootNode,"includes");
	for (cont=0;cont<LTOTALES;cont++) {
		g_free(preferencias.inc[cont]);
		preferencias.inc[cont]=xmlNodeGetContent(buscar_nodo_xml(xmlnode,pro_nombre_librerias_xml[cont]));
	}

	xmlnode=buscar_nodo_xml((preferencias.xml)->xmlRootNode,"librerias");
	for (cont=0;cont<LTOTALES;cont++) {
		g_free(preferencias.lib[cont]);
		preferencias.lib[cont]=xmlNodeGetContent(buscar_nodo_xml(xmlnode,pro_nombre_librerias_xml[cont]));
	}
	g_free(preferencias.lib_electric_fence);
	preferencias.lib_electric_fence=xmlNodeGetContent(buscar_nodo_xml(xmlnode,"electric_fence"));
	
	DEBUG_MSG(<-pref_xml_struct);
}

void pref_cerrar(void)
{
	gint cont;
	
	xmlFreeDoc(preferencias.xml);
	g_free(preferencias.nombre);
	g_free(preferencias.e_mail);
	g_free(preferencias.directorio);
//	g_free(preferencias.fuente); Esta cadena no hay que liberarla.
	for (cont=0;cont<TOTAL_AYUDAS;cont++) {
		g_free(preferencias.ayuda[cont]);
	}
	for (cont=0;cont<LTOTALES;cont++) {
		g_free(preferencias.inc[cont]);
	}
	for (cont=0;cont<LTOTALES;cont++) {
		g_free(preferencias.lib[cont]);
	}
	g_free(preferencias.lib_electric_fence);
}

void pref_aplicar(void)
{
	GtkWidget *widget1,*widget2;
	struct s_lista_archivos *archivos;
	int tipo;
	gint result;
	gchar *directorio_locale;
	gsize read, written;
	GError *error;
	PangoFontDescription *pfd;
	t_ext_lista_pestanas *externos;
	
	widget1=glade_xml_get_widget(david_ventana,"barra1_toolbar");
	widget2=glade_xml_get_widget(david_ventana,"barra2_toolbar");
	if (preferencias.texto_barras) {
		gtk_toolbar_set_style(GTK_TOOLBAR(widget1),GTK_TOOLBAR_BOTH);
		gtk_toolbar_set_style(GTK_TOOLBAR(widget2),GTK_TOOLBAR_BOTH);
	} else {
		gtk_toolbar_set_style(GTK_TOOLBAR(widget1),GTK_TOOLBAR_ICONS);
		gtk_toolbar_set_style(GTK_TOOLBAR(widget2),GTK_TOOLBAR_ICONS);
	}
	archivos=raiz_lista_archivos;
	while (archivos!=NULL) {
		tipo=gen_tipo_archivo(archivos->nombre);
		if ((tipo==1) || (tipo==2)) {
			edit_aplicar_reglas_coloreado(archivos->datos);
		}
		archivos=archivos->siguiente;
	}
	edit_aplicar_reglas_coloreado(edit_funciones_buffer);

	gtk_source_view_set_show_line_numbers(edit_editor,preferencias.numeros);
	gtk_source_view_set_show_line_numbers(edit_funciones,FALSE);
	
	pfd=pango_font_description_from_string(preferencias.fuente);
	gtk_widget_modify_font(GTK_WIDGET(edit_editor),pfd);
	gtk_widget_modify_font(GTK_WIDGET(edit_funciones),pfd);
	gtk_widget_modify_base(GTK_WIDGET(edit_editor),GTK_STATE_NORMAL,&c_fondo);
	gtk_widget_modify_base(GTK_WIDGET(edit_funciones),GTK_STATE_NORMAL,&c_fondo);
	gtk_widget_modify_text(GTK_WIDGET(edit_editor),GTK_STATE_NORMAL,&c_nada);
	gtk_widget_modify_text(GTK_WIDGET(edit_funciones),GTK_STATE_NORMAL,&c_nada);
	gtk_source_view_set_tab_stop(edit_editor,preferencias.tabulador);
	gtk_source_view_set_tab_stop(edit_funciones, preferencias.tabulador);
	archivos=raiz_lista_archivos;
	while (archivos!=NULL) {
		if (archivos->pestana>1) {
			gtk_widget_modify_base(GTK_WIDGET(archivos->editor),GTK_STATE_NORMAL,&c_fondo);
			gtk_widget_modify_text(GTK_WIDGET(archivos->editor),GTK_STATE_NORMAL,&c_nada);
			gtk_widget_modify_font(GTK_WIDGET(archivos->editor),pfd);
			gtk_source_view_set_tab_stop(archivos->editor,preferencias.tabulador);
			gtk_source_view_set_show_line_numbers(archivos->editor,preferencias.numeros);
		}
		archivos=archivos->siguiente;
	}
	externos=ext_lista_pestanas;
	while (externos!=NULL) {
		if ((externos->tipo==1) || (externos->tipo==2)) {
			edit_aplicar_reglas_coloreado(externos->buffer);
		}
		gtk_widget_modify_base(externos->view,GTK_STATE_NORMAL,&c_fondo);
		gtk_widget_modify_text(externos->view,GTK_STATE_NORMAL,&c_nada);
		gtk_widget_modify_font(externos->view,pfd);
		gtk_source_view_set_tab_stop(GTK_SOURCE_VIEW(externos->view),preferencias.tabulador);
		gtk_source_view_set_show_line_numbers(GTK_SOURCE_VIEW(externos->view),preferencias.numeros);
		externos=externos->siguiente;
	}
	pango_font_description_free(pfd);
	directorio_locale = g_locale_from_utf8(preferencias.directorio, -1, &read, &written, &error);
	result = mkdir (directorio_locale,0x1ed);
	if (result == -1) {
		if (errno != EEXIST) {
			gen_ventana_mensaje(_("Can't create the working directory. Check if you have the right permissions or if the parent directory exists. "),
				GTK_MESSAGE_ERROR);
		}
	}
	g_free(directorio_locale);
}
