/*****************************************************************

  x10.c -- routines for x10 remote input

  Copyright (c) 1999-2002 by Mike Oliphant - oliphant@gtk.org

    http://www.nostatic.org/grip

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include "x10.h"

static int x10_command(unsigned char c);

char *x10_button_names[]={
  "Invalid","Play","Stop","Rewind","FastForward",
  "Pause","Volume Up","Volume Down","Mute",
  "Skip Forward","Skip Backward","Display",
  "DVD Up","DVD Down","DVD Right","DVD Left",
  "DVD Ok","A-B","Title","Subtitle","Menu","Record",
  "Return","Recall","One","Two","Three",
  "Four","Five","Six","Seven","Eight","Nine","Zero"
};

unsigned char x10_button_codes[]={
  0,176,112,56,184,114,96,224,160,64,192,58,213,211,209,210,82,186,
  214,212,182,255,216,242,130,66,194,34,162,98,226,18,146,2};

int x10_init(char *ser_device)
{
  int ser_fd;
  struct termios oldtio,newtio;

  ser_fd=open(ser_device,O_RDWR|O_NOCTTY|O_NONBLOCK);

  if(ser_fd<0) {
    printf("unable to open %s\n",ser_device);

    return -1;
  }

  tcgetattr(ser_fd,&oldtio); /* save current port settings */
  
  bzero(&newtio, sizeof(newtio));
  newtio.c_cflag = BAUDRATE | CRTSCTS | CS8 | CLOCAL | CREAD;
  newtio.c_iflag = IGNPAR;
  newtio.c_oflag = 0;
  
  /* set input mode (non-canonical, no echo,...) */
  newtio.c_lflag = 0;
  
  newtio.c_cc[VTIME]    = 0;   /* inter-character timer unused */
  newtio.c_cc[VMIN]     = 5;   /* blocking read until n chars received */
  
  tcflush(ser_fd, TCIFLUSH);                 
  tcsetattr(ser_fd,TCSANOW,&newtio);  

  return ser_fd;
}

int x10_get_event(int ser_fd)
{
  int res;
  char buf[10];
  int cmd;

  res=read(ser_fd,buf,10);
  if(res<=0) return -1;

  /*  printf("val is %d\n",(unsigned char)buf[3]);*/

  cmd=x10_command(buf[3]);

  return cmd;
}

static int x10_command(unsigned char c)
{
  int cmd;

  for(cmd=1;cmd<34;cmd++) if(c==x10_button_codes[cmd]) return cmd;

  return X10_INVALID;
}

void x10_close(int ser_fd)
{
  close(ser_fd);
}  
