#include <qpainter.h>
#include <qpen.h>
#include <qpixmap.h>
#include "display.h"
#include "mainwnd.h"
#include <stdio.h>
#include <qtimer.h>
#include <math.h>
#include "jack.h"

DDisplay::DDisplay(QWidget *p, QWidget *m, const char *name, WFlags f) : QWidget(p, name, f)
{
	blink_on=0;
	mainwnd=m;
}

DDisplay::~DDisplay()
{
}

QWidget *DDisplay::main_wnd()
{
	return mainwnd;
}

void DDisplay::paintEvent(QPaintEvent *pe)
{
	QPixmap pm(size());
	QPainter p;
	p.begin(&pm, this);

	draw(&p);

	bitBlt(this, 0, 0, &pm);
}

void DDisplay::draw(QPainter *p)
{
//	QPen erp(QColor(192, 192, 192));
//	QBrush erb(QColor(192, 192, 192));

	QPen bgp(QColor(0, 0, 0));
	QBrush bgb(QColor(0, 0, 0));

//	p->setPen(erp);
//	p->setBrush(erb);

//	p->drawRect(rect());

	p->setPen(bgp);
	p->setBrush(bgb);

	p->drawRect(rect());

	int max_samp=((MainWnd *)main_wnd())->get_max_peak_value();
	int samp=((MainWnd *)main_wnd())->get_peak_value();

	QPen tp(QColor(36, 152, 255));
	QString strText;
	QFont f;
	p->setPen(tp);
	unsigned frame=((MainWnd *)main_wnd())->get_total_frames()-((MainWnd *)main_wnd())->get_frame();
	unsigned basetime=frame/(((MainWnd *)main_wnd())->get_sample_rate()/100);
	unsigned hours=basetime/360000;
	unsigned minutes=(basetime/6000)%60;
	unsigned seconds=(basetime/100)%60;
	unsigned twips=basetime%100;
	bool blink_time=0;
	if(twips < 50)
		blink_on=1;
	else
		blink_on=0;
	if(hours < 1 && minutes < 2 && (minutes < 1 || seconds < 30) && ((MainWnd *)main_wnd())->isPlaying())
		blink_time=1;
	strText.sprintf("%u:%02u:%02u", hours, minutes, seconds);
	f=font();
	f.setPixelSize(32);
	p->setFont(f);
	QRect rct=p->boundingRect(50, 32, 10000, 10000, AlignLeft | AlignTop, strText);
	if(!blink_time || blink_on)
		p->drawText(50, 32, strText);
	strText.sprintf("%02d", twips);
	f.setPixelSize(18);
	p->setFont(f);
	if(!blink_time || blink_on)
		p->drawText(rct.right()+5, 32, strText);

	f.setPixelSize(12);
	p->setFont(f);
	QPen np(QColor(255, 255, 255));
	p->setPen(np);

	int pw=(int)((float)(rect().width())*0.55);

#if 0
	QString raw_name=((MainWnd *)main_wnd())->fileName();
	int pos;;
	if((pos=raw_name.find(" - ")) == -1)
	{
		p->drawText(5, 57, raw_name);
	}
	else
	{
		QString artist=raw_name.left(pos);
		QString title=raw_name.mid(pos+3);

		p->drawText(5, 50, artist);
		p->drawText(5, 63, title);
	}
#endif

	if(((MainWnd *)main_wnd())->get_source())
	{
		QString artist=((MainWnd *)main_wnd())->get_source()->artist();
		QString title=((MainWnd *)main_wnd())->get_source()->title();

		if(artist != "" && title != "")
		{
			p->drawText(width()-pw-1, 13, artist+" - "+title);
		}
		else
		{
			if(artist == "")
				artist=title;
			p->drawText(width()-pw-1, 13, artist);
		}
	}
	f=font();
	f.setPixelSize(16);
	p->setFont(f);
	strText.sprintf("%2.1lf%%", ((MainWnd*)main_wnd())->get_base_pitch());
	rct=p->boundingRect(50, 50, 10000, 10000, AlignLeft | AlignTop, strText);
	p->drawText(width()-rct.width()-pw-20, rct.height()*2, strText);

	QPen bpm_pen(QColor(244, 109, 13));
	p->setPen(bpm_pen);

	QString strBPM;
	float bpm=((MainWnd *)main_wnd())->bpm();
	if(bpm == -1.0f)
		strBPM="---.-";
	else if(bpm == 0.0f)
		strBPM="";
	else
	{
		double base_pitch=((MainWnd*)main_wnd())->get_base_pitch();
		strBPM.sprintf("%3.1f", bpm*(1.0f+((float)base_pitch/100.0f)));
	}

	rct=p->boundingRect(50, 50, 10000, 10000, AlignLeft | AlignTop, strBPM);
	p->drawText(width()-rct.width()-pw-20, rct.height(), strBPM);


	QPixmap wave(pw, 32);
	((MainWnd *)main_wnd())->get_wave_pixmap(&wave);
	p->drawPixmap(width()-pw-1, height()-34, wave);

	((MainWnd *)main_wnd())->Draw3dRect(p, rect(), true, QColor(255, 255, 255), QColor(128, 128, 128));
}
