#include "frame.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "config.h"
#include "jack.h"
#include "mixer.h"
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "plugins/bitmapslider/bitmapslider.h" 
#include <qapplication.h>
#include "metatracker.h"
#include "cfgfile.h"
#include "mixerpanel.h"

extern MixerPanel *mix1, *mix2;

static int debounce_key=-1;
static int left_mode=1,right_mode=1;

#ifdef HAVE_LIBSDL
extern "C" {
#include <SDL.h>
#include <SDL_syswm.h>
}
#endif

#include <qsocketnotifier.h>
#include <qtimer.h>

#define ACCEL_START 30

static void console_event(void *c, int code, int value)
{
	Frame *f=(Frame *)c;

	f->consoleEvent(code, value);
}

Client *Frame::client()
{
	return j_client;
}

int prev_axis[128];

Frame::Frame(QWidget *parent, const char *name = 0, WFlags f = 0) : QWidget(parent, name, f)
{
	lv_on=true;
	rv_on=true;
	video_mode_on=false;
	left_factor=1.0f;
	right_factor=0.0f;
	left_source=0;
	right_source=0;
	left_buffer=0;
	right_buffer=0;
	frame1=frame2=0;
	metatracker=new Metatracker(this);
	blink_on=false;
	mouse_flag=0;
	event_fd=-1;
	mouse_seek=0;
#ifdef HAVE_LIBSDL
	display=0;
	vthread=0;

#ifdef USE_VIDEO
	int i;

	left_buffer=new unsigned char *[480];
	right_buffer=new unsigned char *[480];
	blank_buffer=new unsigned char *[480];

	for(i=0;i<480;++i)
	{
		left_buffer[i]=new unsigned char[640*3+4];
		right_buffer[i]=new unsigned char[640*3+4];
		blank_buffer[i]=new unsigned char[640*3+4];
		memset(blank_buffer[i], 0, 640*3+4);
	}

	if(video_on)
	{
		if(video_display[0])
		{
			memmove(video_display+8, video_display, strlen(video_display));
			memcpy(video_display, "DISPLAY=", 8);
			putenv(video_display);
		}
		if(SDL_Init(SDL_INIT_VIDEO) < 0)
		{
			printf("Failed to init SDL\n");
		}
		else
		{
			atexit(SDL_Quit);

			display=SDL_SetVideoMode(640, 480, 16, SDL_SWSURFACE);
			if(display)
			{
				SDL_WM_SetCaption("DJPlay video", NULL);
				vthread=new VThread();
				vthread->frame=this;
				vthread->start();
				wm_info=(void *)new SDL_SysWMinfo;
				SDL_VERSION(&((SDL_SysWMinfo*)wm_info)->version);
				int cc=SDL_GetWMInfo((SDL_SysWMinfo*)wm_info);
				(*((SDL_SysWMinfo*)wm_info)->info.x11.lock_func)();
				printf("SDL X display is %08lx, win is %08lx\n", ((SDL_SysWMinfo*)wm_info)->info.x11.display, ((SDL_SysWMinfo*)wm_info)->info.x11.window);
				(*((SDL_SysWMinfo*)wm_info)->info.x11.unlock_func)();
				Window parent_win;
				Window root_win;
				Window* child_windows;
				unsigned int num_child_windows;
				XQueryTree(((SDL_SysWMinfo*)wm_info)->info.x11.display, ((SDL_SysWMinfo*)wm_info)->info.x11.window,
						&root_win,
						&parent_win,
						&child_windows, &num_child_windows);
				XFree(child_windows);
				sdl_frame=parent_win;
				printf("SDL Frame window is %08lx\n", parent_win);
				if(video_display[0])
				{
					XUnmapWindow(((SDL_SysWMinfo*)wm_info)->info.x11.display, sdl_frame);
					XFlush(((SDL_SysWMinfo*)wm_info)->info.x11.display);
				}
			}
			else
			{
				printf("Error allocating display\n");
			}
		}
	}
#endif
#endif

	
	s_mixer=0;
	j_client=new Client();
	if(!j_client->init("DJPlay"))
		return;

	pfl_left=new Port(j_client, "pfl_left", -1, Port::Output, Port::Clear);
	pfl_right=new Port(j_client, "pfl_right", -1, Port::Output, Port::Clear);

	key_timer=new QTimer(this);
	connect(key_timer, SIGNAL(timeout()), this, SLOT(key_timeout()));

	if(dj.ready())
	{
		blink_timer=new QTimer(this);
		connect(blink_timer, SIGNAL(timeout()), this, SLOT(blink_timeout()));
		blink_timer->start(500);
	}
}

Frame::~Frame()
{
#ifdef HAVE_LIBSDL
	if(vthread)
		delete vthread;
#endif
	if(left_buffer)
	{
		int i;

		for(i=0;i<480;++i)
			delete left_buffer[i];
		delete left_buffer;
	}
	if(right_buffer)
	{
		int i;

		for(i=0;i<480;++i)
			delete right_buffer[i];
		delete right_buffer;
	}
	
	delete pfl_left;
	delete pfl_right;
	delete j_client;
	delete key_timer;
	delete metatracker;
}

void Frame::setFrames(MainWnd *f1, MainWnd *f2)
{
	frame1=f1;
	frame2=f2;
}

void Frame::consoleEvent(int code, int v)
{
	int pitch_value;
	int value;

	int button_base;
	int other_button;
	int step_value;
	int delta;
	MainWnd *curframe;

	app->lock();
	if(code > BUTTONS && code != MOUSE_L && code != MOUSE_R)
	{
//		printf("Axis event, axis %d, value %d\n", code, v);
		switch(code)
		{
/*
			case MOUSE_Y:
				delta=(int)((char)(unsigned char)(v& 0xff));
				if(delta < 50 && delta > -50)
				{
					if(mouse_seek)
						mouse_seek->SeekBack_released();
					mouse_seek=0;
					app->unlock();
					return;
				}

				{
					MainWnd *framep=0;
					if(frame1 && frame1->get_source() && frame1->get_source()->is_playing() and frame1->is_seeking())
						framep=frame1;
					if(frame2 && frame2->get_source() && frame2->get_source()->is_playing() and frame2->is_seeking())
						framep=frame2;
					if(framep)
					{
printf("real delta %d\n", delta);
						if(!mouse_seek)
						{
							if(delta < -50)
								framep->SeekForward_pressed();
							else if(delta > 50)
								framep->SeekBack_pressed();
							mouse_seek=framep;
						}
					}
				}
				break;
*/
			case MOUSE_X:
				delta=(int)((char)(unsigned char)(v& 0xff));
				if((delta < 0 && mouse_flag > 0) || (delta > 0 && mouse_flag < 0))
					mouse_flag=0;

				if(delta < 70 && delta > -70)
				{
					app->unlock();
					mouse_flag=0;
					return;
				}

				if((delta > 70 && mouse_flag <= 70) || (delta < -70 && mouse_flag >= -70))
				{
					MainWnd *framep=0;

					mouse_flag=delta;

					if(frame1 && frame1->get_source() && frame1->get_source()->is_playing() and frame1->is_seeking())
						framep=frame1;
					if(frame2 && frame2->get_source() && frame2->get_source()->is_playing() and frame2->is_seeking())
						framep=frame2;
					if(framep)
					{
						if(delta > 0)
							framep->step_forward(framep->get_sample_rate()*5);
						else
							framep->step_back(framep->get_sample_rate()*5);
					}
                }
				break;
			case RIGHT_BASS: // Right bass
				value=(int)((double)v/1.275+0.4)-100;
				if(mix2)
					mix2->Low->setValue(value);
				break;
			case RIGHT_MID: // Right mid
				value=(int)((double)v/1.275+0.4)-100;
				if(mix2)
					mix2->Mid->setValue(value);
				break;
			case XFADER: // Crossfader
				value=((int)((double)v/1.275+0.4));
				if(mixer())
					mixer()->XFader->setValue(value);
				break;
			case LEFT_BASS: // Left bass
				value=(int)((double)v/1.275+0.4)-100;
				if(mix1)
					mix1->Low->setValue(value);
				break;
			case LEFT_MID: // Left mid
				value=(int)((double)v/1.275+0.4)-100;
				if(mix1)
					mix1->Mid->setValue(value);
				break;
			case LEFT_HIGH: // Left treble
				value=(int)((double)v/1.275+0.4)-100;
				if(mix1)
					mix1->High->setValue(value);
				break;
			case RIGHT_HIGH: // Right treble
				value=(int)((double)v/1.275+0.4)-100;
				if(mix2)
					mix2->High->setValue(value);
				break;
			case LEFT_PITCH: // Left pitch
				pitch_value=-((int)((double)v/1.59375+0.4)-80);
				frame1->set_base_pitch(pitch_value);
				break;
			case RIGHT_PITCH: // Right pitch
				pitch_value=-((int)((double)v/1.59375+0.4)-80);
				frame2->set_base_pitch(pitch_value);
				break;
			case LEFT_VOL: // Left volume
				if(prev_axis[code]-(int)v < -120)
					prev_axis[code]+=256;
				else if(prev_axis[code]-(int)v > 120)
					prev_axis[code]-=265;
				if((int)v > prev_axis[code])
					delta=1;
				else
					delta=-1;
				if(mix1)
				{
					value=mix1->Gain->value();
					value-=delta;
					if(value < 0)
						value=0;
					if(value > 100)
						value=100;
					mix1->Gain->setValue(value);
				}
				break;
			case RIGHT_VOL: // Right volume
				if(prev_axis[code]-(int)v < -120)
					prev_axis[code]+=256;
				else if(prev_axis[code]-(int)v > 120)
					prev_axis[code]-=265;
				if((int)v > prev_axis[code])
					delta=1;
				else
					delta=-1;
				if(mix2)
				{
					value=mix2->Gain->value();
					value-=delta;
					if(value < 0)
						value=0;
					if(value > 100)
						value=100;
					mix2->Gain->setValue(value);
				}
				break;
			case LEFT_JOG: // Left jog wheel
				if(prev_axis[code]-(int)v < -120)
					prev_axis[code]+=256;
				else if(prev_axis[code]-(int)v > 120)
					prev_axis[code]-=256;
				if((int)v > prev_axis[code])
					delta=1;
				else
					delta=-1;
				if(frame1 && frame1->get_source() && frame1->get_source()->is_playing() and frame1->is_seeking())
				{
					if(delta > 0)
						frame1->step_forward(1000);
					else
						frame1->step_back(1000);
				}
				break;
			case RIGHT_JOG: // Right jog wheel
				if(prev_axis[code]-(int)v < -120)
					prev_axis[code]+=256;
				else if(prev_axis[code]-(int)v > 120)
					prev_axis[code]-=265;
				if((int)v > prev_axis[code])
					delta=1;
				else
					delta=-1;
				if(frame2 && frame2->get_source() && frame2->get_source()->is_playing() and frame2->is_seeking())
				{
					if(delta > 0)
						frame2->step_forward(1000);
					else
						frame2->step_back(1000);
				}
				break;
		}
		prev_axis[code]=v;
	}
	else
	{
		if(code == debounce_key)
		{
			app->unlock();
			return;
		}

		if(!v)
		{
			debounce_key=code;
			key_timer->stop();
			key_timer->start(30, true);
		}

//				printf("Key event, key %d, value %d\n", js.code, v);
		switch(code)
		{
			case RIGHT_FX_SELECT: // Right mode
				if(!v)
					break;
				switch(right_mode)
				{
					case 0:
						set_led(1, FX_LED, 0);
						break;
					case 1:
						set_led(1, CUE_FX_LED, 0);
						break;
					case 2:
						set_led(1, LOOP_LED, 0);
						break;
				}
				right_mode++;
				if(right_mode > 2)
					right_mode=0;
				switch(right_mode)
				{
					case 0:
						set_led(1, FX_LED, 1);
						break;
					case 1:
						set_led(1, CUE_FX_LED, 1);
						break;
					case 2:
						set_led(1, LOOP_LED, 1);
						break;
				}
				break;
			case RIGHT_PLAY: // Right play
				if(v)
					frame2->PlayButton_clicked();
				break;
			case RIGHT_CUE: // Right cue
				if(v)
				{
					if(frame2->get_source() && frame2->get_source()->is_playing())
						frame2->CueButton_clicked();
					else
					{
						frame2->SeekBack_pressed();
						frame2->SeekBack_released();
					}
				}
				break;
			case RIGHT_SKIP_BACK: // Right previous
				if(v)
					frame2->SkipBack_clicked();
				break;
			case RIGHT_SKIP_FORWARD: // Right next
				if(v)
					frame2->SkipFwd_clicked();
				break;
			case LEFT_FX_SELECT: // Left mode
				if(!v)
					break;
				switch(left_mode)
				{
					case 0:
						set_led(0, FX_LED, 0);
						break;
					case 1:
						set_led(0, CUE_FX_LED, 0);
						break;
					case 2:
						set_led(0, LOOP_LED, 0);
						break;
				}
				left_mode++;
				if(left_mode > 2)
					left_mode=0;
				switch(left_mode)
				{
					case 0:
						set_led(0, FX_LED, 1);
						break;
					case 1:
						set_led(0, CUE_FX_LED, 1);
						break;
					case 2:
						set_led(0, LOOP_LED, 1);
						break;
				}
				break;
			case LEFT_PLAY: // Left play
				if(v)
					frame1->PlayButton_clicked();
				break;
			case LEFT_CUE: // Left cue
				if(v)
				{
					if(frame1->get_source() && frame1->get_source()->is_playing())
						frame1->CueButton_clicked();
					else
					{
						frame1->SeekBack_pressed();
						frame1->SeekBack_released();
					}
				}
				break;
			case LEFT_SKIP_BACK: // Left previous
				if(v)
					frame1->SkipBack_clicked();
				break;
			case LEFT_SKIP_FORWARD: // Left next 
				if(v)
					frame1->SkipFwd_clicked();
				break;
			case LEFT_3: // Left 3
			case LEFT_2: // Left 2
			case LEFT_1: // Left 1
			case RIGHT_1: // Right 1
			case RIGHT_2: // Right 2
			case RIGHT_3: // Right 3
			case LEFT_MASTER_TEMPO: // Left tempo
			case RIGHT_MASTER_TEMPO: // RIght tempo
			case LEFT_AUTO_BEAT: // Left beat match
			case RIGHT_AUTO_BEAT: // Right beat match
			case LEFT_PITCH_UP: // Left bend up
				if(v)
					frame1->BendUp_pressed();
				else
					frame1->BendUp_released();
				break;
			case LEFT_PITCH_DOWN: // Left bend down
				if(v)
					frame1->BendDown_pressed();
				else
					frame1->BendDown_released();
				break;
			case LEFT_MONITOR: // Left pfl
				if(mix1 && v)
					mix1->Pfl->toggle();
				break;
			case RIGHT_PITCH_UP: // Right bend up
				if(v)
					frame2->BendUp_pressed();
				else
					frame2->BendUp_released();
				break;
			case RIGHT_PITCH_DOWN: // Right bend down
				if(v)
					frame2->BendDown_pressed();
				else
					frame2->BendDown_released();
				break;
			case RIGHT_MONITOR: // Right pfl
				if(mix2 && v)
					mix2->Pfl->toggle();
				break;
		}
	}
	app->unlock();
}

void Frame::key_timeout()
{
	debounce_key=-1;
}

void Frame::closeEvent(QCloseEvent *e)
{
#ifdef HAVE_LIBSDL
	if(vthread)
		delete vthread;
	vthread=0;
#endif
	emit windowClosed();
}

MainWnd *Frame::left()
{
	return frame1;
}

MainWnd *Frame::right()
{
	return frame2;
}

MainWnd *Frame::player(int p)
{
	if(p < 0 || p > 1)
		return 0;
	if(!p)
		return left();
	return right();
}

Mixer *Frame::mixer()
{
	return s_mixer;
}

void Frame::setMixer(Mixer *m)
{
	s_mixer=m;
}

Playlist *Frame::playlist()
{
	return s_playlist;
}

void Frame::setPlaylist(Playlist *p)
{
	s_playlist=p;
}

void Frame::VideoXFader_valueChanged(int val)
{
	left_factor=(float)(100-val)/100.0f;
	right_factor=(float)(val)/100.0f;
	setVideoMode();
}

unsigned char **Frame::get_frame_buffer(int player)
{
	switch(player)
	{
	case 1:
		return left_buffer;
	case 2:
		return right_buffer;
	}
	return 0;
}

void Frame::enableLeftVideo(bool on)
{
	lv_on=on;
	setVideoMode();
}

void Frame::enableRightVideo(bool on)
{
	rv_on=on;
	setVideoMode();
}

void Frame::setVideoMode()
{
	if(!s_mixer)
		return;
	clear_lock.lock();
	StreamSource *s1=frame1->get_source(), *s2=frame2->get_source();
	bool lv=false, rv=false;
	if(s1 && s1->has_video() && s1->is_playing())
		lv=true;
	if(s2 && s2->has_video() && s2->is_playing())
		rv=true;
	clear_lock.unlock();

	if(s_mixer->VideoXFader->value() == 0)
		rv=false;
	if(s_mixer->VideoXFader->value() == 100)
		lv=false;

	bool on=false;
	if((lv && lv_on) || (rv && rv_on))
		on=true;
	
	if(video_mode_on != on)
	{
		if(on)
		{
#ifdef USE_VIDEO
			if(video_display[0])
			{
				app->lock();
				(*((SDL_SysWMinfo*)wm_info)->info.x11.lock_func)();
				XMapRaised(((SDL_SysWMinfo*)wm_info)->info.x11.display, sdl_frame);
				XFlush(((SDL_SysWMinfo*)wm_info)->info.x11.display);
				(*((SDL_SysWMinfo*)wm_info)->info.x11.unlock_func)();
				app->unlock();
			}
#endif
		}
		else
		{
#ifdef USE_VIDEO
			if(video_display[0])
			{
				app->lock();
	printf("Lower Video Window\n");
				(*((SDL_SysWMinfo*)wm_info)->info.x11.lock_func)();
				XUnmapWindow(((SDL_SysWMinfo*)wm_info)->info.x11.display, sdl_frame);
				XFlush(((SDL_SysWMinfo*)wm_info)->info.x11.display);
				(*((SDL_SysWMinfo*)wm_info)->info.x11.unlock_func)();
				app->unlock();
			}
#endif
		}
		video_mode_on=on;
	}
}

void Frame::new_track(int player_number)
{
}

void Frame::set_led(int player, int led, int on)
{
	if(player ==  0)
	{
		switch(led)
		{
			case PLAY_LED:
				dj.Leds.setBit(LEFT_PLAY, on);
				break;
			case CUE_LED:
				dj.Leds.setBit(LEFT_CUE, on);
				break;
			case PFL_LED:
				dj.Leds.setBit(LEFT_MONITOR, on);
				break;
			case FX_LED:
				dj.Leds.setBit(LEFT_FX, on);
				break;
			case LOOP_LED:
				dj.Leds.setBit(LEFT_LOOP, on);
				break;
			case CUE_FX_LED:
				dj.Leds.setBit(LEFT_FX_CUE, on);
				break;
			case AUTO_BEAT_LED:
				dj.Leds.setBit(LEFT_AUTO_BEAT, on);
				break;
			case MASTER_TEMPO_LED:
				dj.Leds.setBit(LEFT_MASTER_TEMPO, on);
				break;
		}
	}
	else
	{
		switch(led)
		{
			case PLAY_LED:
				dj.Leds.setBit(RIGHT_PLAY, on);
				break;
			case CUE_LED:
				dj.Leds.setBit(RIGHT_CUE, on);
				break;
			case PFL_LED:
				dj.Leds.setBit(RIGHT_MONITOR, on);
				break;
			case FX_LED:
				dj.Leds.setBit(RIGHT_FX, on);
				break;
			case LOOP_LED:
				dj.Leds.setBit(RIGHT_LOOP, on);
				break;
			case CUE_FX_LED:
				dj.Leds.setBit(RIGHT_FX_CUE, on);
				break;
			case AUTO_BEAT_LED:
				dj.Leds.setBit(RIGHT_AUTO_BEAT, on);
				break;
			case MASTER_TEMPO_LED:
				dj.Leds.setBit(RIGHT_MASTER_TEMPO, on);
				break;
		}
	}
}

void Frame::blink_timeout()
{
	blink_on=!blink_on;

	if(!frame1 || !frame2)
		return;
	if(frame1->get_source() && frame1->get_source()->is_playing() && frame1->is_seeking())
		set_led(0, CUE_LED, blink_on);

	if(frame2->get_source() && frame2->get_source()->is_playing() && frame2->is_seeking())
		set_led(1, CUE_LED, blink_on);
}

void Frame::startConsole()
{
	dj.setCallback(console_event, this);

	dj.loadData();

	dj.Leds.setBit(RIGHT_FX_CUE);
	dj.Leds.setBit(LEFT_FX_CUE);
	dj.Leds.setBit(RIGHT_CUE);
	dj.Leds.setBit(LEFT_CUE);
}
