#include "vthread.h"
#if 0
#include <pthread.h>
#include <unistd.h>
#endif

#ifdef HAVE_LIBSDL

#include "jack.h"

VThread::VThread()
{
	quit=false;
	blank=true;
}

VThread::~VThread()
{
	quit=true;
	while(!finished())
		usleep(40000);
}

void VThread::run()
{
#if 0
	struct sched_param p;
	p.sched_priority=10;

	if(seteuid(0) < 0)
	{
		printf("Video player cannot su to root\n");
	}
	else
	{
		if(pthread_setschedparam(pthread_self(), SCHED_FIFO, &p) < 0)
		{
			printf("Cannot set schduling policy to realtime\n");
		}
	}
	seteuid(getuid());
#endif

	frame->clear_lock.lock();
	while(!quit)
	{
		frame->clear_lock.unlock();
		usleep(10000);
		frame->clear_lock.lock();
		if(!frame->video_mode_on)
			continue;
		if(!frame->frame1 || !frame->frame2)
			continue;
		StreamSource *s1=frame->frame1->get_source(), *s2=frame->frame2->get_source();
		bool lv_on=frame->lv_on;
		bool rv_on=frame->rv_on;

		float lf=frame->left_factor;
		float rf=frame->right_factor;
		if(lv_on && s1 && lf != 0.0f)
			s1->decode_video();
		if(rv_on && s2 && rf != 0.0f)
			s2->decode_video();
		if((!lv_on || !s1 || !s1->get_frame()) &&
				(!rv_on || !s2 || !s2->get_frame()))
			continue;

		int dl=(int)(64.0f*lf);
		int dr=(int)(64.0f*rf);

		unsigned char **lb=frame->left_buffer, **rb=frame->right_buffer;

		if(!lv_on)
			lb=frame->blank_buffer;
		if(!rv_on)
			rb=frame->blank_buffer;

		if(!lv_on && !rv_on)
			blank=true;
		else
			blank=false;
//		if(s1)
//			s1->lock_frame();
//		if(s2)
//			s2->lock_frame();

		register int i, j;
		register Uint32 color;
		register int row=frame->display->pitch/2;
		register void * pix=frame->display->pixels;

		pthread_yield();
		for(i=0;i<480;i++)
		{
			for(j=0;j<640;j++)
			{
				register Uint16 l=*(Uint16 *)&lb[i][j*2];
				register Uint16 r=*(Uint16 *)&rb[i][j*2];
				register unsigned int val=((((l&0xf800)*(dl>>1))>>5)&0xf800)+
										  ((((l&0x07e0)*dl)>>6)&0x07e0)+
										  ((((l&0x001f)*(dl>>1))>>5)&0x001f)+
										  ((((r&0xf800)*(dr>>1))>>5)&0xf800)+
										  ((((r&0x07e0)*dr)>>6)&0x07e0)+
										  ((((r&0x001f)*(dr>>1))>>5)&0x001f);
				*((Uint16 *)pix+i*row+j)=(Uint16)val;
			}
		}

//		if(s1)
//			s1->unlock_frame();
//		if(s2)
//			s2->unlock_frame();
		SDL_Flip(frame->display);
	}
	frame->clear_lock.unlock();
}

#endif
