#include <qevent.h>
#include "wavelet.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <stdlib.h>

#define WAVE_ZOOM 512

Wavelet::Wavelet()
{
	start=0;
	count=0;
	pixmap=NULL;
	max_wavelet_value=0;
}

Wavelet::Wavelet(StreamSource *str_source, unsigned long start_position, int sample_count)
{
	source=str_source;
	start=start_position;
	count=sample_count;
	max_wavelet_value=0;
	pixmap=NULL;
}

Wavelet::~Wavelet()
{
	if(pixmap)
		free(pixmap);
}

void Wavelet::loadBuffer(char *buf, int real)
{
	int smp=0;
	int i;

	int x;
	pixmap=(char *)malloc(x=((count+511)/512));

	while(smp < count)
	{
		int sum=0;
		for(i=0;i<WAVE_ZOOM;i++)
			if(smp < real)
				sum+=(*(((short *)buf)+smp+i))/64;
		sum/=WAVE_ZOOM;
		if(sum < 0) sum=-sum;
		if(sum < 16 && sum > 8)
			sum=16;
		sum/=5;
		if(sum > 15)
			sum=15;

		pixmap[smp/512]=sum;
		int tst=(sum < 0 ? -sum : sum);
		if(max_wavelet_value < tst)
			max_wavelet_value=tst;

		smp+=512;
	}
}

void Wavelet::load(void)
{
	char *buf=new char[count*sizeof(short)*2];

	int real=source->get_buffer(buf, count);

	int smp=0;
	int i;

	int x;
	pixmap=(char *)malloc(x=((count+511)/512));

	while(smp < count)
	{
		int sum=0;
		for(i=0;i<WAVE_ZOOM;i++)
			if(smp < real)
				sum+=(*(((short *)buf)+smp+i))/64;
		sum/=WAVE_ZOOM;
		if(sum < 0) sum=-sum;
		if(sum < 16 && sum > 8)
			sum=16;
		sum/=5;
		if(sum > 15)
			sum=15;

		pixmap[smp/512]=sum;
		int tst=(sum < 0 ? -sum : sum);
		if(max_wavelet_value < tst)
			max_wavelet_value=tst;

		smp+=512;
	}
	delete buf;
}
