/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Web interface
 */
/* 
 * a web interface.
 * 2001 Jul 13
 * $Id: dmachinemon-htmloutput.c,v 1.5 2001/12/09 12:57:24 dancer Exp $
 */
/* 
 * GTK+ interface for load average monitor program.
 * 2001 Jun 9 Junichi Uekawa
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <pthread.h>
#include "VERSION.h"
#include <math.h>

#include <dmachinemon/dmachinemon.h>

char * hostname ;
char * portnumber;

void printdots(int c)
{
  while ( c-- )
    printf("*");  
}

void processing_command ()
{
  int fd = dm_connect_to_host(hostname, atoi(portnumber));
  FILE* f=(fd!=-1)?fdopen (fd, "r"):NULL;
  dm_machinelist * new = NULL;

  if (!f)
    {
      fprintf (stderr, "dmachinemon-htmloutput: cannot open server socket\n");
      exit(1);
    }

  if (dm_process_nodes_input (f, &maininfo, NULL, NULL))
    {
      fprintf (stderr, "Could not handle input...\n");
      exit (1);
    }  
  fclose(f);

				/* displaying process */
  new = maininfo.machinedb;
  while(new)
    {
      printf ("<tr><td>%s</td>"
	      "<td background=\"gradationbackground.png\">",
	      dm_get_value_text(new, "machine"));
      printf ("<img src=\"gradationbox.png\" height=\"8\" width=\"%i\" "
	      "alt=\"",
	      (int)(dm_get_value_float(new, "load1") * 100.0));
      
      printdots((int)(dm_get_value_float(new, "load1") * 10.0));

      printf ("\">"
	      "</td>"
	      "<td><img src=\"gradationbox.png\" height=\"8\" width=\"%i\" alt=\"",
	      (int) ( dm_get_value_float(new, "memused")/
		      dm_get_value_float(new, "memtotal") * 100.0 ));

      printdots(( dm_get_value_float(new, "memused")/
		      dm_get_value_float(new, "memtotal") * 10.0 ));

      printf ("\">"
	      "<img src=\"gradationbackground.png\" height=\"8\" width=\"%i\" alt=\".\"></td>"
	      "<td>%.1fMB/%.1fMB</td>"
	      "<td><img src=\"faceimage/%s.png\" width=\"40\" height=\"40\" alt=\"%s\"></td>"
	      "<td>%s</td>"
	      "",
	      100 - (int) ( dm_get_value_float(new, "memused")/
		      dm_get_value_float(new, "memtotal") * 100.0 ), 
	      dm_get_value_float(new, "memused")/1024.0/1024.0,
	      dm_get_value_float(new, "memtotal")/1024.0/1024.0,
	      dm_get_value_text(new, "topuser"),
	      dm_get_value_text(new, "topuser"),
	      dm_get_value_text(new, "topprocess")
	      );
      
      printf ("<td><img src=\"gradationbox.png\" height=\"8\" width=\"%f\" alt=\"%s\"></td>",
	      log10(atof(dm_get_value_text(new, "network-eth0-send")) + 1 ) * 30,
	      dm_get_value_text(new, "network-eth0-send")
	      );
      printf ("<td><img src=\"gradationbox.png\" height=\"8\" width=\"%f\" alt=\"%s\"></td>",
	      log10(atol(dm_get_value_text(new, "network-eth0-recv")) + 1 ) * 30,
	      dm_get_value_text(new, "network-eth0-recv")
	      );

      /* end of one line */
      printf ("</tr>\n");
      
      
      new = new -> next;
    }  
  
  return ;  
}

int main(int ac, char ** av)
{ 
  dm_commandoption cdat;
  time_t t = time(NULL);

  setlocale(LC_TIME, "");

  dmachinemon_parse_options(ac, av, &cdat);
  if (!cdat.parenthostname)
    {
      fprintf (stderr, 
	       "%s v. %s \n\n"
	       "Not enough command-line information specified\n\n",
	       av[0],
	       DMACHINEMON_VERSION
	       );
      dmachinemon_print_commandline_help();
      return 1;
    }

  hostname=cdat.parenthostname;
  portnumber=cdat.port_client;

  printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n"
	 "<html><head>"
	 "<meta http-equiv=\"refresh\" content=\"60\">" 
	 "<link title=\"Mainstyle\"
    href=\"./dmachinemon.css\"
    type=\"text/css\" rel=\"stylesheet\">"
	 "<title>%s</title></head><body>\n"
	 "<table>\n"
	 "<tr>"
	 "<td>Name</td>"
	 "<td>Load average </td>"
	 "<td>Memory usage</td>"
	 "<td>Memory number</td>"
	 "<td></td>"
	 "<td>Top process</td>"
	 "<td>Network send (eth0)</td>"
	 "<td>Network receive (eth0)</td>"
	 "</tr>", 
	 av[1]);
  processing_command();  
  printf("</table><p>List taken: %s</p></body></html>\n", ctime(&t));
  
  return 0;
}

