/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Master node
 */
/* 
 * Master node for access. : port for nodes,  port for accessors.
 * 2001 June 9
 *  Junichi Uekawa
 * $Id: dmachinemon-daemonize.c,v 1.1 2002/10/13 18:37:24 dancer Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "dmachinemon/dmachinemon-servent-libroute.h"
#include "dmachinemon/dmachinemon-master.h"
#include "config.h"

/**
 * Daemonize the system when -v0.
 *
 * @version 0.32.1.cvs.5 or higher.
 */
void
dm_daemonize(dm_commandoption* cdat)
{
  if (cdat->debuglevel == 0)
    {
      fprintf (stderr, "  Daemonizing\n");
      switch(fork())
	{
	case 0:
	  daemon (1,0);
	  break;
	case -1:
	  perror ("fork for daemonize");
	  break;
	default:
	  /* I am the parent process */
	  exit (0);
	  break;
	}
    }
}
