import java.util.StringTokenizer;

/**
 * Misc routines used by various indexgen classes.
 * 
 * @version $Id: IGMisc.java,v 1.16 2002/09/04 20:08:48 howama Exp $
 */
class IGMisc {
    /**
     * The default separators for a StringTokenizer taken from the API
     * documentation.
     * @see java.util.StringTokenizer#StringTokenizer(java.lang.String)
     */
    private static final String DEFAULT_SEPARATORS = " \t\n\r\f";


    /** The string used to separate files in a path */
    private static final String fileSeparator =
	System.getProperty("file.separator");

    /** The string used to separate lines */
    public static final String lineSeparator =
	System.getProperty("line.separator");

    /**
     * Works out the relative link between files.
     * The result of this method, if present in the html file relativeTo, would
     * be a perfect html link to realFile.
     */
    public static String relative(String realFile, String relativeTo){
		// TODO: is this buggy?
		String reldir;
		if (relativeTo.lastIndexOf("/") > -1){
			reldir = relativeTo.substring(0, relativeTo.lastIndexOf("/") );
		}else if (relativeTo.lastIndexOf("\\") > -1){
			reldir = relativeTo.substring(0, relativeTo.lastIndexOf("\\") );
		}else{
			reldir = relativeTo;
		}
		// TODO: ../../ style relative linking
		if (realFile.startsWith(reldir)){
			return realFile.substring( reldir.length() );
		}else{
			// we can't find a relative toure
			return realFile;
		}
    }

    /**
     * Removes the file name from the input, leaving just the path (if any)
     * @param path The full file path
     * @return The directory withouth a filename
     */
    public static String dirname(String path) {
	int index;

	if (isURL(path))
	    // TODO check for protocol on url's
	    // TODO i.e. http://index.html
	    index = path.lastIndexOf("/");
	else
	    index = path.lastIndexOf(fileSeparator);

	// TODO check for /filename where index == 0
        return (index > 0 ? path.substring(0, index) : "");
    }


    /**
     * Strip directory from filenames
     * @param path The full file path
     * @return The filename alone
     */
    public static String basename(String path) {
	String separator;

	if (isURL(path))
	    separator = "/";
	else
	    separator = fileSeparator;

	int index = path.lastIndexOf(separator);

	if (index == -1)
	    return path;
	if (index == path.length() - 1)
	    index = path.lastIndexOf(separator, index);

        return path.substring(index + 1);
    }


    /**
     * Converts an array of strings into a single string
     * @param arr The array of strings to convert
     * @param sep The separator to insert between items or <tt>null</tt>
     * @return A single string of items from arr separated by sep
     */
    public static String arrayToString(String[] arr, String sep) {
	if (arr == null)
	    return null;

	if (sep == null)
	    sep = " ";
		
	String result = "";
			
	if (arr.length > 0)
	    result = arr[0];

        for (int i = 1; i < arr.length; i++)
	    result += sep + arr[i];

        return result;
    }


    /**
     * Converts a string to a string array based on a given separator.  If no
     * separator is given, the default whitespace characters will be used.
     * @param str The string to convert
     * @param sep The separator used to break apart the string or <tt>null</tt>
     * @return A string array built from the given string
     */
    public static String[] stringToArray(String str, String sep) {
	if (str == null)
	    return null;

	StringTokenizer strTok;

	if (sep != null)
	    strTok = new StringTokenizer(str, sep);
	else
	    strTok = new StringTokenizer(str);

	String[] array = new String[strTok.countTokens()];

	for (int i = 0; strTok.hasMoreTokens(); i++)
	    array[i] = strTok.nextToken().trim();

	return array;
    }


    /**
     * Convert a HashSet of String's to a String array.
     * @param set The HashSet to transform
     * @return A String array containing the strings in the HashSet
     */
    public static String[] hashSetToStringArray(java.util.HashSet set) {
        if (set == null)
            return null;

        String[] array = new String[set.size()];

        int j = 0;
        for (java.util.Iterator i = set.iterator(); i.hasNext(); )
            array[j++] = (String) i.next();

        return array;
    }


    /**
     * Determine if a string is a valid URI
     * @param string The string to test
     * @return True if the string is a URL, false otherwise
     */
    public static boolean isURL(String string) {
	if (string == null)
	    return false;

        try {
            new java.net.URL(string);
        } catch (java.net.MalformedURLException mue) {
            return false;
        }

        return true;
    }
}
