// $Id: drawmap.cxx 831 2009-03-21 17:14:58Z martin $
//
// drawmap.cpp - routine for DRAWxtl V5.4 - the GUI version 
//
// Coded using the FLTK 1.1.6 widget set
//
//     Larry W. Finger, Martin Kroeker and Brian Toby
//
// This module includes Fourier support routines
//
// routines contained within this file:
//
// generate_map - Generate Marching Cubes triangles from a map
// InterpolateMap - interpolate map value
// LookupMap - return the value of the mmap at one of the calculated points
// Maximize_rho - position the cursor at the local maximum (Q & D routine)

#include "drawxtl.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include "draw_ext.h"
#include "drawmap.h"
#include "DRAWxtlViewUI.h"
#include "MC.h"

#include "DRAWxtl_proto.h"

/* *************************************************************************************** */
/* Generate Marching Cubes triangles from a map with contour minValue*/
/* *************************************************************************************** */

void generate_map (float minValue, int Solid, char * Color)
{
    int numOfTriangles;
    float step[3];
    float Red, Green, Blue;
    int nxMin, nxMax, nyMin, nyMax, nzMin, nzMax; /* max and min steps along a, b & c */
    int snx, sny, snz; /* number of steps along a, b & c */
    unsigned int sny_snz; /* sny x snz */
    int i, j, k, ijk, ii, jj;
    unsigned int ni, nj, nk, si, sj, sk, sni, snj, sind;
    mp4Vector * PointsList;
    float fvert[3], cvert[3];
    TRIANGLE *pTriangles;
    char string[40];
    char Color2[40];
    float d1, d2, d3;
    int iproj = 0;
    int iMax;
    int jMax;
    int kMax;

    if (doVrml) {
      if (!drvui->fpoutv){
        Error_Box("Invalid vrml file path in drawmap.");
        return;
      }
    }
    if (!FourierPt) 
      return; 
    drvui->mainWindow->cursor(FL_CURSOR_WAIT);
    strcpy(string,Color);
    strcpy(Color2,Color);
    Transform_VRML_Color(string);
    Transform_POV_Color(Color2);
    (void) sscanf(string, "%f %f %f", &Red, &Green, &Blue);

    step[0]= 1.0f / (float)mapstep_a;
    step[1]= 1.0f / (float)mapstep_b;
    step[2]= 1.0f / (float)mapstep_c;
    nxMin = (int)(max(xMin,drvui->frames[drvui->frame_no].cryst_lim[0]) * mapstep_a);
    nxMax = (int)(min(xMax,drvui->frames[drvui->frame_no].cryst_lim[3]) * mapstep_a);
    nyMin = (int)(max(yMin,drvui->frames[drvui->frame_no].cryst_lim[1]) * mapstep_b);
    nyMax = (int)(min(yMax,drvui->frames[drvui->frame_no].cryst_lim[4]) * mapstep_b);
    nzMin = (int)(max(zMin,drvui->frames[drvui->frame_no].cryst_lim[2]) * mapstep_c);
    nzMax = (int)(min(zMax,drvui->frames[drvui->frame_no].cryst_lim[5]) * mapstep_c);
    snx = abs(nxMax - nxMin + 1);
    sny = abs(nyMax - nyMin + 1);
    snz = abs(nzMax - nzMin + 1);
    iMax = nxMax + 1;
    jMax = nyMax + 1;
    kMax = nzMax + 1;
    if (snx == 1) {
        iproj = 1;
        snx++;
        iMax++;
    }
    if (sny == 1) {
        iproj = 2;
        sny++;
        jMax++;
    }
    if (snz == 1) {
        iproj = 3;
        snz++;
        kMax++;
    }
    sny_snz = sny * snz;
  
/* create a new set of Fourier points */
  
    PointsList = (mp4Vector *) zalloc(sizeof(mp4Vector) * (snx + 1) * (sny + 1) * (snz + 1));
    if (PointsList == NULL) {
        Error_Box("Error allocating space for PointsList vectors.");
        return;
    }
    for (i = nxMin, si = 0; i <= iMax; i++, si++) {
        ni = i;
        ni = (5 * mapstep_a + ni) % mapstep_a;    /* this will 'wrap' around any value (negative or positive) */
        sni = si * sny_snz;
        fvert[0] = i * step[0];
        if (iproj == 1) {
            ni = nxMin;
            fvert[0] = ni * step[0] + 0.001f;
        }
        for (j = nyMin, sj = 0; j <= jMax; j++, sj++) {
            nj = j;
            nj = (5 * mapstep_b + nj) % mapstep_b;
            snj = sj * snz;
            fvert[1] = j * step[1];
            if (iproj == 2) {
                nj = nyMin;
		fvert[1] = nj * step[1] + 0.001f;
            }
            for (k = nzMin, sk = 0; k <= kMax; k++, sk++) {
                nk = k;
                nk = (5 * mapstep_c + nk) % mapstep_c;
                sind = sni + snj + sk;
                fvert[2] = k * step[2];
                if (iproj == 3) {
                    nk = nzMin;
		    fvert[2] = nk * step[2] + 0.001f;
                }

/* convert Fractional to Orthonormal Coords */

                for (ii = 0; ii <= 2; ++ii) {	 /* convert vertex coordinates to Cartesian */
                    cvert[ii] = 0.0f;
                    for (jj = 0; jj <= 2; ++jj)
                        cvert[ii] += (float) drvui->b_mat[ii][jj] * (fvert[jj] - origin[jj]);
                } 
                PointsList[sind].x = cvert[0];
                PointsList[sind].y = cvert[1];
                PointsList[sind].z = cvert[2];
                ijk =  ni * mapstep_b * mapstep_c + nj * mapstep_c + nk;
                PointsList[sind].val = FourierPt[ijk];
            }
        }
    }

/* create contours from grid of points with matching cubes */
  
    pTriangles= MC(snx-1, sny-1, snz-1, step[0], step[1], step[2], minValue, PointsList, numOfTriangles);
    free (PointsList); 

    if (numOfTriangles<=0) return;

    glPushMatrix ();
    if (!Solid) {
        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
        glDisable(GL_LIGHTING);
    } else
        glMaterialf( GL_FRONT, GL_SHININESS, 0.0); /* disable shinyness */
    glColor3f (Red, Green, Blue);
    glBegin(GL_TRIANGLES);
    for (i=0; i < numOfTriangles; i++) {
        d1 = (pTriangles[i].p[0].x - pTriangles[i].p[1].x) *
             (pTriangles[i].p[0].x - pTriangles[i].p[1].x) +
             (pTriangles[i].p[0].y - pTriangles[i].p[1].y) *
             (pTriangles[i].p[0].y - pTriangles[i].p[1].y) +
             (pTriangles[i].p[0].z - pTriangles[i].p[1].z) *
             (pTriangles[i].p[0].z - pTriangles[i].p[1].z);
        d2 = (pTriangles[i].p[2].x - pTriangles[i].p[1].x) *
             (pTriangles[i].p[2].x - pTriangles[i].p[1].x) +
             (pTriangles[i].p[2].y - pTriangles[i].p[1].y) *
             (pTriangles[i].p[2].y - pTriangles[i].p[1].y) +
             (pTriangles[i].p[2].z - pTriangles[i].p[1].z) *
             (pTriangles[i].p[2].z - pTriangles[i].p[1].z);
        d3 = (pTriangles[i].p[2].x - pTriangles[i].p[0].x) *
             (pTriangles[i].p[2].x - pTriangles[i].p[0].x) +
             (pTriangles[i].p[2].y - pTriangles[i].p[0].y) *
             (pTriangles[i].p[2].y - pTriangles[i].p[0].y) +
             (pTriangles[i].p[2].z - pTriangles[i].p[0].z) *
             (pTriangles[i].p[2].z - pTriangles[i].p[0].z);

// skip excursions completely across the cell when a contour reaches the edge

        if ((d1 > 1000.0f * step[0] * step[0]) || (d2 > 1000.0f * step[1] *step[1]) ||
            (d3 > 1000.0f * step[2] * step[2]))
            continue;
        if (minValue > 0) {
          if (doVrml) {
            if (!Vrml2) {
                fprintf(drvui->fpoutv," Separator {\n");
                fprintf(drvui->fpoutv," Material {  diffuseColor %s }\n",string);
                fprintf(drvui->fpoutv,"Coordinate3 { point [\n");
            } else {
                fprintf(drvui->fpoutv," Shape {\n");
                if (Solid) {
                    fprintf(drvui->fpoutv,"  appearance Appearance {\n");
                    fprintf(drvui->fpoutv,"   material Material {diffuseColor %s}\n",string);
                    fprintf(drvui->fpoutv,"  }\n  geometry IndexedFaceSet { coord Coordinate{ point [\n");
                } else
                    fprintf(drvui->fpoutv,"  geometry IndexedLineSet { coord Coordinate{ point [\n");
            }
          }
          if (doPOV) {
            if (!Solid){
                if (d1 > 0.00001f) {
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[0].x,pTriangles[i].p[0].y,pTriangles[i].p[0].z,        
                             pTriangles[i].p[1].x,pTriangles[i].p[1].y,pTriangles[i].p[1].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
                if (d2 > 0.00001f) {
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[1].x,pTriangles[i].p[1].y,pTriangles[i].p[1].z,        
                             pTriangles[i].p[2].x,pTriangles[i].p[2].y,pTriangles[i].p[2].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
                if (d3 > 0.00001f) {
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[2].x,pTriangles[i].p[2].y,pTriangles[i].p[2].z,        
                             pTriangles[i].p[0].x,pTriangles[i].p[0].y,pTriangles[i].p[0].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
            }
            if (Solid)
                fprintf(drvui->fpoutp,"triangle {\n");
          }
            for (j=0; j < 3; j++) {
                if (Solid) 
                    glNormal3f(pTriangles[i].norm[j].x, pTriangles[i].norm[j].y, pTriangles[i].norm[j].z);
                glVertex3f(pTriangles[i].p[j].x, pTriangles[i].p[j].y, pTriangles[i].p[j].z);

                if (Solid && doPOV) 
                    fprintf(drvui->fpoutp,"<%8.5f, %8.5f, %8.5f>",pTriangles[i].p[j].x,
                            pTriangles[i].p[j].y, pTriangles[i].p[j].z);

                if (doVrml) fprintf(drvui->fpoutv," %5.3f %5.3f %5.3f",pTriangles[i].p[j].x,
                               pTriangles[i].p[j].y, pTriangles[i].p[j].z);

                if (j < 2) {
                    if (Solid && doPOV) 
                        fprintf(drvui->fpoutp,",");
                    if (doVrml) fprintf(drvui->fpoutv,",\n");
                } else {
                    if (Solid && doPOV) 
                       fprintf(drvui->fpoutp,"\n texture{pigment{color %s }}\n }\n", Color2);
                    if (doVrml) fprintf(drvui->fpoutv,"]\n");
                }
           }// for (j... 

          if (doVrml) {
            if (Vrml2) {
                if (Solid) {
                    fprintf(drvui->fpoutv,"  }\n  coordIndex [ 0,1,2,-1]\n solid FALSE\n convex"
                            " TRUE\n creaseAngle 1.57075\n }\n }\n");
                } else {
                    fprintf(drvui->fpoutv,"  }\n  coordIndex [ 0,1,2,-1]\n color Color { color [%s]"
                            "}\n colorIndex [0]\n colorPerVertex FALSE\n }\n }\n",string);
                }
            } else {
                if (Solid) {
                   fprintf(drvui->fpoutv,"}\n IndexedFaceSet { coordIndex [0,1,2,-1] }\n}\n");
                } else {
                   fprintf(drvui->fpoutv,"}\n IndexedLineSet { coordIndex [0,1,2,-1] }\n}\n");
                }
            }
          }
        } else {           // if (minValue > 0)
         if (doVrml) {
            if (!Vrml2) {
                fprintf(drvui->fpoutv," Separator {\n");
                fprintf(drvui->fpoutv," Material {  diffuseColor %s }\n",string);
                fprintf(drvui->fpoutv,"Coordinate3 { point [\n");
            } else {
                fprintf(drvui->fpoutv," Shape {\n");
                if (Solid) {
                    fprintf(drvui->fpoutv,"  appearance Appearance {\n");
                    fprintf(drvui->fpoutv,"   material Material {diffuseColor %s}\n",string);
                    fprintf(drvui->fpoutv,"  }\n  geometry IndexedFaceSet { coord Coordinate{ point [\n");
                } else
                    fprintf(drvui->fpoutv,"  geometry IndexedLineSet { coord Coordinate{ point [\n");
            }
          }
          if (doPOV) {
            if (!Solid) {
                if (d1 > 0.00001f) {           // skip zero length cylinder
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[0].x,pTriangles[i].p[0].y,pTriangles[i].p[0].z,        
                             pTriangles[i].p[1].x,pTriangles[i].p[1].y,pTriangles[i].p[1].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
                if (d2 > 0.00001f) {           // skip zero length cylinder
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[1].x,pTriangles[i].p[1].y,pTriangles[i].p[1].z,        
                             pTriangles[i].p[2].x,pTriangles[i].p[2].y,pTriangles[i].p[2].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
                if (d3 > 0.00001f) {           // skip zero length cylinder
                    fprintf (drvui->fpoutp," cylinder { <%f,%f,%f>,<%f,%f,%f>,%f\n",
                             pTriangles[i].p[2].x,pTriangles[i].p[2].y,pTriangles[i].p[2].z,        
                             pTriangles[i].p[0].x,pTriangles[i].p[0].y,pTriangles[i].p[0].z,
                             0.0001*Scale);
                    fprintf (drvui->fpoutp,"  texture{pigment{color %s  }}\n }\n", Color2);
                }
            }
            if (Solid)
                fprintf(drvui->fpoutp,"triangle {\n");
          }
            for (j=2; j >=0; j--) {
                if (Solid) 
                    glNormal3f(pTriangles[i].norm[j].x, pTriangles[i].norm[j].y, pTriangles[i].norm[j].z);
                glVertex3f(pTriangles[i].p[j].x, pTriangles[i].p[j].y, pTriangles[i].p[j].z);

              
                if (Solid && doPOV) 
                    fprintf(drvui->fpoutp,"<%8.5f, %8.5f, %8.5f>",pTriangles[i].p[j].x,
                            pTriangles[i].p[j].y, pTriangles[i].p[j].z);
                if (doVrml) fprintf(drvui->fpoutv," %5.3f %5.3f %5.3f",pTriangles[i].p[j].x,
                               pTriangles[i].p[j].y, pTriangles[i].p[j].z);
                if (j > 0) {
                    if (Solid && doPOV)
                        fprintf(drvui->fpoutp,",");
                    if (doVrml) fprintf(drvui->fpoutv,",\n");
                } else {
                    if (Solid && doPOV)
                        fprintf(drvui->fpoutp,"\n texture{pigment{color %s }}\n }\n", Color2);
                    if (doVrml) fprintf(drvui->fpoutv,"]\n");
                }
            }
         if (doVrml) {
            if (Vrml2) {
                if (Solid) {
                    fprintf(drvui->fpoutv,"}\n coordIndex [ 1,2,3,-1]\n solid FALSE\n convex TRUE\n"
                            " creaseAngle 1.57075\n }\n }\n");
                } else {
                    fprintf(drvui->fpoutv,"  }\n  coordIndex [ 0,1,2,-1]\n color Color { color [%s]"
                            "}\n colorIndex [0]\n colorPerVertex FALSE\n }\n }\n",string);
                }
            } else {
                if (Solid) {
                    fprintf(drvui->fpoutv,"}\n IndexedFaceSet { coordIndex [1,2,3,-1] }\n}\n");
                } else {
                    fprintf(drvui->fpoutv,"}\n IndexedLineSet { coordIndex [1,2,3,-1] }\n}\n");
                }
            }
          }
        }              // if (minValue > 0)
    }
    glEnd();
    if (!Solid) {
        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
        glEnable(GL_LIGHTING);
    }
    glPopMatrix ();
    free(pTriangles);         /* free the contour array */
    drvui->mainWindow->cursor(FL_CURSOR_DEFAULT);
}

/* interpolate rho on a 3-D grid */

float InterpolateMap (float x, float y, float z)
{ 

/* for simplicity, use weighting appropriate for a cubic grid (should be better than no interpolation) */

  int ix,iy,iz; 
  int ix1,iy1,iz1; 
  float Xmin, Ymin, Zmin, Xmax, Ymax, Zmax, AvgRho;

/* Compute the grid points on either size of x, then map those points onto the 3D array indices */
  
  ix=((int)(x*mapstep_a));
  Xmin = ((float) ix)/mapstep_a;
  Xmax = ((float) (ix+1))/mapstep_a;
  ix=((int)(x*mapstep_a))%mapstep_a;
  ix1= (ix + 1) % mapstep_a;

/* ditto for y & z */

  iy=((int)(y*mapstep_b));
  Ymin = ((float) iy)/mapstep_b;
  Ymax = ((float) (iy+1))/mapstep_b;
  iy=((int)(y*mapstep_b))%mapstep_b;
  iy1= (iy + 1) % mapstep_b;
  iz=((int)(z*mapstep_c));
  Zmin = ((float) iz)/mapstep_c;
  Zmax = ((float) (iz+1))/mapstep_c;
  iz=((int)(z*mapstep_c))%mapstep_c;
  iz1= (iz + 1) % mapstep_c;

  AvgRho  = FourierPt[LookupMap(ix, iy, iz)  ]* (Xmax-x) * (Ymax-y) * (Zmax-z);
  AvgRho += FourierPt[LookupMap(ix1,iy, iz)  ]* (x-Xmin) * (Ymax-y) * (Zmax-z);
  AvgRho += FourierPt[LookupMap(ix1,iy1,iz)]* (x-Xmin) * (y-Ymin) * (Zmax-z);
  AvgRho += FourierPt[LookupMap(ix1,iy, iz1)]* (x-Xmin) * (Ymax-y) * (z-Zmin);
  AvgRho += FourierPt[LookupMap(ix, iy1,iz)  ]* (Xmax-x) * (y-Ymin) * (Zmax-z);
  AvgRho += FourierPt[LookupMap(ix, iy1,iz1)]* (Xmax-x) * (y-Ymin) * (z-Zmin);
  AvgRho += FourierPt[LookupMap(ix, iy, iz1)]* (Xmax-x) * (Ymax-y) * (z-Zmin);
  AvgRho += FourierPt[LookupMap(ix1,iy1,iz1)]* (x-Xmin) * (y-Ymin) * (z-Zmin);

  AvgRho /= (Xmax-Xmin) * (Ymax-Ymin) * (Zmax-Zmin);

  return AvgRho;
}

/* lookup a point in the Fourier map */

int LookupMap(int ix, int iy, int iz) 
{

    return abs(ix*mapstep_b*mapstep_c + iy*mapstep_c + ((mapstep_c+ iz % mapstep_c)% mapstep_c));
}

int Maximize_rho(int Sense)
{
// find min/max in rho - Sense is -1 if min, +1 if max
    float rhomax = -1.0e15f;
    int i, j, k, l;
    float w0[3][3][3];
    int maxpt;
    float param[7];
    int map[3];

    if (! ReadFourMap)
        return (-1);
// extract 3x3x3 array of points around the current position
    for (i=0; i<7; i++)
        param[i] = 0.0f;
    map[0] = (int)((float)mapstep_a * cur_cen[0] + 0.5);
    map[1] = (int)((float)mapstep_b * cur_cen[1] + 0.5);
    map[2] = (int)((float)mapstep_c * cur_cen[2] + 0.5);
    while (1) {
      rhomax = -1.0e15f;
      maxpt = -1;
      for (i=0; i<3; i++) {
        for (j=0; j<3; j++) {
            for (k=0; k<3; k++) {
                l = (map[0] +i - 1) * mapstep_b * mapstep_c
                    + (map[1] + j - 1) * mapstep_c + map[2] + k - 1;
                w0[i][j][k] = (float) Sense * FourierPt[l];
                if (w0[i][j][k] > rhomax) {
                    rhomax = w0[i][j][k];
                    maxpt = (i * 100) + (j * 10) + k;
                }
            }
        }
      }
      if (maxpt == 111)
          break;                            // maximum in middle
      k = maxpt % 10;                       // shift maximum to middle
      j = maxpt/10 % 10;
      i = maxpt / 100;
      map[2] += k-1;
      map[1] += j-1;
      map[0] += i-1;
      i = 0;
      if (map[0] < 1) {
          map[0] = 1;
          i = 1;
      }
      if (map[1] < 1) {
          map[1] = 1;
          i = 1;
      }
      if (map[2] < 1) {
          map[2] = 1;
          i = 1;
      }
      if (map[0] > mapstep_a-1) {
          map[0] = mapstep_a-1;
          i = 1;
      }
      if (map[1] > mapstep_b-1) {
          map[1] = mapstep_b-1;
          i = 1;
      }
      if (map[2] > mapstep_c-1) {
          map[2] = mapstep_c-1;
          i = 1;
      }
      if (i) break;
      cur_cen[2] = map[2]/(float)mapstep_c;
      cur_cen[1] = map[1]/(float)mapstep_b;
      cur_cen[0] = map[0]/(float)mapstep_a;
    }
    param[3] = -w0[1][1][1] + (w0[0][1][1] + w0[2][1][1]) * 0.5f;
    param[4] = -w0[1][1][1] + (w0[1][0][1] + w0[1][2][1]) * 0.5f;
    param[5] = -w0[1][1][1] + (w0[1][1][0] + w0[1][1][2]) * 0.5f;
    if (param[3] != 0.0f)
        param[0] = (w0[0][1][1] - w0[2][1][1]) * 0.25f/param[3];
    if (param[4] != 0.0f)
        param[1] = (w0[1][0][1] - w0[1][2][1]) * 0.25f/param[4];
    if (param[5] != 0.0f)
        param[2] = (w0[1][1][0] - w0[1][1][2]) * 0.25f/param[5];
    param[6] = w0[1][1][1] - param[3] * param[0] * param[0]
              - param[4] * param[1] * param[1] - param[5] * param[2] * param[2];

    cur_cen[0] += param[0]/mapstep_a;
    cur_cen[1] += param[1]/mapstep_b;
    cur_cen[2] += param[2]/mapstep_c;
    i = 0;
    for (k=0; k<nvert; k++) {
        if(fabs(o_vert[3*k] - cur_cen[0]) + fabs(o_vert[3*k+1] - cur_cen[1])
            + fabs(o_vert[3*k+2] - cur_cen[2]) < 0.001) i = k;
    }
    if (i) return i;                     // position already in vertex list
    drvui->orig_atom_no[nvert] = -1;     // new position - add it
    for (k = 0; k < 3; k++) {
        o_vert[3 * nvert + k] = cur_cen[k];
        s_vert[3 * nvert + k] = 0.0f;
        for (l = 0; l < 3; l++) {         /* calculate cartesian coordinates */
          s_vert[3 * nvert + k] +=
               (float) drvui->b_mat[k][l] * (cur_cen[l] - origin[l]);
        }
    }
    vert_sym_no[nvert++] = 0;
    if (!check_vert_alloc(nvert, 1))
        return (-1);
    return (nvert-1);
}
