//#!gcc -o dvr dvr.c
/* DV-Record with 9600 Baud*/;

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <curses.h>
#include <termios.h>
#include <fcntl.h>
#include <string.h>
#include <asm/io.h>

//just to wake up the cam:
char CMD_WAKE[]={0x05,0x80,0x7f,0x01,0x80,0x13,0x20,0x03,0x00,0x01,0xff,0x01,0x01,0x1f,
       0x02,0x01,0x19,0x03,0x01,0xff,0x80,0x01,0x07,0x81,0x01,0xff,0xcf,0x10,0x3b,0x04};
//now the real commands:
char CMD_DVR[] ={0x05,0x80,0x7f,0x01,0x80,0x03,0x00,0x20,0xc2,0x75,0x94,0x10,0x3b,0x04};
char CMD_PLAY[]={0x05,0x80,0x7f,0x01,0x80,0x03,0x00,0x20,0xc3,0x75,0x95,0x10,0x3b,0x04};

send_command(char cmd[],int size, int comfd)
{
        int i;
        char c;
        for(i=0;i<sizeof(CMD_WAKE);i++)
        {
                write(comfd,CMD_WAKE+i,1);
                fsync(comfd);
                //usleep(15000);//for KURT-kernel
		usleep(10000);
        }
        while(read(comfd,&c,1));
        for(i=0;i<size;i++)
        {
                write(comfd,cmd+i,1);
                fsync(comfd);
                //usleep(15000);//for KURT-kernel
		usleep(10000);
        }
        while(read(comfd,&c,1));
}

main(int argc,char *argv[])
{
int comfd=0;
struct termios tiosbk,tiosnew;
if(argc!=2)
{
	printf("usage: dvr /dev/ttyS*\n*=serial port your camcorder is connected to\n");
	exit(-1);
}
else
{
	printf("using device %s\n",argv[argc-1]);
}

comfd=open(argv[argc-1],O_RDWR|O_NOCTTY);
if(comfd==0)
{
	printf("could not open serial port!\n");
        exit(-1);
}
bzero(&tiosnew,sizeof(tiosnew));
if(-1==tcgetattr(comfd,&tiosbk))
{
	printf("could not getattr!\n");
	exit(-2);
}
tiosnew.c_iflag=IGNPAR;
tiosnew.c_oflag=0;
tiosnew.c_cflag=B9600|CS8|CLOCAL|CREAD;//|CRTSCTS;
tiosnew.c_lflag=0;
tiosnew.c_cc[VTIME]=0;//[0.1sec]
tiosnew.c_cc[VMIN]=0;
if(-1==tcsetattr(comfd,TCSANOW,&tiosnew))
{
  printf("could not setattr!\n");
  exit(-3);
}
send_command(CMD_DVR,sizeof(CMD_DVR),comfd);

close(comfd);

return(0);
}
