/*  $Header: /cvsroot/dvipdfmx/src/pdfdev.h,v 1.10 2004/03/14 04:23:02 hirata Exp $
    
    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef _PDFDEV_H_
#define _PDFDEV_H_

#include "numbers.h"
#include "pdfobj.h"

typedef signed long spt_t;

typedef struct pdf_tmatrix
{
  double a, b, c, d, e, f;
} pdf_tmatrix;

typedef struct pdf_rect
{
  double llx, lly, urx, ury;
} pdf_rect;

extern void pdf_dev_set_verbose (void);

extern int pdf_sprint_matrix (char *buf, const pdf_tmatrix *M);
extern int pdf_sprint_rect   (char *buf, const pdf_rect *rect);

extern void   dev_set_page_size    (double width, double height);

extern double dev_unit_dviunit (void);

extern void pdf_dev_init  (double scale, int precision,
			   double width, double height, double hoffset, double voffset);
extern void pdf_dev_close (void);

extern double pdf_dev_scale (void);

extern double dev_phys_x (void);
extern double dev_phys_y (void);

extern int  dev_locate_font     (const char *tex_name, spt_t ptsize, int map_id);
extern void dev_reselect_font   (void);

extern void dev_bop (void);
extern void dev_eop (void);

#if 0
typedef struct pdf_text
{
  int   font_id;
  int   encoding_id;
  int   length;
  void *data;  /* char or unsigned char or struct pdf_text? */
} pdf_text;
#endif

extern void dev_set_string (spt_t xpos, spt_t ypos,
			    unsigned char *s, int len, spt_t width,
			    int font_id, int ctype);
extern void dev_rule       (spt_t xpos, spt_t ypos, spt_t width, spt_t height);


#define PDF_COLOR_DEV_GRAY -1
#define PDF_COLOR_INVALID  -2
#define PDF_COLOR_DEV_RGB  -3
#define PDF_COLOR_DEV_CMYK -4

#define PDF_COLOR_COMPONENT_MAX 4

typedef struct pdf_color
{
  int    space_id;
  double values[PDF_COLOR_COMPONENT_MAX];
} pdf_color;

extern void dev_ignore_colors (void);

extern void dev_do_color  (void);
extern void dev_end_color (void);

extern void dev_begin_dev_color     (const pdf_color *colorspec);
extern void dev_begin_named_color   (const char *color_name);

/* This is not "define" but "default". */
extern void dev_set_def_dev_color   (const pdf_color *colorspec);
extern void dev_set_def_named_color (const char *color_name);

extern void dev_bg_dev_color   (const pdf_color *colorspec);
extern void dev_bg_named_color (const char *color_name);


extern void dev_begin_transform (double xscale, double yscale, double rotate,
				 double x_user, double y_user);
extern void dev_end_transform   (void);
/* xform ??? */
#define dev_begin_xform(sx,sy,r,ox,oy) dev_begin_transform((sx),(sy),(r),(ox),(oy))
#define dev_end_xform() dev_end_transform()

extern int  dev_xform_depth (void);
extern void dev_close_all_xforms (int depth);

extern void dev_do_special (void *buffer, UNSIGNED_QUAD size,
			    spt_t x_user, spt_t y_user);

/*
 * graphics_mode() would normally be local, but it is needed by the MetaPost
 * inclusion routine.
 */
extern void dev_start_mp_mode (void);
extern void dev_end_mp_mode   (void);
extern void graphics_mode     (void);

extern void dev_stack_depth (unsigned int depth);
extern void dev_tag_depth   (void);
extern void dev_untag_depth (void);
extern void dev_set_box     (void);
extern void dev_expand_box  (spt_t width, spt_t height, spt_t depth);
/* Link Annot ??? */
extern void dev_link_annot  (unsigned char flag);

extern int  dev_wmode      (void);
extern void dev_set_wmode  (int wmode);

#endif /* _PDFDEV_H_ */
