//

/*
 * $Header: /src/master/dx/src/uipp/java/dx/net/ControlPanel.java,v 1.3 1999/07/09 19:29:59 daniel Exp $
 */

package dx.net;
import java.util.*;
import java.awt.*;
import dx.runtime.*;

public class ControlPanel extends Panel {

    private Network net;
    private String name;
    private int instance;
    private Vector interactors;
    private Vector decorators;
    private Checkbox tab;

    public ControlPanel(Network net, String name, int instance) {
	super();
	if (name == null) this.name = "ControlPanel " + instance;
	else this.name = name;
	this.instance = instance;
	this.net = net;
	this.interactors = null;
    }

    public String getName() { return this.name; }
    public Checkbox getTab() { return this.tab; }

    public synchronized void addInteractor(Interactor i) {
	if (this.interactors == null)
	    this.interactors = new Vector(4);
	this.interactors.addElement((Object)i);
    }

    public synchronized void addDecorator(Component d) {
	if (this.decorators == null)
	    this.decorators = new Vector(4);
	this.decorators.addElement((Object)d);
    }

    public synchronized void buildPanel() {
	this.setLayout(null);
	if (this.interactors != null) {
	    Enumeration enum = interactors.elements();
	    Interactor i;
	    while (enum.hasMoreElements()) {
		i = (Interactor)enum.nextElement();
		i.init();
		InteractorNode n = (InteractorNode)i.getNode();
		n.installValues(i);
		this.add(i);
	    }
	}
	if (this.decorators != null) {
	    Enumeration enum = decorators.elements();
	    Component d;
	    while (enum.hasMoreElements()) {
		d = (Component)enum.nextElement();
		this.add(d);
	    }
	}
	this.tab = new Checkbox(this.name);
    }

}; // end ControlPanel
