/*
 * $Id: dapto.h,v 1.27 2001/06/11 21:23:54 tony Exp $
 * Copyright (c) 1994-1997 Anthony M. Sloane
 */

/* This file is part of the Eli Module Library.

The Eli Module Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The Eli Module Library is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the Eli Module Library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Eli into the
   directory resulting from a :source derivation, you may use that
   created file as a part of that directory without restriction. */

#ifndef DAPTO_H
#define DAPTO_H

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "eliproto.h"

/*
   Dapto message structure:

   data field: message data, in the following format:

   Single character message type:
      'e' event (to Noosa)
      'c' command (from Noosa)
      'r' response to command (to Noosa)
      '?' error executing command (to Noosa)
   followed by message parameters:
      'i' followed by sizeof(int) bytes, integer value
      'l' followed by sizeof(long int) bytes, long integer value
      's' followed by null-terminated bytes, string value

   next field: points to first character after last param.

   When transmitted, messages are prefixed with an integer length that 
   gives the size of the data field (including type).
*/

#define DAPTO_MAXMSGLEN 10000

extern char *_dapto_mbuf, *_dapto_cp;
extern CONST char *_dapto_src;

#define DAPTO_MESG_STR(x) { \
    *_dapto_cp++ = 's'; \
    for (_dapto_src = (x); *_dapto_src != '\0'; *_dapto_cp++ = *_dapto_src++) \
        ; \
    *_dapto_cp++ = '\0'; \
}

#define DAPTO_MESG_NUM(c,n) { \
    *_dapto_cp++ = (c); \
    memcpy (_dapto_cp, (void *)&(n), sizeof (n)); \
    _dapto_cp += sizeof (n); \
}

/* Calls to these macros are generated by dapto */

#define DAPTO_INIT_EV \
    if (!_dap_noosa_there) return; \
    _dapto_cp = _dapto_mbuf; \
    *_dapto_cp++ = 'e';

#define DAPTO_INIT_OP \
    _dapto_cp = _dapto_mbuf; \
    *_dapto_cp++ = 'r'

#define DAPTO_INIT_ERR \
    _dapto_cp = _dapto_mbuf; \
    *_dapto_cp++ = '?'

#define DAPTO_ARG_STR(sp) \
    while ((*_dapto_cp != '\0') && isspace (*_dapto_cp)) _dapto_cp++; \
    *sp = _dapto_cp; \
    while ((*_dapto_cp != '\0') && !isspace (*_dapto_cp)) _dapto_cp++

#define DAPTO_ARG_INIT_OP \
    _dapto_cp = args
    
#define DAPTO_ARG_INT(ip) \
    *ip = (int) strtol (_dapto_cp, &_dapto_cp, 10)

#define DAPTO_ARG_PTR(pp,t) \
    *pp = (t) strtol (_dapto_cp, &_dapto_cp, 10)

#define DAPTO_ARG_OTHER(vp)

/* Calls to these macros are generated by dapto or used by the
   developer */

#define DAPTO_RESULT_STR(s) \
    DAPTO_MESG_STR (s)

#define DAPTO_RESULT_INT(x) \
    DAPTO_MESG_NUM ('i', x)

#define DAPTO_RESULT_LONG(x) \
    DAPTO_MESG_NUM ('l', x)

#define DAPTO_RESULT_PTR(p) \
    DAPTO_RESULT_LONG(p)

#define DAPTO_RESULT_INTVAL(iv) { \
    int i = iv; \
    DAPTO_RESULT_INT (i); \
}

#define DAPTO_RESULTint(i) \
    DAPTO_RESULT_INTVAL(i)

#define DAPTO_RESULT_LONGVAL(lv) { \
    long int l = lv; \
    DAPTO_RESULT_LONG (l); \
}

#define DAPTO_RESULTlong(i) \
    DAPTO_RESULT_LONGVAL(i)

#define DAPTO_RESULT_PTRVAL(pv) { \
    void *p = (void *) pv; \
    DAPTO_RESULT_LONG(p); \
}

#define DAPTO_RESULT_OTHER(o) \
    DAPTO_RESULT_STR ("unknown")

#define DAPTO_RETURN() \
    goto send

#define DAPTO_RESULT_SEND(i) \
    send: _dap_send (i)

extern int _dap_noosa_there;
extern void _dap_init ELI_ARG((char *));
typedef void (*_dapto_cmd_func)ELI_ARG((char *));
extern void _dap_add_command ELI_ARG((char *, _dapto_cmd_func));
extern void _dap_send ELI_ARG((int));
extern char *_dap_format ELI_ARG((char *, ...));

#endif
