
/* implementation of tree construction functions */

#include "node.h"

#include "nodecode.h"

#include "attrpredef.h"

#include "visitmap.h"

#include "treeact.h"

#ifdef MONITOR
#include "attr_mon_dapto.h"
#endif

#include <stdlib.h>

#define _USE_OBSTACK 1

/* use of obstack: */

#if _USE_OBSTACK

#include "obstack.h"
static struct obstack TreeSpace;
static void *_TreeBase;

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	return obstack_alloc(&TreeSpace, size);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	return (char *)(obstack_alloc(&TreeSpace, size));
}
#endif

void InitTree()
{
	obstack_init(&TreeSpace);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

void FreeTree()
{
	obstack_free(&TreeSpace, _TreeBase);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

#else

#include <stdio.h>

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	void *retval = malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	char *retval = (char *) malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#endif

void InitTree() { }

void FreeTree() { }

#endif

#ifdef MONITOR
#define _SETCOORD(node) \
        node->_coord = _coordref ? *_coordref : NoCoord;
#define _COPYCOORD(node) \
        node->_coord = _currn->_desc1->_coord;
#else
#define _SETCOORD(node)
#define _COPYCOORD(node)
#endif
#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MknonLitDesc (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MknonLitDesc (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBnonLitDesc)) return (_currn);
if (IsSymb (_currn, SYMBrest)) return (Mkrule_10(_coordref, _currn));
return(NULLNODEPTR);
}/* MknonLitDesc */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkIdDef (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkIdDef (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBIdDef)) return (_currn);
return(NULLNODEPTR);
}/* MkIdDef */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrest (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkrest (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBrest)) return (_currn);
return(NULLNODEPTR);
}/* Mkrest */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkNonlitEncoding (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkNonlitEncoding (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBNonlitEncoding)) return (_currn);
return(NULLNODEPTR);
}/* MkNonlitEncoding */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkIdUse (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkIdUse (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBIdUse)) return (_currn);
return(NULLNODEPTR);
}/* MkIdUse */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkvalue (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkvalue (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBvalue)) return (_currn);
return(NULLNODEPTR);
}/* Mkvalue */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkLitEncoding (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkLitEncoding (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBLitEncoding)) return (_currn);
return(NULLNODEPTR);
}/* MkLitEncoding */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkoptAuxScanner (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkoptAuxScanner (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBoptAuxScanner)) return (_currn);
return(NULLNODEPTR);
}/* MkoptAuxScanner */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkoptProcessor (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkoptProcessor (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBoptProcessor)) return (_currn);
return(NULLNODEPTR);
}/* MkoptProcessor */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MklibrRef (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MklibrRef (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBlibrRef)) return (_currn);
return(NULLNODEPTR);
}/* MklibrRef */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkEofOption (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkEofOption (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBEofOption)) return (_currn);
return(NULLNODEPTR);
}/* MkEofOption */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkspec (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkspec (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBspec)) return (_currn);
return(NULLNODEPTR);
}/* Mkspec */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MknonLitDescs (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MknonLitDescs (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBnonLitDescs)) return (_currn);
return(NULLNODEPTR);
}/* MknonLitDescs */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkoptions (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkoptions (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBoptions)) return (_currn);
if (IsSymb (_currn, SYMBoption)) return (Mkrule_005(_coordref, _currn));
if (IsSymb (_currn, SYMBEofOption)) return (Mkrule_005(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkoptions */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkencodings (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkencodings (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBencodings)) return (_currn);
return(NULLNODEPTR);
}/* Mkencodings */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkoption (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkoption (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBoption)) return (_currn);
if (IsSymb (_currn, SYMBEofOption)) return (Mkrule_007(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkoption */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkencoding (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkencoding (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBencoding)) return (_currn);
if (IsSymb (_currn, SYMBNonlitEncoding)) return (Mkrule_013(_coordref, _currn));
if (IsSymb (_currn, SYMBLitEncoding)) return (Mkrule_012(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkencoding */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_000 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_000 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_000 _currn;
#ifdef __cplusplus
_currn = new _TPrule_000;
#else
_currn = (_TPPrule_000) TreeNodeAlloc (sizeof (struct _TPrule_000));
#endif
_currn->_prod = RULErule_000;
_currn->_desc1 = (_TSPnonLitDescs) MknonLitDescs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_000: root of subtree no. 1 can not be made a nonLitDescs node ", 0, _coordref);
_currn->_desc2 = (_TSPoptions) Mkoptions (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_000: root of subtree no. 2 can not be made a options node ", 0, _coordref);
_currn->_desc3 = (_TSPencodings) Mkencodings (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_000: root of subtree no. 3 can not be made a encodings node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_000;
return ( (NODEPTR) _currn);
}/* Mkrule_000 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_001 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_001 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_001 _currn;
#ifdef __cplusplus
_currn = new _TPrule_001;
#else
_currn = (_TPPrule_001) TreeNodeAlloc (sizeof (struct _TPrule_001));
#endif
_currn->_prod = RULErule_001;
_currn->_desc1 = (_TSPnonLitDescs) MknonLitDescs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 1 can not be made a nonLitDescs node ", 0, _coordref);
_currn->_desc2 = (_TSPnonLitDesc) MknonLitDesc (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 2 can not be made a nonLitDesc node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_001;
return ( (NODEPTR) _currn);
}/* Mkrule_001 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_002 (POSITION *_coordref)
#else
NODEPTR Mkrule_002 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_002 _currn;
#ifdef __cplusplus
_currn = new _TPrule_002;
#else
_currn = (_TPPrule_002) TreeNodeAlloc (sizeof (struct _TPrule_002));
#endif
_currn->_prod = RULErule_002;
_SETCOORD(_currn)
_TERMACT_rule_002;
return ( (NODEPTR) _currn);
}/* Mkrule_002 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_003 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_003 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_003 _currn;
#ifdef __cplusplus
_currn = new _TPrule_003;
#else
_currn = (_TPPrule_003) TreeNodeAlloc (sizeof (struct _TPrule_003));
#endif
_currn->_prod = RULErule_003;
_SETCOORD(_currn)
_TERMACT_rule_003;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_003 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_004 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_004 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_004 _currn;
#ifdef __cplusplus
_currn = new _TPrule_004;
#else
_currn = (_TPPrule_004) TreeNodeAlloc (sizeof (struct _TPrule_004));
#endif
_currn->_prod = RULErule_004;
_currn->_desc1 = (_TSPoptions) Mkoptions (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_004: root of subtree no. 1 can not be made a options node ", 0, _coordref);
_currn->_desc2 = (_TSPoption) Mkoption (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_004: root of subtree no. 2 can not be made a option node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_004;
return ( (NODEPTR) _currn);
}/* Mkrule_004 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_005 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_005 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_005 _currn;
#ifdef __cplusplus
_currn = new _TPrule_005;
#else
_currn = (_TPPrule_005) TreeNodeAlloc (sizeof (struct _TPrule_005));
#endif
_currn->_prod = RULErule_005;
_currn->_desc1 = (_TSPoption) Mkoption (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_005: root of subtree no. 1 can not be made a option node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_005;
return ( (NODEPTR) _currn);
}/* Mkrule_005 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_006 (POSITION *_coordref)
#else
NODEPTR Mkrule_006 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_006 _currn;
#ifdef __cplusplus
_currn = new _TPrule_006;
#else
_currn = (_TPPrule_006) TreeNodeAlloc (sizeof (struct _TPrule_006));
#endif
_currn->_prod = RULErule_006;
_SETCOORD(_currn)
_TERMACT_rule_006;
return ( (NODEPTR) _currn);
}/* Mkrule_006 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_007 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_007 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_007 _currn;
#ifdef __cplusplus
_currn = new _TPrule_007;
#else
_currn = (_TPPrule_007) TreeNodeAlloc (sizeof (struct _TPrule_007));
#endif
_currn->_prod = RULErule_007;
_currn->_desc1 = (_TSPEofOption) MkEofOption (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_007: root of subtree no. 1 can not be made a EofOption node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_007;
return ( (NODEPTR) _currn);
}/* Mkrule_007 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_008 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_008 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_008 _currn;
#ifdef __cplusplus
_currn = new _TPrule_008;
#else
_currn = (_TPPrule_008) TreeNodeAlloc (sizeof (struct _TPrule_008));
#endif
_currn->_prod = RULErule_008;
_currn->_desc1 = (_TSPvalue) Mkvalue (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_008: root of subtree no. 1 can not be made a value node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_008;
return ( (NODEPTR) _currn);
}/* Mkrule_008 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_009 (POSITION *_coordref)
#else
NODEPTR Mkrule_009 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_009 _currn;
#ifdef __cplusplus
_currn = new _TPrule_009;
#else
_currn = (_TPPrule_009) TreeNodeAlloc (sizeof (struct _TPrule_009));
#endif
_currn->_prod = RULErule_009;
_SETCOORD(_currn)
_TERMACT_rule_009;
return ( (NODEPTR) _currn);
}/* Mkrule_009 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_010 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_010 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_010 _currn;
#ifdef __cplusplus
_currn = new _TPrule_010;
#else
_currn = (_TPPrule_010) TreeNodeAlloc (sizeof (struct _TPrule_010));
#endif
_currn->_prod = RULErule_010;
_currn->_desc1 = (_TSPencodings) Mkencodings (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_010: root of subtree no. 1 can not be made a encodings node ", 0, _coordref);
_currn->_desc2 = (_TSPencoding) Mkencoding (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_010: root of subtree no. 2 can not be made a encoding node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_010;
return ( (NODEPTR) _currn);
}/* Mkrule_010 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_011 (POSITION *_coordref)
#else
NODEPTR Mkrule_011 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_011 _currn;
#ifdef __cplusplus
_currn = new _TPrule_011;
#else
_currn = (_TPPrule_011) TreeNodeAlloc (sizeof (struct _TPrule_011));
#endif
_currn->_prod = RULErule_011;
_SETCOORD(_currn)
_TERMACT_rule_011;
return ( (NODEPTR) _currn);
}/* Mkrule_011 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_012 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_012 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_012 _currn;
#ifdef __cplusplus
_currn = new _TPrule_012;
#else
_currn = (_TPPrule_012) TreeNodeAlloc (sizeof (struct _TPrule_012));
#endif
_currn->_prod = RULErule_012;
_currn->_desc1 = (_TSPLitEncoding) MkLitEncoding (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_012: root of subtree no. 1 can not be made a LitEncoding node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_012;
return ( (NODEPTR) _currn);
}/* Mkrule_012 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_013 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_013 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_013 _currn;
#ifdef __cplusplus
_currn = new _TPrule_013;
#else
_currn = (_TPPrule_013) TreeNodeAlloc (sizeof (struct _TPrule_013));
#endif
_currn->_prod = RULErule_013;
_currn->_desc1 = (_TSPNonlitEncoding) MkNonlitEncoding (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 1 can not be made a NonlitEncoding node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_013;
return ( (NODEPTR) _currn);
}/* Mkrule_013 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_1 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_1 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_1 _currn;
#ifdef __cplusplus
_currn = new _TPrule_1;
#else
_currn = (_TPPrule_1) TreeNodeAlloc (sizeof (struct _TPrule_1));
#endif
_currn->_prod = RULErule_1;
_currn->_desc1 = (_TSPIdDef) MkIdDef (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_1: root of subtree no. 1 can not be made a IdDef node ", 0, _coordref);
_currn->_desc2 = (_TSPrest) Mkrest (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_1: root of subtree no. 2 can not be made a rest node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_1;
return ( (NODEPTR) _currn);
}/* Mkrule_1 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_2 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_2 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_2 _currn;
#ifdef __cplusplus
_currn = new _TPrule_2;
#else
_currn = (_TPPrule_2) TreeNodeAlloc (sizeof (struct _TPrule_2));
#endif
_currn->_prod = RULErule_2;
_SETCOORD(_currn)
_TERMACT_rule_2;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_2 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_3 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_3 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_3 _currn;
#ifdef __cplusplus
_currn = new _TPrule_3;
#else
_currn = (_TPPrule_3) TreeNodeAlloc (sizeof (struct _TPrule_3));
#endif
_currn->_prod = RULErule_3;
_currn->_desc1 = (_TSPIdUse) MkIdUse (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 1 can not be made a IdUse node ", 0, _coordref);
_currn->_desc2 = (_TSPvalue) Mkvalue (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 2 can not be made a value node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_3;
return ( (NODEPTR) _currn);
}/* Mkrule_3 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_4 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_4 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_4 _currn;
#ifdef __cplusplus
_currn = new _TPrule_4;
#else
_currn = (_TPPrule_4) TreeNodeAlloc (sizeof (struct _TPrule_4));
#endif
_currn->_prod = RULErule_4;
_currn->_desc1 = (_TSPIdUse) MkIdUse (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_4: root of subtree no. 1 can not be made a IdUse node ", 0, _coordref);
_currn->_desc2 = (_TSPvalue) Mkvalue (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_4: root of subtree no. 2 can not be made a value node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_4;
return ( (NODEPTR) _currn);
}/* Mkrule_4 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_5 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_5 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_5 _currn;
#ifdef __cplusplus
_currn = new _TPrule_5;
#else
_currn = (_TPPrule_5) TreeNodeAlloc (sizeof (struct _TPrule_5));
#endif
_currn->_prod = RULErule_5;
_SETCOORD(_currn)
_TERMACT_rule_5;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_5 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_6 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_6 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_6 _currn;
#ifdef __cplusplus
_currn = new _TPrule_6;
#else
_currn = (_TPPrule_6) TreeNodeAlloc (sizeof (struct _TPrule_6));
#endif
_currn->_prod = RULErule_6;
_SETCOORD(_currn)
_TERMACT_rule_6;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Integer", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_6 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_7 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_7 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_7 _currn;
#ifdef __cplusplus
_currn = new _TPrule_7;
#else
_currn = (_TPPrule_7) TreeNodeAlloc (sizeof (struct _TPrule_7));
#endif
_currn->_prod = RULErule_7;
_SETCOORD(_currn)
_TERMACT_rule_7;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Integer", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_7 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_8 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_8 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_8 _currn;
#ifdef __cplusplus
_currn = new _TPrule_8;
#else
_currn = (_TPPrule_8) TreeNodeAlloc (sizeof (struct _TPrule_8));
#endif
_currn->_prod = RULErule_8;
_SETCOORD(_currn)
_TERMACT_rule_8;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Integer", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_8 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_9 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_9 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_9 _currn;
#ifdef __cplusplus
_currn = new _TPrule_9;
#else
_currn = (_TPPrule_9) TreeNodeAlloc (sizeof (struct _TPrule_9));
#endif
_currn->_prod = RULErule_9;
_currn->_desc1 = (_TSPvalue) Mkvalue (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_9: root of subtree no. 1 can not be made a value node ", 0, _coordref);
_currn->_desc2 = (_TSPrest) Mkrest (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_9: root of subtree no. 2 can not be made a rest node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_9;
return ( (NODEPTR) _currn);
}/* Mkrule_9 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_10 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_10 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_10 _currn;
#ifdef __cplusplus
_currn = new _TPrule_10;
#else
_currn = (_TPPrule_10) TreeNodeAlloc (sizeof (struct _TPrule_10));
#endif
_currn->_prod = RULErule_10;
_currn->_desc1 = (_TSPrest) Mkrest (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_10: root of subtree no. 1 can not be made a rest node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_10;
return ( (NODEPTR) _currn);
}/* Mkrule_10 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_11 (POSITION *_coordref, int _TERM1, NODEPTR _desc1)
#else
NODEPTR Mkrule_11 (_coordref, _TERM1,_desc1)
	POSITION *_coordref;
	int _TERM1;
	NODEPTR _desc1;
#endif
{	_TPPrule_11 _currn;
#ifdef __cplusplus
_currn = new _TPrule_11;
#else
_currn = (_TPPrule_11) TreeNodeAlloc (sizeof (struct _TPrule_11));
#endif
_currn->_prod = RULErule_11;
_currn->_desc1 = (_TSPvalue) Mkvalue (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_11: root of subtree no. 1 can not be made a value node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_11;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "RegularExpr", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_11 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_12 (POSITION *_coordref, int _TERM1, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_12 (_coordref, _TERM1,_desc1,_desc2)
	POSITION *_coordref;
	int _TERM1;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_12 _currn;
#ifdef __cplusplus
_currn = new _TPrule_12;
#else
_currn = (_TPPrule_12) TreeNodeAlloc (sizeof (struct _TPrule_12));
#endif
_currn->_prod = RULErule_12;
_currn->_desc1 = (_TSPoptAuxScanner) MkoptAuxScanner (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_12: root of subtree no. 1 can not be made a optAuxScanner node ", 0, _coordref);
_currn->_desc2 = (_TSPoptProcessor) MkoptProcessor (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_12: root of subtree no. 2 can not be made a optProcessor node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_12;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "RegularExpr", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_12 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_13 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_13 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_13 _currn;
#ifdef __cplusplus
_currn = new _TPrule_13;
#else
_currn = (_TPPrule_13) TreeNodeAlloc (sizeof (struct _TPrule_13));
#endif
_currn->_prod = RULErule_13;
_currn->_desc1 = (_TSPlibrRef) MklibrRef (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 1 can not be made a librRef node ", 0, _coordref);
_currn->_desc2 = (_TSPoptAuxScanner) MkoptAuxScanner (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 2 can not be made a optAuxScanner node ", 0, _coordref);
_currn->_desc3 = (_TSPoptProcessor) MkoptProcessor (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 3 can not be made a optProcessor node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_13;
return ( (NODEPTR) _currn);
}/* Mkrule_13 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_14 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_14 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_14 _currn;
#ifdef __cplusplus
_currn = new _TPrule_14;
#else
_currn = (_TPPrule_14) TreeNodeAlloc (sizeof (struct _TPrule_14));
#endif
_currn->_prod = RULErule_14;
_SETCOORD(_currn)
_TERMACT_rule_14;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_14 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_15 (POSITION *_coordref)
#else
NODEPTR Mkrule_15 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_15 _currn;
#ifdef __cplusplus
_currn = new _TPrule_15;
#else
_currn = (_TPPrule_15) TreeNodeAlloc (sizeof (struct _TPrule_15));
#endif
_currn->_prod = RULErule_15;
_SETCOORD(_currn)
_TERMACT_rule_15;
return ( (NODEPTR) _currn);
}/* Mkrule_15 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_16 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_16 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_16 _currn;
#ifdef __cplusplus
_currn = new _TPrule_16;
#else
_currn = (_TPPrule_16) TreeNodeAlloc (sizeof (struct _TPrule_16));
#endif
_currn->_prod = RULErule_16;
_SETCOORD(_currn)
_TERMACT_rule_16;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_16 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_17 (POSITION *_coordref)
#else
NODEPTR Mkrule_17 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_17 _currn;
#ifdef __cplusplus
_currn = new _TPrule_17;
#else
_currn = (_TPPrule_17) TreeNodeAlloc (sizeof (struct _TPrule_17));
#endif
_currn->_prod = RULErule_17;
_SETCOORD(_currn)
_TERMACT_rule_17;
return ( (NODEPTR) _currn);
}/* Mkrule_17 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_18 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_18 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_18 _currn;
#ifdef __cplusplus
_currn = new _TPrule_18;
#else
_currn = (_TPPrule_18) TreeNodeAlloc (sizeof (struct _TPrule_18));
#endif
_currn->_prod = RULErule_18;
_currn->_desc1 = (_TSPvalue) Mkvalue (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_18: root of subtree no. 1 can not be made a value node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_18;
return ( (NODEPTR) _currn);
}/* Mkrule_18 */
