/* $Id: AttrDefs.h,v 1.2 1997/07/18 11:09:24 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#ifndef ATTRDEFS_H
#define ATTRDEFS_H

#include "args.h"
#include "envmod.h"
#include "err.h"
#include "List.h"

/* values of property AttrKind: */
#define	isMultiAttr	0
#define	isAttrName	1
#define	isChainAttr	2
#define	isSymbAttr	3
#define isLocAttr	4

#define MultipleSymComp -1

/* Environment that contains attr names and chains: */
extern Environment AttrNameEnv;

extern void NewSymCompNo FEARGS((DefTableKey k));

extern int GenAttrId;

extern Environment AttrPreDefs FEARGS((void));

extern DefTableKey DeclareAttrName FEARGS(( Environment scope,
					  int id, int kd, int tp, int cl,
					  POSITION *pos ));
/* On Exit:
	scope has an entry for the attribute name or chain name id.
	The kind (Attr, Chain), type, and class are set if they do
	not conflict with an already existing entry.
*/

extern DefTableKey DeclareExplAttr FEARGS(( Environment scope,
					  int id, int tp, int cl,
					  POSITION *pos));
/*On Exit:
	scope has an entry for the attribute id, the key is returned,
	class and type are set if they do not
	not conflict with an already existing entry.
	no chain check here!
*/

extern DefTableKey DeclareImplAttr FEARGS(( DefTableKey symkey,
					  int id, int cl,
					  POSITION *pos ));
/* On Exit:
	the key of an attr id for symkey is returned,
	the class is set if it does
	not conflict with an already existing entry.
	no chain check here!
*/

extern void MultDeclareImplAttr FEARGS(( TList symkeys, 
				       int attrid, POSITION *pos ));

extern void MultDeclareExplAttr FEARGS(( TList symkeys, 
				       int attrid, int typeid, int class,
				       POSITION *pos));
/*
	DeclareExplAttr applied to each of the symkeys.
*/

extern DefTableKey DeclareLocAttr FEARGS(( DefTableKey symkey,
					 int id, int prodid,
					 Environment namescope,
					 POSITION *pos ));

extern void UpdateClass FEARGS(( DefTableKey k, int cl, POSITION *pos));
extern void UpdateType FEARGS(( DefTableKey k, int tp, POSITION *pos));

#endif
