/*
 * $Id: dapto.h,v 1.22 1997/09/26 05:21:52 tony Exp $
 * Copyright (c) 1994-1997 Anthony M. Sloane
 */

/* This file is part of the Eli Module Library.

The Eli Module Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The Eli Module Library is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the Eli Module Library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Eli into the
   directory resulting from a :source derivation, you may use that
   created file as a part of that directory without restriction. */

#ifndef DAPTO_H
#define DAPTO_H

#include <stdlib.h>

extern int _dap_noosa_there;
extern char _dap_buf[], *_dap_mbuf, *_dap_cp;

#if defined(__cplusplus) || defined(__STDC__)
extern void _dap_init (char *);
extern void _dap_res (char *);
extern void _dap_res_num (long);
extern void _dap_arg (char **);
extern void _dap_arg_num (long *);
typedef void (*_dap_cmd_func)(char *);
extern void _dap_add_command (char *, _dap_cmd_func);
#else
extern void _dap_init ();
extern void _dap_res ();
extern void _dap_res_num ();
extern void _dap_arg ();
extern void _dap_arg_num ();
typedef void (*_dap_cmd_func)();
extern void _dap_add_command ();
#endif

extern void _dap_send ();

#include "dapto_dapto.h"

#define RETURN_RESULT return

#define RESULTINIT_OP \
    _dap_cp = _dap_mbuf; \
    *_dap_cp++ = 'r'; \
    *_dap_cp = '\0'

#define RESULTINIT_EV \
    _dap_cp = _dap_mbuf; \
    *_dap_cp++ = 'e'; \
    *_dap_cp = '\0'

#define RESULT(v) \
    _dap_res (v)

#define RESULTINT(v) \
    _dap_res_num (v)

#define RESULTLONG(v) \
    _dap_res_num (v)

#define RESULTPTR(v) \
    _dap_res_num ((long) v)

#define RESULTOTHER(v) \
    _dap_res_num (0)

#define ARGINIT_OP \
    _dap_cp = args
    
#define ARG(vp) \
    _dap_arg (vp)

#define ARGINT(vp) \
    _dap_arg_num ((long *) vp)
    
#define ARGPTR(vp) \
    _dap_arg_num ((long *) vp)

#define ARGOTHER(vp)

#endif
