// Eris Online RPG Protocol Library
// Copyright (C) 2007 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: Connection_unittest.cpp,v 1.2 2007-10-23 11:31:59 alriddoch Exp $

#include <Eris/Connection.h>

#include <Eris/Log.h>

static void writeLog(Eris::LogLevel, const std::string & msg)
{       
    std::cerr << msg << std::endl << std::flush;
}

int main()
{
    Eris::Logged.connect(sigc::ptr_fun(writeLog));
    Eris::setLogLevel(Eris::LOG_DEBUG);

    // Test constructor
    {
        new Eris::Connection("eristest", "localhost", 6767, true);
    }

    // Test destructor
    {
        delete new Eris::Connection("eristest", "localhost", 6767, true);
    }

    // Test getTypeService()
    {
        Eris::Connection c("eristest", "localhost", 6767, true);

        assert(c.getTypeService() != 0);
    }

    // Test connect()
    {
        Eris::Connection c("eristest", "localhost", 6767, true);
        
        int ret = c.connect();

        assert(ret == 0);
    }

    return 0;
}
