/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * log_window.c
 */
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <assert.h>
#include <glib.h>
#include "globals.h"
#include "contact.h"
#include "gtksctext.h"
#include "gtk_eb_html.h"
#include "log_window.h"
#include "util.h"
#include "pixmaps/cancel.xpm"


/* module private functions */
static void free_string_list(gpointer data, gpointer user_data)
{
  g_free(data);
}

static void free_gs_list(gpointer data, gpointer user_data)
{
  g_slist_foreach((GSList*)data, (GFunc)free_string_list, NULL);
  g_slist_free((GSList*)data);
}

static void create_html_widget(log_window* lw)
{  
  /* add in the html display */
  lw->html_display = gtk_sctext_new(NULL, NULL);
  gtk_eb_html_init(GTK_SCTEXT(lw->html_display));

  /* need to add scrollbar to the html text box*/
  lw->html_scroller = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(lw->html_scroller, 375, 150);
  gtk_container_add(GTK_CONTAINER(lw->html_scroller), lw->html_display);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(lw->html_scroller), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  gtk_box_pack_end(GTK_BOX(lw->date_html_hbox), lw->html_scroller, TRUE, TRUE, 5);  

  gtk_widget_show(GTK_WIDGET(lw->html_scroller));
  gtk_widget_show(GTK_WIDGET(lw->html_display));  
}

/* sets the html widget to display the log text */
static void set_html_text(GSList* gl, log_window* lw)
{
  GSList *h;

  /* need to destroy the html widget, and add it again */
  if (lw->html_display != NULL)
     gtk_widget_destroy(GTK_WIDGET(lw->html_display));
  if (lw->html_scroller != NULL)
	 gtk_widget_destroy(GTK_WIDGET(lw->html_scroller));


  /* create the html stuff */
  create_html_widget(lw);
  
  gtk_sctext_freeze(GTK_SCTEXT(lw->html_display)); /* cold snap */

  /* walk down the list and add the test */
  h = gl;  
  while (h != NULL) {
    if (h->data != NULL) {
      gtk_eb_html_add(GTK_SCTEXT(lw->html_display), (gchar*)h->data,0,0,0);
    }
    h = g_slist_next(h);
  }

  gtk_sctext_thaw(GTK_SCTEXT(lw->html_display)); /* and now, a warm front */

}

static void load_log_information(log_window* lw)
{
  gchar name_buffer[NAME_MAX];
  gchar read_buffer[4096];
  FILE* fp;
  gchar* p1, *p2;
  gchar date_buffer[128];
  gchar* p3[1];
  GSList* gl = NULL, *gl1 = NULL;
  gint idx;

  gtk_clist_freeze(GTK_CLIST(lw->date_list)); /* freeze, thaw?  So corny. */

  make_safe_filename(name_buffer, lw->remote->nick);
	
  if ( (fp = fopen(name_buffer, "r")) != NULL) {
    gl = g_slist_alloc();

    while (fgets(read_buffer, 4096, fp) != NULL) {
      if ((p1 = strstr(read_buffer, "Conversation started on ")) != NULL) 
	  {

	/* extract the date, I am not sure if this is portable (but it
	   works on my machine, so if someone wants to hack it, go ahead */
	p1 += strlen("Conversation started on ");

	/* if html tags are in the buffer, gotta strip the last two tags */
	if ((p2 = strstr(read_buffer, "</B></P>")) != NULL) {
	  strncpy(date_buffer, p1, p2 - p1);
	  date_buffer[p2-p1] = '\0';
	} else {
	  /* eww, c's string handling sucks */
	  strncpy(date_buffer, p1, (read_buffer + strlen(read_buffer)) - p1);
	  date_buffer[(read_buffer + strlen(read_buffer)) - p1] = '\0';
	}
	
	p3[0] = date_buffer;
	idx = gtk_clist_append(GTK_CLIST(lw->date_list), p3);

	/* add new gslist entry */
	gl1 = g_slist_alloc();
	gl = g_slist_append(gl, gl1);	

	/* set the datapointer for the clist */
	gtk_clist_set_row_data(GTK_CLIST(lw->date_list), idx, gl1);
      } else if ((p1 = strstr(read_buffer, "Conversation ended on ")) == NULL) {
	if (gl1 != NULL) {
	  gl1 = g_slist_append(gl1, strdup(read_buffer));
	}
	else
	{
			  char buff1[4096];
			  p3[0] = "Undated Log";

			  	strcpy(buff1, read_buffer);
				idx = gtk_clist_append(GTK_CLIST(lw->date_list), p3);

				/* add new gslist entry */
				gl1 = g_slist_alloc();
				gl = g_slist_append(gl, gl1);	

				/* set the datapointer for the clist */
				gtk_clist_set_row_data(GTK_CLIST(lw->date_list), idx, gl1);
				gl1 = g_slist_append(gl1, strdup(buff1));
	}
      }
    }
    fclose(fp);
  } else {
    perror(name_buffer);
  }

  lw->entries = gl;

  gtk_clist_thaw(GTK_CLIST(lw->date_list));
}


/* Event handlers */
static void destroy_event(GtkWidget* widget, gpointer data)
{
  log_window* lw = (log_window*)data;
  
  g_slist_foreach(lw->entries, (GFunc)free_gs_list, NULL);

  lw->remote->logwindow = NULL;
  lw->window = NULL;
  g_free(lw);
}

static void close_log_window_callback(GtkWidget* button, gpointer data)
{
  log_window* lw = (log_window*)data;
  gtk_widget_destroy(lw->window);
}

/* clist callbacks... about the only callback I'll be getting */
static void select_date_callback (GtkCList *clist, gint row, gint column, 
				  GdkEventButton *event, gpointer user_data)
{
  GSList* string_list;
  log_window* lw = (log_window*)user_data;

  string_list = (GSList*)gtk_clist_get_row_data(GTK_CLIST(clist), row);
  set_html_text(string_list, lw);
}

/* Window creation (let there be light!) */
log_window* eb_log_window_new(struct contact *rc)
{
  GtkWidget *iconwid0;
  GdkPixmap *icon0;
  GdkBitmap *mask;

  log_window* lw = g_new0(log_window, 1);
  char buffer[512];
  GtkWidget* vbox;
  GtkWidget* hbox;
  GtkWidget* button;
  GtkWidget* toolbar;

  lw->remote = rc;
  rc->logwindow = lw;
  lw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  /* show who the conversation is with */
  sprintf(buffer, "Past conversations with %s", rc->nick);
  gtk_window_set_title(GTK_WINDOW(lw->window), buffer);
  gtk_container_set_border_width(GTK_CONTAINER(lw->window), 5);
  

  /* for the html and list box */
  lw->date_html_hbox = gtk_hbox_new(FALSE, 0);

  lw->date_list = gtk_clist_new(1);
  gtk_clist_set_column_width(GTK_CLIST(lw->date_list), 0, 100);
  gtk_clist_set_selection_mode(GTK_CLIST(lw->date_list), GTK_SELECTION_BROWSE);

  /* scroll window for the date list */
  lw->date_scroller = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(lw->date_scroller, 180, 150);
  gtk_container_add(GTK_CONTAINER(lw->date_scroller), lw->date_list);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(lw->date_scroller), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  
  /* let the packing begin (god that sounds wrong) */
  gtk_box_pack_start(GTK_BOX(lw->date_html_hbox), lw->date_scroller, TRUE, TRUE, 5);
  vbox = gtk_vbox_new(FALSE, 0);  
  gtk_box_pack_start(GTK_BOX(vbox), lw->date_html_hbox, TRUE, TRUE, 5);
  gtk_container_add(GTK_CONTAINER(lw->window), vbox);

  gtk_signal_connect(GTK_OBJECT(lw->window), "destroy",
		     GTK_SIGNAL_FUNC(destroy_event), lw);

  /* buttons toolbar */
  hbox = gtk_hbox_new(FALSE, 0);
  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
  gtk_container_set_border_width(GTK_CONTAINER(toolbar), 0);

  /* need to realize the window for the pixmaps */
  gtk_widget_realize(GTK_WIDGET(lw->window));

  /* close button*/
  icon0 = gdk_pixmap_create_from_xpm_d(lw->window->window, &mask, NULL, cancel_xpm);
  iconwid0 = gtk_pixmap_new(icon0, mask);
  gtk_widget_show(iconwid0);
  button = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_BUTTON,
				   NULL,
				   "close",
				   "Close",
				   "close",
				   iconwid0,
				   GTK_SIGNAL_FUNC(close_log_window_callback),
				   lw);
  gtk_widget_show(GTK_WIDGET(button));
  gtk_widget_show(GTK_WIDGET(toolbar));

  gtk_box_pack_end(GTK_BOX(hbox), toolbar, FALSE, FALSE, 0);
  gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  /* connect signals to the date list */
  gtk_signal_connect(GTK_OBJECT(lw->date_list), "select-row", 
		     GTK_SIGNAL_FUNC(select_date_callback), lw);

  load_log_information(lw);  

  /* show everything... can you get arrested for baring it all? */
  gtk_widget_show(GTK_WIDGET(lw->date_list));
  gtk_widget_show(GTK_WIDGET(lw->html_display));
  gtk_widget_show(GTK_WIDGET(lw->date_scroller));
  gtk_widget_show(GTK_WIDGET(lw->date_html_hbox));
  gtk_widget_show(GTK_WIDGET(hbox));  
  gtk_widget_show(GTK_WIDGET(vbox));

  gtk_widget_show(GTK_WIDGET(lw->window));

  gtk_clist_select_row(GTK_CLIST(lw->date_list), 0, 0);

  return lw;
}
