/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * main.c
 * yipee
 */
#ifndef USE_APPLET
#include <gtk/gtk.h>
#else
#include <applet-widget.h>
#include "pixmaps/ebicon.xpm"
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#if defined( _WIN32 )
#include <direct.h>
#define mkdir( x, y )	_mkdir( x )
#else
#include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#include <errno.h>
#include <glib.h>
#include "status.h"
#include "service.h"
#include "plugin.h"
#include "globals.h"
#include "account.h"
#include "dialog.h"
#include "util.h"
#include "sound.h"
#include "libproxy/libproxy.h"
#include "console_session.h"

void eb_show_contact_list() { }

void eb_cli_ver ()
{
  printf("EveryBuddy v%s\n", VERSION); 
  printf("Copyright (C) 1999 Torrey Searle\n");
  printf("EveryBuddy comes with NO WARRANTY, to the extent permitted"
	 " by law.\n");
  printf("You may redistribute copies of EveryBuddy under the terms of the\n");
  printf("GNU General Public License.  For more information about these\n");
  printf("matters, see the file named COPYING.\n");
  printf("\nEveryBuddy is brought to you by: Torrey Searle, \n");
  printf("Jared Peterson, Ben Rigas, Jeff Miller, and Troy Morrison.\n");
  printf("\nFor more information on EveryBuddy, visit the website at\n");
  printf("         http://www.everybuddy.com/\n");
  return;
}

struct option_help
{
  const char   s_opt;
  const char * l_opt;
  const char * help;
};

struct option_help options [] =
{
  {'h', "help",       "Display this help and exit"},
  {'v', "version",    "Output version information and exit"},
  {'g', "geometry",   "Set position of main window"},
  {'d', "config-dir", "Specify configuration directory"},
  {'D', "disable-server",    "Disable console message server"},
  {'c', "contact",    "Specify contact to send a message to via console server"},
  {'m', "message",    "Specify the message to send via console server"},
  {' ', NULL,        "-c and -m must be used toegether"},
  {'\0', NULL,         NULL}
};



void eb_cli_help (const char * cmd)
{
  unsigned int i = 0;

  printf("Usage: %s [OPTION]...\n", cmd);
  printf("An integrated instant messenger program.\n");
  printf("Supports AIM, ICQ, MSN, Yahoo!, Jabber, and IRC.\n\n");

#if defined (HAVE_GETOPT) || defined (HAVE_GETOPT_LONG)

for (i = 0; options [i].help != NULL; i++)
{
#ifdef HAVE_GETOPT_LONG

  printf ("  %c%c  %2s%15s  %s\n",
	  (options [i].s_opt == ' ' ? ' ' : '-'), 
	  options [i].s_opt,
	  (options [i].l_opt == NULL ? "  " : "--"),
	  options [i].l_opt, 
	  options [i].help);

#else /* HAVE_GETOPT_LONG */

  /* Leaves HAVE_GETOPT */
  printf ("  %c%c  %s\n",
	  (options [i].s_opt == ' ' ? ' ' : '-'), 
	  options [i].s_opt,
	  options [i].help);

#endif /* HAVE_GETOPT_LONG */
}

#endif /* defined (HAVE_GETOPT) || defined (HAVE_GETOPT_LONG) */


  printf("\nReport bugs to tsearle@uci.edu or\n");
  printf("http://www.akropolys.com/cgi-bin/eb-bugs\n");
  return;
}


/* Global variable, referenced in globals.h */
char config_dir[1024] = "";
GtkWidget *current_parent_widget = NULL;


#ifdef USE_APPLET
	GtkWidget * applet;
	GtkWidget * applet_pixmap;

static void hide_window(GtkWidget * widget, GdkEvent * event, gpointer d)
{
	static int hidden = 0;
	printf("event\n");
	if(event->button.type == GDK_2BUTTON_PRESS && event->button.button == 1 && statuswindow)
	{
		if(hidden)
		{
			gtk_widget_show(statuswindow);
			hidden = 0;
		}
		else
		{
			gtk_widget_hide(statuswindow);
			hidden = 1;
		}
	}
}
#endif

void start_login(gboolean new)
{
   extern gint do_login_on_startup ;

   	if (new)
   		eb_new_user();
   	else
 	{
	    eb_show_contact_list();
		eb_status_window();
		if(do_login_on_startup) eb_sign_on_all(NULL, NULL) ;
	}
}
 
int main(int argc, char *argv[])
{

    int c = 0;
	int sock;
	int len;
	struct sockaddr_un local;
	char message[4096] = "";
	char contact[256] = "";
    gchar buff[1024];
	struct stat stat_buf;
	int disable_console_server = FALSE;
	gboolean accounts_success = FALSE;

	GtkWidget *wid;
	pid_t pid;
#ifdef USE_APPLET
	GdkPixmap * icon_pm;
	GdkPixmap * icon_bm;
#endif
	const char * cmd = argv [0];
	
    geometry[0] = 0;

/* Setup default value for config_dir */
#if defined( _WIN32 )
	strcpy(config_dir, "C:\\.everybuddy\\");
#else
	gtk_set_locale ();
	g_snprintf(config_dir, 1024, "%s/.everybuddy/",getenv("HOME"));
#endif

#if defined ( HAVE_GETOPT ) || defined ( HAVE_GETOPT_LONG )
    while (1) 
	{
#ifdef HAVE_GETOPT_LONG
		static struct option long_options[] = 
		{
	    	{"version", no_argument, NULL, 'v'},
		{"help", no_argument, NULL, 'h'},
	    	{"geometry", required_argument, NULL, 'g'},
	    	{"activate-goad-server", required_argument, NULL, 'a'},
	    	{"disable-server", no_argument, NULL, 'D'},
	    	{"contact", required_argument, NULL, 'c'},
	    	{"message", required_argument, NULL, 'm'},
	    	{"config-dir", required_argument, NULL, 'd'},
	    	{0, 0, 0, 0}
		};
    
		int option_index = 0;

		c = getopt_long(argc, argv, "vhg:a:d:Dc:m:", long_options, &option_index);
#else /* HAVE_GETOPT_LONG */
/* Either had getopt_long or getopt or both so getopt should be here */
		c = getopt (argc, argv, "vhg:a:d:dc:m:");
#endif
		/* Detect the end of the options. */

		if (c == -1)
		{
			break;
		}


		switch (c) 
		{
		    case 'v':           /* version information */
		        eb_cli_ver ();
		        exit(0);
			break;

		    case 'h':           /* help information */
		    case '?':
  		        eb_cli_help (cmd);
			exit (0);
		        break;

		    case 'g':
			strcpy(geometry, optarg);
			break;


		    case ':':
			printf("Try 'everybuddy --help' for more information.\n");
			exit(0);

		    case 'a':
			printf("hi\n");
			break;

		    case 'D':
			printf("Disabling console message server.\n");
			disable_console_server = TRUE;
			break;

		    case 'c':
			strcpy(contact, optarg);
			break;

		    case 'm':
			strcpy(message, optarg);
			break;

		    case 'd':
			strcpy(config_dir, optarg);
			/*Make sure we have directory delimiter */
#if defined( _WIN32 )
			if(config_dir[strlen(config_dir)-1]!='\\')
				strcat(config_dir, "\\");
#else
			if(config_dir[strlen(config_dir)-1]!='/')
				strcat(config_dir, "/");
#endif
			if(stat(config_dir, &stat_buf)==-1)
			{
				perror(config_dir);
				exit(errno);
			}
			if(!S_ISDIR(stat_buf.st_mode))
			{
				printf("config-dir %s is not a directory!\n", config_dir);
				exit(1);
			}
			break;

		}
    } 

#endif

	if(strlen(message) > 0 && strlen(contact) > 0)
	{
		struct sockaddr_un remote;
		int sock;
		short length;
		int ret;

		sock = socket(AF_UNIX, SOCK_STREAM, 0);
		strcpy(remote.sun_path, config_dir);
		strcat(remote.sun_path, "eb_socket");
		remote.sun_family = AF_UNIX;
		len = strlen(remote.sun_path) + sizeof(remote.sun_family) +1;
		if(connect(sock, (struct sockaddr*)&remote, len) == -1 )
		{
			perror("connect");
			exit(1);
		}
		length = strlen(contact)+1;
		write(sock, &length, sizeof(short));
		write(sock, contact, length);
		length = strlen(message)+1;
		write(sock, &length, sizeof(short));
		write(sock, message, length);
		read(sock, &ret, sizeof(int));
		close(sock);
		exit(ret);
	}

	sound_init();

#ifndef USE_APPLET
	gtk_set_locale();
	gtk_init(&argc, &argv);
#else /* USE_APPLET */

	#define PACKAGE "everybuddy"
	applet_widget_init(PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
#endif /* USE_APPLET */
	
/*	g_snprintf(buff, 1024, "%s",config_dir);*/

	/* Mizhi 04-04-2001 */
	g_snprintf(buff, 1024, "%s.lock", config_dir);
	if ((pid = create_lock_file(buff)) > 0) {
	  g_snprintf(buff, 1024, "Everybuddy already running, pid=%d\n", pid);
	  wid = do_error_dialog(buff, "Already logged on");
	  /* UGLY UGLY HACK... */
	  while (GTK_CHECK_TYPE(wid, GTK_TYPE_WINDOW) && GTK_WIDGET_VISIBLE(wid)){while (g_main_iteration(FALSE));}
	  exit(1);
	}

	gtk_set_locale ();
	g_snprintf(buff, 1024, "%s",config_dir);
		
	mkdir(buff, 0700);
	g_snprintf(buff, 1024, "%slogs",config_dir);
	mkdir(buff, 0700);
	g_snprintf(buff, 1024, "%sfiles",config_dir);
	mkdir(buff, 0700);

	if(!disable_console_server) {
		sock = socket(AF_UNIX, SOCK_STREAM, 0);
		strcpy(local.sun_path, config_dir);
		strcat(local.sun_path, "eb_socket");
		unlink(local.sun_path);
		local.sun_family = AF_UNIX;
		len = strlen(local.sun_path) + sizeof(local.sun_family) +1;
		if(bind(sock, (struct sockaddr *)&local, len) == -1)
		{
			perror("Unable to handle console connections.  bind");
			exit(1);
		}
		if(listen(sock, 5) == -1)
		{
			perror("Unable to handle console connections. listen");
			exit(1);
		}
		gdk_input_add(sock, GDK_INPUT_READ, console_session_init, NULL);
	}

	//proxy_set_proxy( PROXY_NONE, "", 0 );
	//proxy_set_proxy(PROXY_SOCKS5,"24.0.201.225",1080);

	system("update.pl");
	system("contact-update.pl");
	eb_read_prefs();
	/* Initalize the menus that are available through the plugin_api */
	init_menus();
	/* Load all the modules in the module_path preference, details can be found in the preferences module tab */
	load_modules();

	accounts_success = load_accounts();
	if(accounts_success)
	{
		load_contacts();
	}

	start_login(!accounts_success);

#ifndef USE_APPLET
    gtk_main();
#else
	applet = applet_widget_new(PACKAGE);
	gtk_widget_set_events( applet, gtk_widget_get_events(applet) |
			               GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
	gtk_signal_connect(GTK_OBJECT(applet),"button_press_event", GTK_SIGNAL_FUNC(hide_window), NULL);
	gtk_widget_realize(applet);
	icon_pm = gdk_pixmap_create_from_xpm_d(applet->window, &icon_bm,
			                          NULL, (gchar **)ebicon);
	applet_pixmap = gtk_pixmap_new(icon_pm, icon_bm);
	applet_widget_add(APPLET_WIDGET(applet), applet_pixmap);
	gtk_widget_show(applet_pixmap);
	gtk_widget_show(applet);
	
	applet_widget_gtk_main();

#endif

	sound_shutdown();
	g_snprintf(buff, 1024, "%s.lock", config_dir);
	if(!disable_console_server)
		unlink(local.sun_path);
        delete_lock_file(buff);

	return 0;

}
