
/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more etails.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * status.c
 * code for making the status changing widgets
 *
 */

#include <string.h>
#include <gtk/gtk.h>
#include <time.h>
#include <assert.h>
#include "service.h"
#include "globals.h"
#include "status.h"
#include "contact.h"
#include "account.h"
#include "chat_window.h"
#include "about.h"
#include "util.h"
#include "add_contact_window.h"
#include "dialog.h"
#include "away_window.h"
#include "message_parse.h"
#include "sound.h"
#include "trigger.h"
#include "triggerdecls.h"
#include "plugin.h"
#include "pixmaps/tb_preferences.xpm"
#include "pixmaps/tb_trash.xpm"
#include "pixmaps/login_icon.xpm"
#include "pixmaps/blank_icon.xpm"
#include "pixmaps/logoff_icon.xpm"

void update_contact_list ();

/*** MIZHI
 * log window
 */
#include "log_window.h"

enum {
	TARGET_STRING,
	TARGET_ROOTWIN,
	TARGET_URL
};

static GtkTooltips * status_tips=NULL;


/* Related to drag & drop so not killed */
/*
static GtkTargetEntry contact_list_drop_types[] =
{
	{ "STRING",     0, TARGET_STRING },
	{ "text/plain", 0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
	{ "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};
 
static gint n_contact_list_drop_types=
  sizeof(contact_list_drop_types)/sizeof(contact_list_drop_types[0]);
*/
/*
static GtkTargetEntry account_list_drop_types[] =
{
//	{ "application/x-eb-account", 0, EB_ACCOUNT }
};

static gint n_account_list_drop_types=
  sizeof(account_list_drop_types)/sizeof(account_list_drop_types[0]);
*/


GtkWidget *statuswindow = NULL;
GtkWidget *away_menu;

static GtkWidget * contact_list;
static GtkWidget * contact_window;
static GtkWidget * status_bar = 0;
static GtkWidget * status_message;

/* status_show is:
   0 => show all accounts,
   1 => show all contacts,
   2 => show online contacts
*/
static int status_show = 2;

static time_t last_sound_played = 0;

gboolean contact_drag_drop( GtkWidget * widget,
						   GdkDragContext *context,
						   gint x,
						   gint y,
						   guint time)
{
	grouplist * gl = gtk_object_get_user_data(GTK_OBJECT(widget));
	GtkWidget * source = gtk_drag_get_source_widget(context);
	struct contact * con = gtk_object_get_user_data(GTK_OBJECT(source));
	g_print("drop to %s\n", gl->name);
	move_contact(gl->name, con);
	update_contact_list ();
	write_contact_list();
	return TRUE;
}

static void delete_event( GtkWidget *widget,
				   GdkEvent *event,
				   gpointer data )
{
	GList * node = accounts;
	while(node)
	{
		if(node->data && ((eb_local_account*)(node->data))->connected)
          RUN_SERVICE(((eb_local_account*)(node->data)))->logout(node->data);
		node = node->next;
	}

	gtk_main_quit();
}
static GtkWidget * file_selector;

static void store_filename(GtkFileSelection *selector, eb_account * ea) 
{
	     char *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));
		 eb_local_account * ela = find_suitable_local_account( NULL, ea->service_id);
		 strcpy(filename, selected_filename);
		 RUN_SERVICE(ela)->send_im(ela, ea, "EB_COMMAND SEND_FILE");
}



static void send_file_callback(GtkWidget * w, eb_account * ea )
{

	file_selector = gtk_file_selection_new("Please select a file to send");

     
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                             "clicked", GTK_SIGNAL_FUNC (store_filename), ea);
                             
     /* Ensure that the dialog box is destroyed when the user clicks a button. */
     
     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);

     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);
     
     /* Display that dialog */
     
     gtk_widget_show (file_selector);

}

static void send_file_with_contact_callback(GtkWidget * w, struct contact * conn )
{
	eb_account * ea = find_suitable_remote_account( NULL, conn );

	file_selector = gtk_file_selection_new("Please select a file to send");

  	file_selector = gtk_file_selection_new("Please select a file for editing.");
     
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                             "clicked", GTK_SIGNAL_FUNC (store_filename), ea);
                             
     /* Ensure that the dialog box is destroyed when the user clicks a button. */
     
     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);

     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);
     
     /* Display that dialog */
     
     gtk_widget_show (file_selector);

}

/*** MIZHI
 * For displaying the logs
 */
static void view_log_callback(GtkWidget * w, struct contact * conn)
{  
  /*  if (cw->lw == NULL) { */
  if (conn->logwindow == NULL) {
    conn->logwindow = eb_log_window_new(conn);
  }
}

static void edit_trigger_callback(GtkWidget * w, struct contact * conn)
{
  show_trigger_window(conn);
}





static void edit_group_callback(GtkWidget * w, grouplist * g)
{
    edit_group_window_new(g);
}

static void edit_contact_callback(GtkWidget * w, struct contact * conn)
{
  edit_contact_window_new(conn);
}

/* This is not implemented YET */
/*
static void edit_account_callback(GtkWidget * w, gpointer a)
{
  edit_account_window_new(a);
}
*/


static void remove_group_callback(GtkWidget *w, gpointer d)
{
  if (gtk_object_get_user_data (GTK_OBJECT(w)) != 0)
    {
      grouplist * g = (grouplist *) d;

      eb_debug(DBG_CORE, "Delete Group");
      remove_group(g);
      
      update_contact_list ();
      write_contact_list();
    }
}

static void offer_remove_group_callback(GtkWidget *w, gpointer d)
{
  if (d != 0)
    {
      grouplist * g = (grouplist *) d;

      char buff [1024];
      sprintf (buff, "Do you really want to delete group \"%s\"?", g->name);

      do_dialog (buff, "Delete Group", remove_group_callback, d);
    }
}

static void remove_contact_callback(GtkWidget *w, gpointer d)
{
  if (gtk_object_get_user_data (GTK_OBJECT(w)) != 0)
    {
      struct contact * conn = (struct contact *) d;

      eb_debug(DBG_CORE, "Delete Account");
      remove_contact (conn);
      
      update_contact_list ();
      write_contact_list();
    }
}

static void offer_remove_contact_callback(GtkWidget *w, gpointer d)
{
  if (d != 0)
    {
      struct contact * c = (struct contact *) d;

      char buff [1024];
      sprintf (buff, "Do you really want to delete contact \"%s\"?", c->nick);

      do_dialog (buff, "Delete Contact", remove_contact_callback, d);
    }
}

static void remove_account_callback(GtkWidget *w, gpointer d)
{
  if (gtk_object_get_user_data (GTK_OBJECT(w)) != 0)
    {
      eb_debug(DBG_CORE, "Delete Account");
      remove_account(d);
      
      update_contact_list ();
      write_contact_list();
    }
}

static void offer_remove_account_callback(GtkWidget *w, gpointer d)
{
  if (d != 0)
    {
      struct account * a = (struct account *) d;

      char buff [1024];
      sprintf (buff, "Do you really want to delete account \"%s\"?",
	       a->handle);

      do_dialog (buff, "Delete Account", remove_account_callback, d);
    }
}









static void get_info(GtkWidget * w, eb_account *ea )
{
   
  eb_local_account * el;
  //eb_account * ea = find_suitable_remote_account( NULL, conn );

  if(ea) {
      el = find_suitable_local_account(NULL, ea->service_id);
      RUN_SERVICE(ea)->get_info(el ,ea);  
  }  else {
      eb_debug(DBG_CORE, "Couldn't find suitable local acount for info request");
      return;
  }  

}

void update_status_message(gchar * message )
{
	if(status_bar)
	{
		gtk_widget_destroy(status_message);
		status_message = gtk_label_new(message);
		gtk_container_add(GTK_CONTAINER(status_bar), status_message);
		gtk_widget_show(status_message);
	}
}


void collapse_contact( GtkTreeItem * treeItem, gpointer data )
{
	struct contact * c = data;
	c->expanded = FALSE;
}

void expand_contact( GtkTreeItem * treeItem, gpointer data )
{
	struct contact * c = data;
	c->expanded = TRUE;
}

static void status_show_callback(GtkWidget *w, gpointer data)
{
	status_show = (int)data;
	update_contact_list ();

}

static GtkWidget *make_info_menu(struct contact *c)
{
  GList *iterator;
  GtkWidget *InfoMenu = gtk_menu_new();
  GtkWidget *button;

  for(iterator=c->accounts; iterator; iterator=iterator->next)
  {
    eb_account * account = (eb_account*)iterator->data;
    if(account->online){
      button = gtk_menu_item_new_with_label(account->handle);
      gtk_signal_connect(GTK_OBJECT(button), "activate", GTK_SIGNAL_FUNC(get_info),account);
      gtk_menu_append(GTK_MENU(InfoMenu), button);
      gtk_widget_show(button);
    }
  }
  return InfoMenu;
}

/*
 * Menus raised by buttons
 */
    
static void group_menu(GdkEventButton * event, gpointer d )
{
  GtkWidget *menu;
  
  menu = gtk_menu_new();
  
  eb_menu_button (GTK_MENU(menu), "Edit Group",
		  GTK_SIGNAL_FUNC(edit_group_callback), d);

  eb_menu_button (GTK_MENU(menu), "Delete Group",
		  GTK_SIGNAL_FUNC(offer_remove_group_callback), d);
  
  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		 event->button, event->time );
}

static void contact_menu(GdkEventButton * event, gpointer d )
{
  GtkWidget *menu, *submenu;
  
  menu = gtk_menu_new();
  
  eb_menu_button (GTK_MENU(menu), "Edit Contact",
		  GTK_SIGNAL_FUNC(edit_contact_callback), d);

  eb_menu_button (GTK_MENU(menu), "Delete Contact",
		  GTK_SIGNAL_FUNC(offer_remove_contact_callback), d);
  
  eb_menu_button (GTK_MENU(menu), "Send File",
		  GTK_SIGNAL_FUNC(send_file_with_contact_callback), d);
  
  submenu = make_info_menu((struct contact *)d);
  eb_menu_submenu (GTK_MENU(menu), "Info", submenu);

  eb_menu_button (GTK_MENU(menu), "Edit Trigger",
		  GTK_SIGNAL_FUNC(edit_trigger_callback), d);

  /*** MIZHI
   * code for viewing the logs
   */
  eb_menu_button (GTK_MENU(menu), "View Log",
		  GTK_SIGNAL_FUNC(view_log_callback), d);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		 event->button, event->time );
}


static void account_menu(GdkEventButton * event, gpointer d )
{
  GtkWidget * menu;

  menu = gtk_menu_new();

  /* This isn't implemented *yet* */
  /*
  eb_menu_button (GTK_MENU(menu), "Edit Account",
		  GTK_SIGNAL_FUNC(edit_account_callback), d);
  */

  eb_menu_button (GTK_MENU(menu), "Delete Account",
		  GTK_SIGNAL_FUNC(offer_remove_account_callback), d);


  eb_menu_button (GTK_MENU(menu), "Send File",
		  GTK_SIGNAL_FUNC(send_file_callback), d);

  eb_menu_button (GTK_MENU(menu), "Info",
		  GTK_SIGNAL_FUNC(get_info),d);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		 event->button, event->time );

}

/*
 * End accounts raised by buttons
 */


/*
 * Mouse button event handlers for elements of the group/contact/account list
 */

static void group_click (GtkWidget *widget, GdkEventButton * event,
                         gpointer d)
{
  if (event->type == GDK_BUTTON_PRESS && event->button == 3)
    {
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),
				   "button_press_event");
      group_menu (event, d);
    }
}

static void contact_click (GtkWidget *widget, GdkEventButton * event,
                         gpointer d)
{
	if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	{
    		eb_chat_window_display_contact((struct contact *)d);
	}
	else if (event->type == GDK_BUTTON_PRESS && event->button == 3)
	{
	  gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),
				       "button_press_event");
	  contact_menu (event, d);
	}
}


static void account_click (GtkWidget *widget, GdkEventButton * event,
                         gpointer d)
{
  if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
    {
      eb_chat_window_display_account((eb_account *)d);
    }
  else if (event->type == GDK_BUTTON_PRESS && event->button == 3)
    {
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),
				   "button_press_event");
      account_menu (event, d);
    }
}

/*
 * End Mouse button event handlers for elements of the group/contact/account
 * list
 */

static void add_callback(GtkWidget *widget, GtkTree *tree)
{
	show_add_contact_window();
}

struct Status
{
    eb_local_account * ela;
    gint status;
};

void eb_edit_accounts( GtkWidget * widget, gpointer stats )
{
	eb_new_user();
}

void build_prefs_callback( GtkWidget * widget, gpointer stats )
{
	build_prefs();
}

void launch_group_chat( GtkWidget * widget, gpointer userdata )
{
	open_join_chat_window();

}

void eb_status( GtkWidget * widget, gpointer stats )
{
    struct Status *s;
    s = (struct Status *)stats;
    if (eb_services[s->ela->service_id].sc->get_current_state(s->ela) != s->status)
    	eb_services[s->ela->service_id].sc->set_current_state(s->ela, s->status);
    eb_debug(DBG_CORE, "%s set to state %d.\n", eb_services[s->ela->service_id].name, s->status );

}

void eb_sign_on_all(GtkWidget *widget, gpointer foo) {

  GList *node = accounts ;
  while(node) {
    if(!(((eb_local_account*)(node->data))->connected))
      RUN_SERVICE(((eb_local_account*)(node->data)))->login(node->data) ;
    node = node->next ;
  }

}

void eb_sign_off_all(GtkWidget *widget, gpointer foo) {

  GList *node = accounts ;
  while(node) {
    if(((eb_local_account*)(node->data))->connected)
      RUN_SERVICE(((eb_local_account*)(node->data)))->logout(node->data) ;
    node = node->next ;
  }

}

gint get_contact_position( struct contact * ec)
{
	gint i=0;
	GList *l;
	
	for (l = ec->group->members; l && (l->data != ec); l=l->next) 
	{
		struct contact * contact = l->data;
		if (contact->list_item)
			i++;
	}
	return i;
}

gint get_account_position( eb_account * ea)
{
	gint i=0;
	GList *l;
	
	for (l = ea->account_contact->accounts; l && (l->data != ea); l=l->next) {
		eb_account * account = l->data;
		if (account->list_item)
			i++;
	}
	return i;
}

/* General purpose update Contact List */
void update_contact_list ()
{
  GList * grps;
  GList * contacts;
  GList * accounts;

  grouplist * grp;
  struct contact * con;
  eb_account * ea;

  /* Error Check */
  if ( (status_show < 0) || (status_show > 2) ) { status_show = 2; }

  for (grps = groups; grps; grps = grps->next)
    {
      grp = grps->data;

      /* Currently, groups are always visible so we never touch them :) */

      for (contacts = grp->members; contacts; contacts = contacts->next)
	{
	  con = contacts->data;

	  /* Visibility of contact */

	  /* show_all_accounts presumes show_all_contacts */
	  if ((status_show == 1) || (status_show == 0))
	    {
	      /* MUST show the contact */
	      add_contact_line (con);
	      contact_update_status (con);
	    }
	  else
	    {
	      /* defer to whether it's online or not */

	      if (! con->online)
		{
		  remove_contact_line (con);
		}
	      else
		{
		  contact_update_status (con);
		}
	    }

	  for (accounts = con->accounts; accounts; accounts = accounts->next)
	    {
	      ea = accounts->data;

	      if ( (status_show == 0) || (status_show == 1) )
		{
		  /* definitely visible */

		  add_account_line(ea);
		  buddy_update_status(ea);

		  if (con->list_item == NULL)
		    {
		      /* Do nothing */
		      fprintf (stderr,
			"Account vanished after add_account_line.\n");
		    }
		  else if (status_show == 0)
		    {
		      /* MAKE IT VISIBLE NOW */

			gtk_tree_item_expand (GTK_TREE_ITEM(con->list_item));
		    }
		  else
		    {
			gtk_tree_item_collapse (GTK_TREE_ITEM(con->list_item));
		    }
		}
	      else
		{
		  /* Close it up */

		  if (ea->online)
		    {
		      buddy_update_status(ea);

		      if (con->list_item != NULL)
                    	{
                      	  gtk_tree_item_collapse
			    (GTK_TREE_ITEM(con->list_item));
                        }
                      else
                        {
                          fprintf (stderr, "Account missing while online?\n");
                        }
		    }
		  else
		    {
		      remove_account_line(ea);
		    }
		}
	    } /* End for loop for accounts */

	} /* End for loop for contacts */

    } /* End for loop for groups */

} /* end update_contact_list */

/* makes all accounts visible on the contact list */

/* shows a contact tree and its accounts and explicity draws
   each account rather than waiting for a login message from
   the server.  Useful for reshowing a contact after removing
   it from the buddy list. */
void add_contact_and_accounts(struct contact * c)
{
	GList *l;
	for (l = c->accounts; l; l = l->next) 
	{
		eb_account * ea = l->data;
		if ((status_show == 0) || (status_show == 1) || ea->online) 
		{
			add_account_line(ea);
			buddy_update_status(ea);
		}
	}
}

static GdkPixmap * iconlogin_pm = NULL;
static GdkBitmap * iconlogin_bm = NULL;
static GdkPixmap * iconblank_pm = NULL;
static GdkBitmap * iconblank_bm = NULL;
static GdkPixmap * iconlogoff_pm = NULL;
static GdkBitmap * iconlogoff_bm = NULL;


/*
 * Add/Remove entries to/from box -- group, contact, account
 */

/* makes a group visible on the contact list */
void add_group_line(grouplist * eg)
{
	GtkWidget * box;

	/* Might call add_group() - which calls add_group_line() 
	   before contact_list exists - this is OK so just return */
	if (eg->list_item || !contact_list)
		return;
		
	eg->list_item = gtk_tree_item_new();

	box = gtk_hbox_new(FALSE, 1);

	eg->label = gtk_label_new(eg->name);
	gtk_label_set_justify(GTK_LABEL(eg->label), GTK_JUSTIFY_LEFT);

	gtk_box_pack_start(GTK_BOX(box), eg->label, FALSE, FALSE, 1);
	gtk_widget_show(eg->label);

	gtk_container_add(GTK_CONTAINER(eg->list_item), box);
	gtk_widget_show(box);

	gtk_object_set_user_data(GTK_OBJECT(eg->list_item), (gpointer)eg);
	eg->contacts_online = 0;
	eg->contacts_shown = 0;
	eg->tree = NULL;
	gtk_tree_append(GTK_TREE(contact_list), eg->list_item);

	gtk_signal_connect(GTK_OBJECT(eg->list_item),  "button_press_event",
			   GTK_SIGNAL_FUNC(group_click),
			   (grouplist *)eg );
	
	gtk_widget_show(eg->list_item);
}

/* makes an account visible on the buddy list, making the contact visible
   if necessary */
void add_account_line( eb_account * ea)
{
	GtkWidget * box, * label;
	
	if (ea->list_item)
		return;
	
	add_contact_line(ea->account_contact);

	ea->list_item = gtk_tree_item_new();

	box = gtk_hbox_new(FALSE, 1);
	ea->pix = gtk_pixmap_new(iconblank_pm, iconblank_bm);
	label = gtk_label_new(ea->handle);
	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ea->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		ea->status = gtk_label_new(c);
		g_free(c);
	}

	gtk_box_pack_start(GTK_BOX(box), ea->pix, FALSE, FALSE, 1);
	gtk_widget_show(ea->pix);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 1);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(box), ea->status, FALSE, FALSE, 1);
	gtk_widget_show(ea->status);

	gtk_container_add(GTK_CONTAINER(ea->list_item), box);
	gtk_widget_show(box);

	ea->icon_handler = -1;

	gtk_object_set_user_data(GTK_OBJECT(ea->list_item), ea);
	gtk_tree_insert(GTK_TREE(ea->account_contact->tree), ea->list_item,
		get_account_position(ea));

	gtk_signal_connect(GTK_OBJECT(ea->list_item),  "button_press_event",
				  GTK_SIGNAL_FUNC(account_click),
				  (eb_account *)ea );

	gtk_widget_show(ea->list_item);

}

/* makes a contact visible on the buddy list */
void add_contact_line( struct contact * ec)
{
	GtkWidget * box;
	
	if (ec->list_item)
		return;
	
	ec->list_item = gtk_tree_item_new();
	ec->tree = gtk_tree_new();

	box = gtk_hbox_new(FALSE, 1);
	ec->pix = gtk_pixmap_new(iconblank_pm, iconblank_bm);
	ec->label = gtk_label_new(ec->nick);
	ec->status = gtk_label_new("");

	gtk_box_pack_start(GTK_BOX(box), ec->pix, FALSE, FALSE, 1);
	gtk_widget_show(ec->pix);
	gtk_misc_set_alignment(GTK_MISC(ec->label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(box), ec->label, TRUE, TRUE, 1);
	gtk_widget_show(ec->label);
	gtk_box_pack_start(GTK_BOX(box), ec->status, FALSE, FALSE, 1);
	gtk_widget_show(ec->status);

	gtk_container_add(GTK_CONTAINER(ec->list_item), box);
	gtk_widget_show(box);

	ec->icon_handler = -1;

	gtk_object_set_user_data(GTK_OBJECT(ec->list_item), ec);
	
	if (!ec->group->contacts_shown) {
		ec->group->tree = gtk_tree_new();
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(ec->group->list_item),
			ec->group->tree);
		if(strcmp("Unknown",ec->group->name) !=0 &&
		   strcmp("Ignore",ec->group->name) !=0)
		gtk_tree_item_expand(GTK_TREE_ITEM(ec->group->list_item));
	}
	
	ec->group->contacts_shown++;
	gtk_tree_insert(GTK_TREE(ec->group->tree), ec->list_item,
		get_contact_position(ec));


	gtk_tree_item_set_subtree(GTK_TREE_ITEM(ec->list_item), ec->tree);
	if(ec->expanded)
		gtk_tree_item_expand(GTK_TREE_ITEM(ec->list_item));
	else
		gtk_tree_item_collapse(GTK_TREE_ITEM(ec->list_item));

	gtk_signal_connect(GTK_OBJECT(ec->list_item),  "button_press_event",
				  GTK_SIGNAL_FUNC(contact_click),
				  (struct contact*)ec );
	gtk_signal_connect(GTK_OBJECT(ec->list_item), "expand",
				  GTK_SIGNAL_FUNC(expand_contact), (struct contact*)ec);
	gtk_signal_connect(GTK_OBJECT(ec->list_item), "collapse",
				  GTK_SIGNAL_FUNC(collapse_contact), (struct contact*)ec );
		
	gtk_widget_show(ec->list_item);	
}

/* hides a group on the buddy list */
void remove_group_line( grouplist * eg)
{
	GList * contacts;
	
	if (!eg->list_item)
		return;
		
	for (contacts = eg->members; contacts; contacts = contacts->next) {
		struct contact * ec = contacts->data;
		if (ec->list_item)
			remove_contact_line(ec);
	}
		
	gtk_container_remove(GTK_CONTAINER(contact_list), eg->list_item);
	eg->list_item = NULL;
	eg->tree = NULL;
	eg->label = NULL;
}



/* hides an account on the buddy list, hiding any child accounts in the
   process */
void remove_contact_line( struct contact * ec)
{
	GList * accounts;
	
	if (!ec->list_item)
		return;
		
	for (accounts = ec->accounts; accounts; accounts = accounts->next) {
		eb_account * ea = accounts->data;
		if (ea->list_item)
			remove_account_line(ea);
	}
	
	ec->group->contacts_shown--;
	gtk_container_remove(GTK_CONTAINER(ec->group->tree), ec->list_item);
	ec->list_item = NULL;
	ec->tree = NULL;
	ec->pix = NULL;
	ec->status = NULL;
	ec->label = NULL;
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
	ec->icon_handler = -1;
}


/* hides an account on the buddy list (removes it from the tree) */
void remove_account_line( eb_account * ea)
{

	if (!ea || !ea->account_contact || !ea->list_item) {
		if(!ea->account_contact)
			eb_debug(DBG_CORE, "Not removing account_line, ea->account_contact is NULL !\n");
		return;
	}

	gtk_container_remove(GTK_CONTAINER(ea->account_contact->tree), ea->list_item);
	ea->list_item = NULL;
	ea->pix = NULL;
	ea->status = NULL;
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = -1;
}

/* timeout function called 10 seconds after a contact logs off
   (removes the logoff icon and hides the contact if necessary) */
gint hide_contact(struct contact * ec)
{
	GList * l;
	
	if (ec->icon_handler == -1)
		return FALSE;
	ec->icon_handler = -1;
	
	if (status_show == 2)		
		remove_contact_line(ec);
	else
		for (l = ec->accounts; l; l = l->next) {
			eb_account * account = l->data;
			buddy_update_status(account);
		}
	
	return FALSE;
}

/* timeout function called 10 seconds after an account logs off
   (removes the logoff icon and hides the account if necessary)
   This timeout is only set when other accounts in the parent
   contact are remaining shown */
gint hide_account(eb_account * ea)
{
	if (ea->icon_handler == -1)
		return FALSE;
	ea->icon_handler = -1;
			
	if (!ea->list_item)
		return FALSE;
			
	if ((status_show == 2) || (status_show == 1))
		remove_account_line(ea);
	else
		buddy_update_status(ea);
	return FALSE;
}

/* update the status info (pixmap and state) of a contact */
void contact_update_status(struct contact * ec)
{
	GdkPixmap * pm;
	GdkBitmap * bm;
	eb_account * ea = NULL;
	GList * l;
	int width, height;
	int width2, height2;
	int width3, height3;

	/* find the account who's status information should be reflected in
	   the contact line (preferably the default protocol account, but
	   if that one is not logged on, use another) */
	for (l = ec->accounts; l; l = l->next) 
	{
		eb_account * account = l->data;
		if (!ea)
			ea = account;
		if (!ea->online && account->online)
			ea = account;
		if (ec->default_chatb != ea->service_id && account->online &&
				ec->default_chatb == account->service_id)
			ea = account;
	}

	if (!ea)
		return;

	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ec->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		gtk_label_set_text(GTK_LABEL(ec->status), c);
		g_free(c);
	}
	gtk_label_set_text(GTK_LABEL(ec->label), ec->nick);

	/* set the icon if there isn't another timeout about to alter the icon */
	if (ec->icon_handler == -1) 
	{
		RUN_SERVICE(ea)->get_status_pixmap(ea, &pm, &bm);
		gtk_pixmap_set(GTK_PIXMAP(ec->pix), pm, bm);
	}

	width = contact_list->allocation.width;
	height = contact_list->allocation.height;

	if(GTK_WIDGET_VISIBLE(GTK_SCROLLED_WINDOW(contact_window)->vscrollbar))
	{
		width3 = GTK_SCROLLED_WINDOW(contact_window)->vscrollbar->allocation.width;
		height3 = GTK_SCROLLED_WINDOW(contact_window)->vscrollbar->allocation.height;
	}
	else
	{
		width3 = 0, height3 = 0;
	}

	width2 = contact_window->allocation.width;
	height2 = contact_window->allocation.height;

	if(width+width3> width2)
	{
		gtk_widget_set_usize(contact_window,width+width3+2,height2);
	}
	
}

/* update the status info (pixmap and state) of an account */
void buddy_update_status(eb_account * ea)
{
	GdkPixmap * pm;
	GdkBitmap * bm;
	if (!ea || !ea->list_item)
		return;
	
	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ea->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		gtk_label_set_text(GTK_LABEL(ea->status), c);
		g_free(c);
	}

	/* update the icon if another timeout isn't about to change it */
	if (ea->icon_handler == -1) {
		RUN_SERVICE(ea)->get_status_pixmap(ea, &pm, &bm);
		gtk_pixmap_set(GTK_PIXMAP(ea->pix), pm, bm);
	}

	/* since the contact's status info  might be a copy of this
	   account's status info, we should refresh that also */	
	contact_update_status(ea->account_contact);	
}

/* the timeout function called after a contact logs in (to take the
   "open door" icon away) */
gint set_contact_icon(struct contact * ec)
{
	/* abort if another timeout already took care of it */
	if (ec->icon_handler == -1)
		return FALSE;
	ec->icon_handler = -1;
		
	contact_update_status(ec);
	return FALSE;
}

/* the timeout function called after an account logs in (to take the
   "open door" icon away) */
gint set_account_icon(eb_account * ea)
{
	/* abort if another timeout already took care of it */
	if (ea->icon_handler == -1)
		return FALSE;
	ea->icon_handler = -1;

	buddy_update_status(ea);
	return FALSE;
}

/* function called when a contact logs in */
void contact_login(struct contact * ec)
{
	char buff[1024];
	ec->group->contacts_online++;

	/* display the "open door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ec->pix), iconlogin_pm, iconlogin_bm);
	
	/* remove any other timeouts (if a user just logged out immediately before) */
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
		
	/* timeout to set the contact icon in 10 seconds */
	ec->icon_handler = gtk_timeout_add(10000, (GtkFunction)set_contact_icon,
		(gpointer) ec);

	if((time(NULL) - last_sound_played > 0) && do_online_sound)
	{
		/* If we have the do_no_sound_for_ignore flag set,
		   only play the sound if the contact is not ignored. */
		if (!do_no_sound_for_ignore ||
		(strcasecmp(ec->group->name, "Ignore") != 0))
		{
			play_sound(BUDDY_ARRIVE);
			last_sound_played = time(NULL);
		}
	}
	
	do_trigger_online(ec);
	
	eb_chat_window_do_timestamp(ec, 1);
	g_snprintf(buff, 1024, "%s is now online", ec->nick);
	update_status_message(buff);
}

/* function called when a contact logs off */
void contact_logoff(struct contact * ec)
{
	char buff[1024];
	/* display the "closed door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ec->pix), iconlogoff_pm, iconlogoff_bm);
	ec->group->contacts_online--;
	
	/* remove any other timeouts (if the user just logged in) */
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
		
	/* timeout to remove the contact from the list */
	ec->icon_handler = gtk_timeout_add(10000, (GtkFunction)hide_contact,
		(gpointer) ec);

	if((time(NULL) - last_sound_played > 0) && do_online_sound)
	{
		/* If we have the do_no_sound_for_ignore flag set,
		   only play the sound if the contact is not ignored. */
		if (!do_no_sound_for_ignore ||
		(strcasecmp(ec->group->name, "Ignore") != 0))
		{
			play_sound(BUDDY_LEAVE);
			last_sound_played = time(NULL);
		}
	}

	do_trigger_offline(ec);

	eb_chat_window_do_timestamp(ec, 0);
	g_snprintf(buff, 1024, "%s is now offline", ec->nick);
	update_status_message(buff); 
}

/* timeout called every 30 seconds for each online account to update
   its status */
gint refresh_buddy_status(eb_account * ea)
{
	/* remove the timeout if the account is no longer displayed */
	if (!ea->list_item || ea->status_handler == -1) {
		ea->status_handler = -1;
		return FALSE;
	}
	
	/* don't refresh if a "door" icon is being displayed */
	if (ea->icon_handler != -1)
		return TRUE;
		
	buddy_update_status(ea);
	return TRUE;
}

/* called to signify that a buddy has logged in, and updates the GUI
   accordingly */
void buddy_login(eb_account * ea)
{
	
	/* don't do anything if this has already been done */
	if (ea->online)
		return;
	
	ea->account_contact->online++;
	ea->online = TRUE;
	
	if (do_ignore_unknown && !strcmp("Unknown", ea->account_contact->group->name))
		return;
	
	add_account_line(ea);
	
	/* sets the "open door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ea->pix), iconlogin_pm, iconlogin_bm);

	/* set the timeout to remove the "open door" icon */
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = gtk_timeout_add(10000, (GtkFunction)set_account_icon,
		(gpointer) ea);
	
	/* if there is only one account (this one) logged in under the
	   parent contact, we must login the contact also */
	if (ea->account_contact->online == 1)
		contact_login(ea->account_contact);
		
	buddy_update_status(ea);
	
	/* make sure the status gets updated often */
	ea->status_handler = gtk_timeout_add(30000,
		(GtkFunction)refresh_buddy_status, (gpointer) ea);
}

/* called to signify that a buddy has logged off, and updates the GUI
   accordingly */
void buddy_logoff(eb_account * ea)
{
	
	/* don't do anything if this has already been done */
	if (!ea || !ea->online)
		return;
	
	ea->account_contact->online--;
	ea->online = FALSE;

	if (do_ignore_unknown && !strcmp("Unknown", ea->account_contact->group->name))
		return;

	/* sets the "closed door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ea->pix), iconlogoff_pm, iconlogoff_bm);

	/* removes any previously set timeouts for the account */ 
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = -1;
	if (ea->status_handler != -1)
		gtk_timeout_remove(ea->status_handler);
	ea->status_handler = -1;
	
	/* if this is the last account of the parent contact to log off,
	   we must log off the contact also */
	if (ea->account_contact->online == 0)
		contact_logoff(ea->account_contact);

	/* timeout to remove the "close door" icon */
	ea->icon_handler = gtk_timeout_add(10000, (GtkFunction)hide_account,
		(gpointer) ea);

}

void update_contact_window_length ()
{
  gtk_widget_set_usize(contact_window, 150, 4 + 16 * iGetLocalPref("length_contact_window"));
}

/* Generates the contact list tree (should only be called once) */
GtkWidget* MakeContactList()
{
	GList * l1;
	
	contact_window = gtk_scrolled_window_new(NULL, NULL);
	contact_list = gtk_tree_new();

	for( l1 = groups; l1; l1=l1->next )
	{
		grouplist * grp = l1->data;
		add_group_line(grp);
	}
	
	gtk_widget_show(contact_list);
	gtk_scrolled_window_add_with_viewport
	  (GTK_SCROLLED_WINDOW(contact_window),
	   contact_list);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(contact_window),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	/*                                        pad + rows * their size */
	update_contact_window_length ();
	return (contact_window);
}



GtkWidget* MakeStatusMenu(eb_local_account * ela)
{
  GtkWidget* status_menu_item;
  GtkWidget* status_menu;
  GList * status_label;
  GList * temp_list;
  GtkWidget* hbox, *label;
  GtkStyle* style;
  GSList * group = NULL;
  GSList * widgets = NULL;
  int x;
  gchar string[255];
  status_menu = gtk_menu_new();
  style = gtk_widget_get_style(status_menu);

  assert(ela);
  gtk_widget_realize(status_menu);
  status_label = eb_services[ela->service_id].sc->get_states();

  status_menu_item = gtk_tearoff_menu_item_new();
  gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
  gtk_widget_show(status_menu_item);
  for(temp_list = status_label, x = 0; temp_list; x++, temp_list=temp_list->next)
  {
      struct Status * stats = g_new0(struct Status, 1);
      stats->ela = ela;
      stats->status= x;
      status_menu_item = gtk_radio_menu_item_new(group);
	  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(status_menu_item));
	  widgets = g_slist_append(widgets, status_menu_item);
      hbox = gtk_hbox_new(FALSE, 3);
      label = gtk_label_new((gchar*)temp_list->data);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
      gtk_widget_show(label);
      gtk_widget_show(hbox);
      gtk_widget_show(status_menu_item);
      gtk_container_add(GTK_CONTAINER(status_menu_item), hbox);
      gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
      gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
                         eb_status, (gpointer) stats );

  }

  ela->status_menu = widgets;

  g_snprintf(string, 255, "%s [%s]", ela->handle, get_service_name(ela->service_id));

  ela->status_button = gtk_menu_item_new_with_label(string);
  
  /* The following doesn't work!  Why? */
  /*
  gtk_menu_set_active(GTK_MENU(status_menu), 
                   eb_services[ela->service_id].sc->get_current_state(ela) );
  */

  /* So why not use "gtk_check_menu_item_set_active"?  Well, that method
     emits a signal.  What was happening was that it would send a signal
	 from the zeroth status item (usually "online") for some reason
	 _and_ from the one we want.  It's as if the signal from the zeroth item
	 was already in some queue.  Anyway, this would cause a status change to 
	 online and then back again for each protocol.  This causes unpredictable 
	 behavior when the user is offline. */
  
  /* First deactivate zeroth status radio item */
  GTK_CHECK_MENU_ITEM(g_slist_nth(widgets, 0)->data)->active = 0 ;
  /* Now, activate the desired status radio item */
  GTK_CHECK_MENU_ITEM(
    g_slist_nth(
	             widgets, 
                 eb_services[ela->service_id].sc->get_current_state(ela)
			   )->data
  )->active = 1 ;
  
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(ela->status_button), status_menu);
  
  g_list_free(status_label);

  return ela->status_button;
}

/*This function is to be eventually phased out*/

/*
GtkWidget* MakeStatusButton(eb_local_account * ela)
{
  GtkWidget* status_menu_item;
  GtkWidget* status_menu;
  GList * status_label;
  GList * temp_list;
  GtkWidget* hbox, *label;
  GtkStyle* style;
  int x;
  status_menu = gtk_menu_new();
  style = gtk_widget_get_style(status_menu);

  gtk_widget_realize(status_menu);
  status_label = eb_services[ela->service_id].sc->get_states();

  for(temp_list = status_label, x = 0; temp_list; x++, temp_list=temp_list->next)
  {
      struct Status * stats = g_new0(struct Status, 1);
      stats->ela = ela;
      stats->status= x;
      status_menu_item = gtk_menu_item_new();
      hbox = gtk_hbox_new(FALSE, 3);
      label = gtk_label_new((gchar*)temp_list->data);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
      gtk_widget_show(label);
      gtk_widget_show(hbox);
      gtk_widget_show(status_menu_item);
      gtk_container_add(GTK_CONTAINER(status_menu_item), hbox);
      gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
      gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
                         eb_status, (gpointer) stats );

  }

  ela->status_button = gtk_option_menu_new();
  gtk_menu_set_active(GTK_MENU(status_menu),
					 eb_services[ela->service_id].sc->get_current_state(ela) );
  gtk_option_menu_set_menu(GTK_OPTION_MENU(ela->status_button), status_menu);
  
  g_list_free(status_label);

  return ela->status_button;
}
*/
#include <X11/Xlib.h>

void eb_import_function(GtkWidget *widget, gpointer callback) {
	void (*callback_function)();

	assert(callback);
	callback_function = callback;
	fprintf(stderr, "eb_import_function: calling callback\n");
	callback_function();
	update_contact_list ();
	write_contact_list();
}

void eb_import_window(GtkWidget *import_submenuitem)
{
	GtkWidget *label;
	// import_items is a list of struct callback_items
	GList *list=NULL;
	GtkWidget * import_menu = gtk_menu_new();
	menu_data *md=NULL;
	menu_item_data *mid=NULL;

	label = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(import_menu), label);
	gtk_widget_show(label);

	eb_debug(DBG_CORE, ">\n");
    /* import_items is a list that is maintained as a pref, modified by calls to eb_add_menu_item */
	md = GetPref(EB_IMPORT_MENU);
	if(md) {
		for(list = md->menu_items; list; list  = g_list_next(list) ) {
			mid=(menu_item_data *)list->data;
			eb_debug(DBG_CORE, "adding import item: %s\n", mid->label);
			label = gtk_menu_item_new_with_label(mid->label);
			gtk_menu_append(GTK_MENU(import_menu), label);
			gtk_signal_connect(GTK_OBJECT(label), "activate",
					eb_import_function, mid->callback);
			gtk_widget_show(label);  
		}
	}
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(import_submenuitem), import_menu);
	gtk_widget_show(import_menu);
	gtk_widget_show(import_submenuitem);
	eb_debug(DBG_CORE, "<\n");
}

void eb_set_status_window(GtkWidget *set_status_submenuitem)
{
	GtkWidget *label;
	GtkWidget * account_menu = gtk_menu_new();
	GList *list=NULL;

	label = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(account_menu), label); 
	gtk_widget_show(label);
	for(list = accounts; list; list  = g_list_next(list) )
	{
		label = MakeStatusMenu(list->data);
		((eb_local_account*)(list->data))->status_button = label;
		gtk_menu_append(GTK_MENU(account_menu), label);
		gtk_widget_show(label);
	}
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(set_status_submenuitem), account_menu);
	gtk_widget_show(account_menu);
	gtk_widget_show(set_status_submenuitem);
}

void eb_status_window()
{
  GtkWidget *statusbox;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *menubox;
  GtkWidget *menu;
  GtkWidget *submenu;
  GtkWidget *menuitem;
  GtkWidget *submenuitem;
  GtkWidget *hbox;
  
  int win_x, win_y, win_w, win_h;
  int flags;



        statuswindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* The next line allows you to make the window smaller than the orig. size */
	gtk_window_set_policy(GTK_WINDOW(statuswindow), TRUE, TRUE, TRUE);
        gtk_widget_realize(statuswindow);

		iconlogin_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconlogin_bm,
			NULL, (gchar **) login_icon_xpm);
		iconblank_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconblank_bm,
			NULL, (gchar **) blank_icon_xpm);
		iconlogoff_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconlogoff_bm,
			NULL, (gchar **) logoff_icon_xpm);

	/* handle geometry - ivey */

	if (geometry[0] != 0) { 
	    flags = XParseGeometry(geometry, &win_x, &win_y, &win_w, &win_h);
	    /* proper negative handling comes later... 
		if ((flags & XValue) && (flags & XNegative))
		    *win_x = DisplayWidth(display, screenNum) - *win_x;
		if ((flags & YValue) && (flags & YNegative))
		    *win_y = DisplayHeight(display, screenNum) - *win_y;
	    */
	    gtk_window_set_position(GTK_WINDOW(statuswindow), GTK_WIN_POS_NONE); 
	    gtk_widget_set_uposition(statuswindow, win_x, win_y); 
	    gtk_widget_set_usize(statuswindow, win_w, win_h);
	}
		statusbox = gtk_vbox_new(FALSE, 0);
		
		menubox = gtk_handle_box_new();
		gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(menubox), GTK_POS_LEFT);
		gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(menubox), GTK_POS_LEFT);
		gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(menubox), GTK_SHADOW_NONE);
		menu = gtk_menu_bar_new();
		

		menuitem = gtk_menu_item_new_with_label("File");
		gtk_widget_show(menuitem);
	
		submenu = gtk_menu_new();
		submenuitem = gtk_tearoff_menu_item_new();
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_widget_show(submenuitem);
		
		/* The import sub menu */
		submenuitem = gtk_menu_item_new_with_label("Import");
		gtk_menu_append(GTK_MENU(submenu), submenuitem );
		eb_import_window(submenuitem);
		/* Make sure we can access this later to update the import menu */
		SetPref("widget::import_submenuitem", submenuitem);
		
		/* The Set status menus */
		submenuitem = gtk_menu_item_new_with_label("Set Status");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		eb_set_status_window(submenuitem);
		SetPref("widget::set_status_submenuitem", submenuitem);

		submenuitem = gtk_menu_item_new_with_label("Sign On All") ;
		gtk_menu_append(GTK_MENU(submenu), submenuitem ) ; 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu) ;
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								  eb_sign_on_all,
								  NULL) ;
		gtk_widget_show(submenuitem) ;
		gtk_widget_show(submenu) ;
        
		submenuitem = gtk_menu_item_new_with_label("Sign Off All") ;
		gtk_menu_append(GTK_MENU(submenu), submenuitem ) ; 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu) ;
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								  eb_sign_off_all,
								  NULL) ;
		gtk_widget_show(submenuitem) ;
		gtk_widget_show(submenu) ;
        
		submenuitem = gtk_menu_item_new_with_label("Exit");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								 GTK_SIGNAL_FUNC(delete_event),
								 GTK_OBJECT(statuswindow));
		gtk_widget_show(submenuitem);
		gtk_widget_show(submenu);
		
		
		gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);

		menuitem = gtk_menu_item_new_with_label("Tools");
		gtk_widget_show(menuitem);
	
		submenu = gtk_menu_new();
		submenuitem = gtk_tearoff_menu_item_new();
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_widget_show(submenuitem);

                submenuitem = gtk_menu_item_new_with_label("Preferences");
                gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         build_prefs_callback, NULL );
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_widget_show(submenuitem);  
		

                submenuitem = gtk_menu_item_new_with_label("Add Contact");
                gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
				   GTK_SIGNAL_FUNC(add_callback), NULL );
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_widget_show(submenuitem);  
		
		submenuitem = gtk_menu_item_new_with_label("Group Chat");
                gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         launch_group_chat, NULL );
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_widget_show(submenuitem);
      
		submenuitem = gtk_menu_item_new_with_label("Set As Away");
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		{
			away_menu = gtk_menu_new();

			load_away_messages();
			build_away_menu();

			gtk_menu_item_set_submenu(GTK_MENU_ITEM(submenuitem), away_menu);
			gtk_widget_show(away_menu);
		}
		gtk_widget_show(submenuitem);	

		submenuitem = gtk_menu_item_new_with_label("Edit Accounts (requires restart)");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
      gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         eb_edit_accounts, NULL );
		gtk_widget_show(submenuitem);
		
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);
		gtk_widget_show(submenu);
		
		gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);
		gtk_widget_show(menuitem);

                menuitem = gtk_menu_item_new_with_label("Help");
                gtk_widget_show(menuitem);
				gtk_menu_item_right_justify(GTK_MENU_ITEM(menuitem));
                gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);                                

                submenu = gtk_menu_new();

		submenuitem = gtk_tearoff_menu_item_new();
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
		gtk_widget_show(submenuitem);
                
		submenuitem = gtk_menu_item_new_with_label("About");
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
                gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
		                         GTK_SIGNAL_FUNC(show_about), NULL);

                gtk_widget_show(submenuitem);

		gtk_container_add(GTK_CONTAINER(menubox), menu );
		gtk_widget_show(menu);
		gtk_box_pack_start(GTK_BOX(statusbox), menubox, FALSE, FALSE, 0 );
		gtk_widget_show(menubox);
		
		/*
		 * Do the main status window
		 */

		vbox = gtk_vbox_new(FALSE, 0);
		hbox = gtk_hbox_new(FALSE, 0);

		label = gtk_radio_button_new_with_label
		  (NULL, "Online");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 1);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				   GTK_SIGNAL_FUNC(status_show_callback),
				   (gpointer) 2);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(label),TRUE);
		gtk_widget_show(label);
		
		
		label = gtk_radio_button_new_with_label
		  (gtk_radio_button_group(GTK_RADIO_BUTTON(label)),
		   "Contacts");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 1);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				   GTK_SIGNAL_FUNC(status_show_callback),
				   (gpointer) 1);
		gtk_widget_show(label);


		label = gtk_radio_button_new_with_label
		  (gtk_radio_button_group(GTK_RADIO_BUTTON(label)),
		   "Accounts");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 1);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				   GTK_SIGNAL_FUNC(status_show_callback),
				   (gpointer) 0);
		gtk_widget_show(label);

		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		gtk_widget_show(hbox);

		eb_debug(DBG_CORE, "%d\n", g_list_length(accounts));
		MakeContactList();
		gtk_widget_show(contact_window);
		gtk_box_pack_start(GTK_BOX(vbox),contact_window,TRUE,TRUE,0);
		
		gtk_widget_show(vbox);

		gtk_box_pack_start(GTK_BOX(statusbox), vbox, TRUE, TRUE,0);

		/*
		 * Status Bar
		 */

		hbox = gtk_handle_box_new();
		gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(hbox), GTK_POS_LEFT);
		gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(hbox), GTK_POS_LEFT);
		status_message = gtk_label_new("Welcome To Everybuddy");
		status_bar = gtk_frame_new(NULL);
		gtk_frame_set_shadow_type(GTK_FRAME(status_bar), GTK_SHADOW_IN );
		gtk_widget_show(status_message);
		gtk_container_add(GTK_CONTAINER(status_bar), status_message);
		gtk_widget_show(status_bar);
		gtk_container_add(GTK_CONTAINER(hbox), status_bar);
		gtk_widget_show(hbox);
		
        gtk_box_pack_start(GTK_BOX(statusbox), hbox ,FALSE, FALSE,0);
        gtk_window_set_title(GTK_WINDOW(statuswindow), "EveryBuddy");
		eb_icon(statuswindow->window);
		gtk_widget_show(statusbox);
		
		gtk_container_add(GTK_CONTAINER(statuswindow), statusbox );
		
		gtk_signal_connect (GTK_OBJECT (statuswindow), "delete_event",
				    GTK_SIGNAL_FUNC (delete_event), NULL);
		
#ifdef USE_APPLET
		if (do_applet_show_on_startup)
		  {
		    gtk_widget_show( statuswindow);
		  }
#else
		gtk_widget_show( statuswindow);
#endif
		
		update_contact_list ();
}


