/*
 * Farsight Voice+Video library
 * Copyright (C) 2005 Rob Taylor, Philippe Khalaf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_MSNWEBCAM_H__
#define __FARSIGHT_MSNWEBCAM_H__

#include <glib.h>
#include <glib-object.h>

#include <farsight/farsight-protocol.h>

G_BEGIN_DECLS

#define NUM_IPS 3
#define NUM_PORTS 3

typedef enum {
    PRODUCER = 0,
    VIEWER
} MsnWebcamSessionType;

struct _MsnWebcamXmlInfo {
    gint recipientid, udp_recipientid, sessionid;
    gint16 tcpport, tcplocalport, tcpexternalport;
    gchar *tcpaddress1, *tcpaddress2, *tcpaddress3;
//    gint16 udplocalport, udpexternalport;
//    gchar *udpexternalip, udpinternaladdress1;
//    gint16 a1_port, b1_port, b2_port, b3_port;
//    gboolean symmetricallocation;
//    gint symetricallocationincrement;
};

/* TYPE MACROS */
#define FARSIGHT_TYPE_MSNWEBCAM \
  (farsight_msnwebcam_get_type())
#define FARSIGHT_MSNWEBCAM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_MSNWEBCAM, FarsightMsnWebcam))
#define FARSIGHT_MSNWEBCAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_MSNWEBCAM, FarsightMsnWebcamClass))
#define FARSIGHT_IS_MSNWEBCAM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_MSNWEBCAM))
#define FARSIGHT_IS_MSNWEBCAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_MSNWEBCAM))
#define FARSIGHT_MSNWEBCAM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_MSNWEBCAM, FarsightMsnWebcamClass))

typedef struct _MsnWebcamXmlInfo       MsnWebcamXmlInfo;
typedef struct _FarsightMsnWebcam      FarsightMsnWebcam;
typedef struct _FarsightMsnWebcamClass FarsightMsnWebcamClass;

struct _FarsightMsnWebcamClass {
    FarsightProtocolClass parent_class;
};

struct _FarsightMsnWebcam {
    FarsightProtocol parent;

    MsnWebcamSessionType session_type;
    gchar *localxml, *remotexml;
    MsnWebcamXmlInfo localinfo, remoteinfo;
    GArray *fdlist;
    guint connect_watch;
    GIOChannel *connection;
};

GType farsight_msnwebcam_get_type   (void);

G_END_DECLS

#endif
