/*
 * Farsight Voice+Video library test suite
 * Copyright 2006 INdT
 *  @author: Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <gst/gst.h>
#include <farsight/farsight-session.h>
#include <farsight/farsight-stream.h>

int main(int argc, char **argv)
{
    GMainLoop *mainloop = NULL;
    FarsightSession *session;
    guint i;
    
    gst_init (&argc, &argv);

    mainloop = g_main_loop_new (NULL, FALSE);

    session = farsight_session_factory_make ("rtp");
    for (i = 0; i < 100; ++i) {
      FarsightStream *stream = farsight_session_create_stream (session, FARSIGHT_MEDIA_TYPE_AUDIO, FARSIGHT_STREAM_DIRECTION_BOTH);
      gst_object_unref (stream);
    }
    farsight_session_destroy (session);

    session = farsight_session_factory_make ("rtp");
    for (i = 0; i < 100; ++i) {
      FarsightStream *stream = farsight_session_create_stream (session, FARSIGHT_MEDIA_TYPE_AUDIO, FARSIGHT_STREAM_DIRECTION_BOTH);
      gst_object_unref (stream);
    }
    farsight_session_destroy (session);

    return 0;
}
