/* $Id: StackTrace.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * Helper to obtain the current stack trace. Should not be used in the actual
 * compiler (only there for debugging).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __STACK_TRACKE_HPP_DEFINED
#define __STACK_TRACKE_HPP_DEFINED

#include <iostream>
#include <list>
#include <map>

namespace ast {
//! Helper to obtain the current stack trace.
/** This class can be used to obtain the current (c++) stack trace.
 *  It should not be used for anything in the compiler, apart from casual
 *  debugging.
 *
 *  To use this class, fauhdlc must be compiled with 
 *  -fno-omit-frame-pointers (otherwise g++ seems to omit frame pointers)
 *  and 
 *  -rdynamic (to tell the linker to store all symbols in the dynamic symbol
 *             table; otherwise name resolution will utterly fail).
 */
class StackTrace {
public:
	//! obtain the current stack trace.
	/** @return instance filled with the current stack trace.
	 */
	static StackTrace *getStackTrace(void);

	/** actual stack trace (symbol names) */
	std::list<std::string> stackTrace;

	//! put the stack trace to a stream.
	void put(std::ostream &stream) const;
private:
	//! dummy c'tor. use getStackTrace instead.
	StackTrace() {}

	//! resolve a symbol to the demangled entry.
	/** @param sym name of mangled symbol
	 *  @return name of demangled symbol (or sym in case demangling
	 *          doesn't succeed
	 */
	static std::string resolveSym(std::string sym);

	static std::map<std::string, std::string> mangleMap;
};

/** overloaded operator to conveniently output a StackTrace
 * @param stream stream to which a location should get written to.
 * @param st StackTrace instance to write to the stream.
 * @return modified stream
 */
std::ostream&
operator <<(std::ostream &stream, const StackTrace &st);

}; /* namespace ast */

#endif /* __STACK_TRACKE_HPP_DEFINED */
