/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __BUILDER_COMPILER__
#define __BUILDER_COMPILER__

FeriteBkRequest *__builder_create_request( FeriteOp *op, int type );
void __builder_destroy_request( FeriteBkRequest *ptr );
void __builder_delete_request_stack( FeriteStack *stack );
void __builder_clean_compiler();
FeriteScript *builder_script_compile( char *filename );
FeriteScript *__builder_compile_string( char *str );
void __builder_do_load_module( char *name );
void __builder_do_load_script( char *name );
void __builder_do_function_header( char *name, int is_static );
void __builder_do_function_start();
void __builder_do_function_footer();
void __builder_do_class_header( char *name, char *extends );
void __builder_do_class_footer();
void __builder_do_namespace_header( char *name );
void __builder_do_namespace_footer();
void __builder_do_add_variable_to_paramlist( char *name, char *type );
void __builder_do_header_c( char *header );
void __builder_do_module_init_c( char *foo );
void __builder_do_module_deinit_c( char *bar );
void __builder_do_add_variable( char *name, char *type, int is_global, int is_final, int is_static );

#endif
