/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  file_File.c */
/* class: File */

#include <ferite.h>       /* we need this without a doubt */
#include "file_header.h"  /* this is the module header */

FE_NS_FUNCTION( file_File_write )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, str, &super, &self );

   { /* Main function body. */
 
	  size_t ret=0;
	  int len= strlen(str);
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)ret );
	  }
	  
	  errno=0;
	  ret= fwrite( str, sizeof( char ), len, FileObj->fp );
	  fflush(FileObj->fp);
	  if( ret<len )
	  {
		 FileObj->err=-1;
	  }
	  else
	    FileObj->err=0;
	  ffree( str );
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_lockEX )
{
   double NB;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &NB, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  ret= flock( FileObj->fd, LOCK_EX|(NB?LOCK_NB:0) );
	  if(ret<0L)
	    FileObj->err=errno;
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_flush )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  ret=fflush( FileObj->fp );
	  if(!ret)
	    FileObj->err=errno;
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_lastErrno )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_tmpfile )
{
   double invisible;
   char *mask = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &invisible, mask, &super, &self );

   { /* Main function body. */
 	
	  char *tmp;
	  int oldmask;
	  
	  FileRecycle( FileObj );
	  FileObj->err=errno=0;
	  /*  tempnam() is depreciated, but nothing else turns my crank..  */
	  tmp=tempnam( 0, "ferite" );
	  if(!tmp)
	  {
		 FileObj->err=errno;
		 ffree( mask );
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  oldmask=FileUmasking( mask, 0 );
	  ffree( mask );
	  FileObj->err=errno=0;
	  FileObj->fp= fopen(tmp, "w+");
	  FileObj->err=errno;
	  umask(oldmask);
	  
	  if( FileObj->fp==NULL )
	  {
		 if(tmp) free(tmp);
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  /*  Users can specify immediate unlinking to insure later cleanup;  */
	  if((long)invisible)	unlink(tmp);
	  
	  /*  Set up the rest of the object..  */
	  FileObj->pathspec= fstrdup(tmp);
	  free(tmp);
	  FileObj->modes=	   fstrdup("w+");
	  if(!FileObj->pathspec || !FileObj->modes)
	  {
		 FileRecycle( FileObj );
		 FileObj->err=ENOMEM;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  FileObj->fd= fileno( FileObj->fp );
	  FileObj->err=	0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_writeln )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, str, &super, &self );

   { /* Main function body. */
 
	  int ret=-1;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)ret );
	  }
	  
	  errno=0;
	  ret=fputs(str, FileObj->fp);
	  fputs("\n", FileObj->fp);
	  if(ret<0L)
	  {
		 FileObj->err=-1;
	  }
	  else
	    FileObj->err=0;
	  ffree( str );
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_eof )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }

	  errno=0;
	  ret= feof(FileObj->fp);
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_close )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	  int ret;

	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  FileRecycle( FileObj );
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_remind )
{
   double modes;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &modes, &super, &self );

   { /* Main function body. */
 
	  char *buf="";
	  FeriteVariable *var;
	  
	  if( FileObj->pathspec )
	    buf= ((long)modes ? FileObj->modes : FileObj->pathspec);
	  var = fe_new_str( "File::remind", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_File )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   errno=0;
	   FileObj= fmalloc(sizeof(FileData));
	   if( FileObj == NULL )
	   {
		  FileObj->err=ENOMEM;
		  FileException("File()");
	   }
	   
	   /*  Initialize the allocated structure.  */
	   memset(FileObj, 0, sizeof(FileData) );
	   FileObj->fd= -1;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_ungetc )
{
   double c;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &c, &super, &self );

   { /* Main function body. */
 
	  int ret=-1;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)ret );
	  }

	  errno=0;
	  ret=ungetc( (int)c, FileObj->fp ); 
	  if(ret<0L)
	  {
		 FileObj->err=-1;
	  }
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_open )
{
   char *filename = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *modes = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   char *mask = fcalloc( strlen(VAS(params[2]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 5, filename, modes, mask, &super, &self );

   { /* Main function body. */
  
	  int oldmask;
	
	  FileRecycle( FileObj );
	  oldmask=FileUmasking( mask, 0 );
	  ffree( mask );
	  
	  errno=0;
	  FileObj->fp= fopen( filename, modes );
	  FileObj->err=errno;
	  umask(oldmask);
	  
	  if( FileObj->fp==NULL )
	  {
		 ffree( filename );
		 ffree( modes );
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  /*  Set up the rest of the object..  */
	  FileObj->pathspec= fstrdup(filename);
	  FileObj->modes=	   fstrdup(modes);
	  ffree( filename );
	  ffree( modes );
	  if(!FileObj->pathspec || !FileObj->modes)
	  {
		 FileRecycle( FileObj );
		 FileObj->err=ENOMEM;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  FileObj->fd= fileno( FileObj->fp );
	  FileObj->err=	0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_lineBuffered )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  FileObj->err=0;
	  /* setvbuf(FileObj->fp, (char *)NULL, _IOLBF, 0);  */
	  { 
		 long old= fcntl(FileObj->fd, F_GETFL);
		 old&= ~O_NONBLOCK;
		 fcntl(FileObj->fd, F_SETFL, old);
		 FileObj->nonB=0;
	  }
	  
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_seek )
{
   double offset;
   double whence;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &offset, &whence, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  ret=fseek( FileObj->fp, (long)offset, ((int)whence)%(SEEK_END+1) );
	  if(!ret)
	    FileObj->err=errno;
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_printf )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	  FeriteVariable *ptr;
	  int current=1, i=0;
	  long length=0L;
	  char *p, *rewrite;
	  
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  {
		 rewrite= FE_VIRGIN_STRING(strlen(str));
		 for(p=str; *p; p++)
		 { /* go thru and transliterate ferite symbolics to C */
			rewrite[0]=0;
			if( *p == '%' )
			{ int j;
			   rewrite[0]=*p; rewrite[1]=0;
			   p++;
			   for(j=1; *p && !strchr("%nscouxXeEgGaApdi", *p); j++, p++ )
				 rewrite[j]= *p;
			   rewrite[j]= *p;
			   rewrite[j+1]=0;
			   
			   switch( rewrite[j] )
			   {
				case '%':
				  length+=fprintf(FileObj->fp, "%%");
				  break;
				case 'n':
				  ptr = params[current++];
				  switch( ptr->type )
				  {
				   case F_VAR_LONG:
					 rewrite[j]='l';
					 strcat(rewrite, "d");
					 /* fprintf(stderr, "n:LONG=%s\n", rewrite); */
					 length+=fprintf(FileObj->fp, rewrite, VAI(ptr) );
					 break;
				   case F_VAR_DOUBLE:
					 rewrite[j]='f';
					 /* fprintf(stderr, "n:FLOAT=%s\n", rewrite); */
					 length+=fprintf(FileObj->fp, rewrite, VAF(ptr) );
					 break;
				   case F_VAR_STR:
					 rewrite[j]='d';
					 /* fprintf(stderr, "n:STRING=%s\n", rewrite); */
					 length+=fprintf(FileObj->fp, rewrite, *(VAS(ptr)) );
					 break;
				   case F_VAR_OBJ:
					 rewrite[j]='p';
					 /* fprintf(stderr, "n:OBJECT=%s\n", rewrite); */
					 length+=fprintf(FileObj->fp, rewrite,  VAO(ptr) );
					 break;
				   default:
				  }
				  break;
				case 's':
				  ptr = params[current++];
				  switch( ptr->type )
				  {
				   case F_VAR_OBJ:
					 fprintf(stderr, "s:OBJECT:=%s\n", rewrite);
					 length+=fprintf(FileObj->fp, rewrite, VAO(ptr)->name);
					 break;
				   case F_VAR_STR:
					 /* fprintf(stderr, "s:STRING:=%s\n", rewrite); */
					 length+=fprintf(FileObj->fp, rewrite, VAS(ptr) );
				  }
				  break;
				case 'c':
				  ptr = params[current++];
				  /* fprintf(stderr, "c:=%s\n", rewrite); */
				  length+=fprintf(FileObj->fp, rewrite,  VAI(ptr) );
				  break;
				case 'o':
				case 'u':
				case 'x':
				case 'X':
				  ptr = params[current++];
				  /* fprintf(stderr, "o..X:=%s\n", rewrite); */
				  length+=fprintf(FileObj->fp, rewrite,  (unsigned long)VAI(ptr) );
				  break;
				case 'e':
				case 'E':
				case 'g':
				case 'G':
				case 'a':
				case 'A':
				  ptr = params[current++];
				  /* fprintf(stderr, "e..A:=%s\n", rewrite); */
				  length+=fprintf(FileObj->fp, rewrite,  (double)VAF(ptr) );
				  break;
				case 'p':
				  ptr = params[current++];
				  /* fprintf(stderr, "p:=%s\n", rewrite); */
				  length+=fprintf(FileObj->fp, rewrite,  ptr );
				  break;
				default:
				  ptr = params[current++];
				  /* fprintf(stderr, "??:=%s\n", rewrite); */
				  length+=fprintf(FileObj->fp, rewrite,  ptr );
				  break;
			   }
			}
			else
			  length+=fprintf(FileObj->fp, "%c", *p);
		 }
		 ffree( rewrite );
	  }
	  ffree( str );
	  FE_RETURN_LONG( length );;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_lockUN )
{
   double NB;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &NB, &super, &self );

   { /* Main function body. */
  
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  ret= flock(FileObj->fd, LOCK_UN|(NB?LOCK_NB:0) );
	  if(ret<0L)
	    FileObj->err=errno;
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_fullyBuffered )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  FileObj->err=0;
	  setvbuf(FileObj->fp, (char *)NULL, _IOFBF, 0);
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_unbuffered )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }

	  errno=0;
	  FileObj->err=0;
	  /* setvbuf(FileObj->fp, (char *)NULL, _IONBF, 0);  */
	  { 
		 fcntl(FileObj->fd, F_SETFL, O_NONBLOCK);
		 FileObj->nonB=1;
	  }
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_clear )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  clearerr( FileObj->fp );
	  FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_truncate )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  fflush(FileObj->fp);
	  FileObj->err=errno=0;
	  if( ftruncate( FileObj->fd, (long)length ) )
	    FileObj->err=errno;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_read )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
 
	  char *buf;
	  FeriteVariable *var;
	  
	  buf= FE_VIRGIN_STRING((long)length);
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  { 
		 size_t got;
		 int	total=0, count=0, poorboy=2000;
		 do {
			FileObj->err=errno=0;
			got=read(FileObj->fd, buf+count, 1);
			if(got!=1)
			{
			   if(errno==EAGAIN && FileObj->nonB!=0)
			   {
				  poorboy--;
				  if(!poorboy)
				  {
					 FileObj->err=errno;
					 break;
				  }
				  else usleep(1); /*  sleep about 2 seconds+ MAX.  */
			   }
			   else
			   {
				  FileObj->err=errno;
				  break;
			   }
			}
			else total+=got;
			count++;
		 } while(errno==0 && total<length);
		 buf[count]=0;
	  }
	  var = fe_new_str( "File::read()", buf );
	  ffree( buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_lockSH )
{
   double NB;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &NB, &super, &self );

   { /* Main function body. */
  
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  ret= flock(FileObj->fd, LOCK_SH|(NB?LOCK_NB:0) );
	  if(ret<0L)
		FileObj->err=errno;
	  else
		FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_dataSync )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
#ifdef USING_DARWIN
      ferite_error(script,"Darwin does not have a fdatasync call. We need to figure out wtf to do about that.\n");
      FE_RETURN_VAR(NULL);
#else
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }	  
	  errno = 0;
	  fdatasync( fileno(FileObj->fp) );
	  FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
#endif
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_sync )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }	  
	  errno = 0;
	  fsync( fileno(FileObj->fp) );
	  FileObj->err=0;
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_getc )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FileException("getc()");
	  }
	  
	  errno=0;
	  ret=fgetc(FileObj->fp); 
	  if(ret<0L)
	  {
		 FileObj->err=-1;
	  }
	  else
	    FileObj->err=0;
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_strerror )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
   
	  char buf[1024];
	  FeriteVariable *var;
	  
	  switch(FileObj->err)
	  {
	   case -2:	sprintf(buf,"%d: shell fail|cmd fail|cmd immed exit", FileObj->err); break;
	   case -1:	sprintf(buf,"%d: Generic Error", FileObj->err); break;
	   case  0:	sprintf(buf,"%d: Success", FileObj->err); break;
	   default:	sprintf(buf,"%d: %s", FileObj->err, strerror(FileObj->err) );
		 break;
		 
	  }
	  var = fe_new_str( "File::strerror", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_chown )
{
   double owner;
   double group;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &owner, &group, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->pathspec )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  {
		 FileObj->err=errno=0;
		 if( fchown(FileObj->fd, (uid_t)owner, (gid_t)group) )
		   FileObj->err=errno;
	  }
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_unlink )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->pathspec )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  {
		 FileObj->err=errno=0;
		 if( unlink(FileObj->pathspec) )
		   FileObj->err=errno;
	  }
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_readln )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
 
	  char *buf;
	  FeriteVariable *var;
	  
	  buf= FE_VIRGIN_STRING((int)length);
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  {
		 if( !ferror( FileObj->fp) && !feof( FileObj->fp) )
		 {
			errno=0;
			if( !fgets(buf, (int)length, FileObj->fp) )
			{
			   FileObj->err= -1;
			}
			else
			  FileObj->err=0;
		 }
		 else
		   FileObj->err=-1;
	  }
	  
	  var = fe_new_str( "File::readln()", buf );
	  ffree( buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_position )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  long ret= -1L;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( ret );
	  }
	  
	  errno=0;
	  ret=ftell( FileObj->fp );
	  if(ret<0L)
		FileObj->err=errno;       
	  else
		FileObj->err=0;
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  errno=0;
	  if( FileObj != NULL )
	  {
		 if( FileObj->fp )
		 {
			fclose(FileObj->fp);
		 }
		 
		 /*  Release subsidiary struct members.  */
		 if( FileObj->pathspec != NULL )
		   ffree( FileObj->pathspec );
		 if( FileObj->modes != NULL )
		   ffree( FileObj->modes );
		 ffree( FileObj );
	  }
	  FileObj= NULL;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_chmod )
{
   char *mask = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, mask, &super, &self );

   { /* Main function body. */
 
	  long mode;
	  
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
	  }
	  else
	  {
		 if(*mask)
		 { 
			char *ow, *gr, *ot;
			ow=gr=ot=0;
			ow=mask;
			gr= (strlen(mask)>3 ? mask+3 : 0);
			ot= (strlen(mask)>6 ? mask+6 : 0);
			mode= perm2int( ow, gr, ot);
		 }
		 FileObj->err=errno=0;
		 if( fchmod(FileObj->fd, mode) )
		   FileObj->err=errno;
	  }
	  ffree( mask );
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_rewind )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  FileObj->err=0;
	  rewind( FileObj->fp );
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_File_error )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( !FileObj->fp )
	  {
		 FileObj->err=EBADF;
		 FE_RETURN_LONG( (long)FileObj->err );
	  }
	  
	  errno=0;
	  FileObj->err=ferror( FileObj->fp );
	  if( FileObj->err )
	    clearerr(FileObj->fp);	    
	  FE_RETURN_LONG( (long)FileObj->err );
   
   }
   FE_RETURN_VOID;
}

