/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  file_Poll.c */
/* class: Poll */

#include <ferite.h>       /* we need this without a doubt */
#include "file_header.h"  /* this is the module header */

FE_NS_FUNCTION( file_Poll_test )
{
   double dex;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &dex, &super, &self );

   { /* Main function body. */
 
	  FeriteVariable *var;
	  char buf[7]="";
	  int i=dex;
	  
	  buf[0]=0;
	  if( i>=0 && i<PollObj->active && PollObj->block[i].revents )
	  {
		 if(PollObj->block[i].revents&POLLIN)    strcat(buf, "r");
		 if(PollObj->block[i].revents&POLLOUT)   strcat(buf, "w");
		 if(PollObj->block[i].revents&POLLPRI)   strcat(buf, "u");
		 if(PollObj->block[i].revents&POLLERR)   strcat(buf, "e");
		 if(PollObj->block[i].revents&POLLHUP)   strcat(buf, "h");
		 if(PollObj->block[i].revents&POLLNVAL)  strcat(buf, "?");
	  }
	  var = fe_new_str( "Poll::test()", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_poll )
{
   double milliseconds;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &milliseconds, &super, &self );

   { /* Main function body. */
 
	  int ret;
	  
	  PollObj->err=errno=0;
	  ret=poll(PollObj->block, PollObj->active, (int)milliseconds);
	  PollObj->err=errno;
	  if(ret>0) /*  Only need to sort thru when there WERE new events. */
		poll_sort(PollObj);
	  FE_RETURN_LONG( (long)ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_empty )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  ffree(PollObj->block);
	  /*       REinitialize the allocated structure: nulls the block, too */
	  memset(PollObj, 0, sizeof(PollData) );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_strerror )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  char buf[1024];
	  FeriteVariable *var;
	  
	  switch(PollObj->err)
	  {
	   case -1:    sprintf(buf,"%d: Generic Error", PollObj->err); break;
	   case  0:    sprintf(buf,"%d: Success", PollObj->err); break;
	   default:    sprintf(buf,"%d: %s", PollObj->err, strerror(PollObj->err) );
		 break;
		 
	  }
	  var = fe_new_str( "Poll::strerror", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_Poll )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  errno=0;
	  PollObj= fmalloc( sizeof(PollData) );
	  if(!PollObj)
	  {
		 PollObj->err=ENOMEM;
		 PollException("Poll()");
	  }
	  
	  /*  Initialize the allocated structure. */
	  memset(PollObj, 0, sizeof(PollData) );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_add )
{
   char *how = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 1, how );

   { /* Main function body. */
 
	  /* see ~pfv/src/poll.c - PollData_add() - b is PollObj.. */
	  FeriteVariable *ptr;
	  int i, current=0;
	  void *vp;
	  long ret=0;
	  
	  for(current=1; params[current]; current++ )
	  {
		 PollObj->err=errno=0;
		 ptr = params[current];
		 if(!ptr)
		 {
			if(current==1)
			{
			   PollObj->err=EINVAL;
			   ret= -1;
			}
			break;
		 }
		 /* Objects must be BASED on File class - how to test?? */
		 if( !(ptr->type == F_VAR_OBJ &&
			   __ferite_object_is_sublass( VAO(ptr), "File")) )
		 {
			PollObj->err=EINVAL;
			ret= -1;
			break;
		 }
		 else
		 {   /* OK object get access to it's odata - HOW?? */
			FileData *p=  FileObj2(VAO(ptr));
			
			/* Do NOT send me a idle/dead object */
			if( p->fd<0 )
			{
			   PollObj->err=EINVAL;
			   ret= -1;
			   break;
			}
			
			/* Grab the object 'fd' and stuff it */
			if( !PollObj->block )
			{
			   fprintf(stderr, "Poll object was EMPTY\n");
			   PollObj->block=fmalloc( sizeof(pollfd_t)*POLLBLK );
			   if(!PollObj->block)
			   {
				  PollObj->err=ENOMEM;
				  ret=-1;
				  break;
			   }
			   PollObj->active=0;
			   PollObj->total=POLLBLK;
			}
			if( PollObj->active<PollObj->total )
			{ int j,i=poll_match(PollObj, p->fd);
			   PollObj->block[i].fd=p->fd;
			   if(i==PollObj->active) PollObj->active++;
			   for(PollObj->block[i].events=j=0; how[j] && j<2; j++)
				 PollObj->block[i].events|=
				 (how[j]=='r'
				  ? POLLIN
				  : (how[j]=='w'
					 ? POLLOUT
					 : 0) );
			}
			if( PollObj->active==PollObj->total )
			{
			   fprintf(stderr, "\tadding room..");
			   vp= frealloc(PollObj->block,
							sizeof(pollfd_t)*(PollObj->active+POLLBLK) );
			   if(vp)
			   {
				  fprintf(stderr, "\tOK..\n");
				  memset(&(PollObj->block[PollObj->active]), 0, sizeof(pollfd_t)*POLLBLK );
				  PollObj->block=vp;
				  PollObj->total+=POLLBLK;
			   }
			   else
			   {
				  fprintf(stderr, "\tFAIL..\n");
				  PollObj->err=ENOMEM;
				  ret= -1;
			   }
			}
		 }
	  }
	  ffree( how );
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Poll_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if(PollObj->block)
		ffree( PollObj->block );
	  ffree(PollObj);
   
   }
   FE_RETURN_VOID;
}

