/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  file_Stats.c */
/* class: Stats */

#include <ferite.h>       /* we need this without a doubt */
#include "file_header.h"  /* this is the module header */

FE_NS_FUNCTION( file_Stats_isSymlink )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
   
	   FeriteVariable *var;
	   char buf[2][4096];
	   char *rp;
	   char len;
	   
	   buf[0][0]=buf[1][0]=0;
	   if( StatObj->pathspec &&
		   S_ISLNK(StatObj->statbuf.st_mode) )
	   {
		  memset(buf[0], 0, 4096);
		  errno=0;
		  len= readlink(StatObj->pathspec, buf[0], sizeof(buf[0]));
		  /* fprintf(stderr,"readlink=[%s]=%d\n", buf[0], len);  */
		  if( len<=0 )
		  {
			 StatObj->err=errno;
		  }
		  else
		  {
			 errno=0;
			 rp=realpath(StatObj->pathspec, buf[1]);
			 StatObj->err=errno;
			 /* fprintf(stderr,"realpath=[%s]\n", buf[1]);  */
		  }
	   }
	   var = fe_new_str( "Stats::isSymlink()", buf[1] );
	   FE_RETURN_VAR( var );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_lastErrno )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_lastAccess )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_atime );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_getInode )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_ino );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isFIFO )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= S_ISFIFO(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_blocksize )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_blksize );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isChardev )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= S_ISCHR(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_remind )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 	
	   char *buf="";
	   FeriteVariable *var;
	   
	   if(StatObj->pathspec) buf=StatObj->pathspec;
	   var = fe_new_str( "Stats::remind", StatObj->pathspec );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_specialProperty )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 	
	   char buf[2];
	   FeriteVariable *var;
	   
	   buf[0]=buf[1]=0;
	   if(      S_ISLNK(StatObj->statbuf.st_mode)	)	*buf='l';
	   else if( S_ISDIR(StatObj->statbuf.st_mode)	)	*buf='d';
	   else if( S_ISREG(StatObj->statbuf.st_mode)	)	*buf='-';
	   else if( S_ISSOCK(StatObj->statbuf.st_mode)	)	*buf='s';
	   else if( S_ISFIFO(StatObj->statbuf.st_mode)	)	*buf='p';
	   else if( S_ISBLK(StatObj->statbuf.st_mode)	)	*buf='b';
	   else if( S_ISCHR(StatObj->statbuf.st_mode)	)	*buf='c';
	   else							*buf='?';
	   
	   var = fe_new_str( "Stats::specialProperty()", buf );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_open )
{
   char *pathspec = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, pathspec, &super, &self );

   { /* Main function body. */
  
	   int ret;
	   
	   if(StatObj->pathspec)
		 ffree(StatObj->pathspec);
	   StatObj->pathspec=fstrdup(pathspec);
	   ffree( pathspec );
	   memset(&(StatObj->statbuf), 0, sizeof(StatObj->statbuf) );

	   if(!StatObj->pathspec)
	   {
		  StatObj->err=ENOMEM;
		  FE_RETURN_LONG( (long)StatObj->err );
	   }

	   StatObj->err=errno=0;
	   ret=lstat(StatObj->pathspec, &(StatObj->statbuf));
	   StatObj->err=errno;
	   if(ret)
	   {
		  ffree(StatObj->pathspec);
		  StatObj->pathspec=0;
	   }
	   else StatObj->err=0;
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isSocket )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret =  S_ISSOCK(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_touch )
{
   double when;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &when, &super, &self );

   { /* Main function body. */
 
	   struct utimbuf utam;
	   
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  if(!when)
			utam.actime=utam.modtime=time(0);
		  else
			utam.actime=utam.modtime=when;
		  StatObj->err=errno=0;
		  if( utime(StatObj->pathspec, &utam) )
			StatObj->err=errno;
	   }
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isSUID )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= AM_SUID(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_makeSymlink )
{
   char *to = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, to, &super, &self );

   { /* Main function body. */
 
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   { 
		  char	thisAbsolutepath[8096], thisFilename[1025];
		  
		  if(abspath(thisAbsolutepath, thisFilename, StatObj->pathspec))
		  {
			 /* strcat(thisAbsolutepath, thisFilename);  */
			 StatObj->err=errno=0;
			 if( symlink(thisAbsolutepath, to) )
			   StatObj->err=errno;
		  }
		  else
			StatObj->err=ENOENT;
	   }
	   ffree( to );
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_lastWrite )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_mtime );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isSGID )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= AM_SGID(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_Stats )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   StatObj= fmalloc(sizeof(StatData));
	   if(!StatObj)
	   {
		  StatObj->err=ENOMEM;
		  StatException("Stats()");
	   }
	   
	   /*  Initialize the allocated structure.  */
	   StatObj->pathspec= 0;
	   StatObj->err= 0;
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_truncate )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
 
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  StatObj->err=errno=0;
		  if( truncate(StatObj->pathspec, (off_t)length) )
			StatObj->err=errno;
	   }
	   FE_RETURN_LONG( (long)StatObj->err );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_delete )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  StatObj->err=errno=0;
		  if( unlink(StatObj->pathspec) )
			StatObj->err=errno;
		  else
		  {
			 ffree(StatObj->pathspec); StatObj->pathspec=0;
			 memset(&(StatObj->statbuf), 0, sizeof(StatObj->statbuf) );
	    }
	   }
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_ownerPerms )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
   
	   char buf[4];
	   FeriteVariable *var;
	   
	   buf[3]=0;
	   buf[0]= ((StatObj->statbuf.st_mode&S_IRUSR)==S_IRUSR) ? 'r' : '-';
	   buf[1]= ((StatObj->statbuf.st_mode&S_IWUSR)==S_IWUSR) ? 'w' : '-';
	   buf[2]= ((StatObj->statbuf.st_mode&S_IXUSR)==S_IXUSR) ? 'x' : '-';
	   if( AM_SUID(StatObj->statbuf.st_mode) )
		 buf[2]= (buf[2]=='x' ? 's' : 'S');
	   var = fe_new_str( "Stats::ownerPerms()", buf );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_filesize )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_size );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_ownerUID )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_uid );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isBlockdev )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= S_ISBLK(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_blocks )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_blocks );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_ownerGID )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_gid );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isSticky )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= AM_SVTX(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_strerror )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
   
	   char buf[1024];
	   FeriteVariable *var;
	   
	   switch(StatObj->err)
	   {
	    case -1:	sprintf(buf,"%d: Generic Error", StatObj->err); break;
	    case  0:	sprintf(buf,"%d: Success", StatObj->err); break;
	    default:	sprintf(buf,"%d: %s", StatObj->err, strerror(StatObj->err) );
		  break;
		  
	   }
	   var = fe_new_str( "Stats::strerror", buf );
	   FE_RETURN_VAR( var );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_chown )
{
   double o;
   double g;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &o, &g, &super, &self );

   { /* Main function body. */
 
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  StatObj->err=errno=0;
		  if( chown(StatObj->pathspec, (uid_t)o, (gid_t)g) )
			StatObj->err=errno;
	   }
	   FE_RETURN_LONG( (long)StatObj->err );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_makeHardlink )
{
   char *to = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, to, &super, &self );

   { /* Main function body. */
  
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  StatObj->err=errno=0;
		  if( link(StatObj->pathspec, to) )
			StatObj->err=errno;
	   }
	   ffree( to );
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_hardlinks )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_nlink );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_otherPerms )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   char buf[4];
	   FeriteVariable *var;
	   
	   buf[3]=0;
	   buf[0]= ((StatObj->statbuf.st_mode&S_IROTH)==S_IROTH) ? 'r' : '-';
	   buf[1]= ((StatObj->statbuf.st_mode&S_IWOTH)==S_IWOTH) ? 'w' : '-';
	   buf[2]= ((StatObj->statbuf.st_mode&S_IXOTH)==S_IXOTH) ? 'x' : '-';
	   if( AM_SVTX(StatObj->statbuf.st_mode) )
		 buf[2]= (buf[2]=='x' ? 't' : 'T');
	   var = fe_new_str( "Stats::otherPerms()", buf );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isDir )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= S_ISDIR(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   if(StatObj->pathspec) ffree(StatObj->pathspec);
	   ffree(StatObj);
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_chmod )
{
   char *mask = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, mask, &super, &self );

   { /* Main function body. */
 	
	   long mode;
	   
	   if( !StatObj->pathspec )
	   {
		  StatObj->err=EBADF;
	   }
	   else
	   {
		  if(*mask)
		  { 
			 char *ow, *gr, *ot;
			 ow=gr=ot=0;
			 ow=mask;
			 gr= (strlen(mask)>3 ? mask+3 : 0);
			 ot= (strlen(mask)>6 ? mask+6 : 0);
			 mode= perm2int( ow, gr, ot);
		  }
		  StatObj->err=errno=0;
		  if( chmod(StatObj->pathspec, mode) )
			StatObj->err=errno;
	   }
	   ffree( mask );
	   FE_RETURN_LONG( (long)StatObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_lastChange )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)StatObj->statbuf.st_ctime );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_isFile )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   long ret= S_ISREG(StatObj->statbuf.st_mode);
	   FE_RETURN_LONG( ret );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Stats_groupPerms )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   char buf[4];
	   FeriteVariable *var;
	   
	   buf[3]=0;
	   buf[0]= ((StatObj->statbuf.st_mode&S_IRGRP)==S_IRGRP) ? 'r' : '-';
	   buf[1]= ((StatObj->statbuf.st_mode&S_IWGRP)==S_IWGRP) ? 'w' : '-';
	   buf[2]= ((StatObj->statbuf.st_mode&S_IXGRP)==S_IXGRP) ? 'x' : '-';
	   if( AM_SGID(StatObj->statbuf.st_mode) )
		 buf[2]= (buf[2]=='x' ? 's' : 'S');
	   var = fe_new_str( "Stats::groupPerms()", buf );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

