/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  speech_Talk.c */
/* class: Talk */

#include <ferite.h>       /* we need this without a doubt */
#include "speech_header.h"  /* this is the module header */

FE_NS_FUNCTION( speech_Talk_getVoice )
{
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 0 );

   { /* Main function body. */
 
      int cp = ferite_get_parameter_count(params);
      FeriteVariable *v;
      SInt16 num;
      VoiceSpec *voice = fmalloc(sizeof(VoiceSpec));
      VoiceDescription *desc = fmalloc(sizeof(VoiceDescription));
      int finished = 0;
      if( cp > 3 ) {
         ffree(voice); ffree(desc);
         ferite_error(script,"Invalid parameters.");
         return;
      }
      CountVoices(&num);
      v = params[0];
      if(v->type == F_VAR_NUM) {
         if(VAI(v) > num || num < 0) {
            ffree(voice); ffree(desc);
            ferite_error(script, "Invalid voice number.");
            return;
         } else {
            GetIndVoice(VAI(v),voice);
            GetVoiceDescription(voice,desc,(SInt32)sizeof(VoiceDescription));
         }
      } else if(v->type == F_VAR_STR) {
         int i;
         for(i = 1; i <= num; i++) {
            VoiceSpec *tv = fmalloc(sizeof(VoiceSpec));
            VoiceDescription *td = fmalloc(sizeof(VoiceDescription));
            GetIndVoice(i,tv);
            GetVoiceDescription(tv,td,(SInt32)sizeof(VoiceDescription));
            if(!strcmp(desc->name+1,VAS(v))) {
               ffree(voice);
               voice = tv;
               ffree(desc);
               desc = td;
               finished = 1;
            }
         }
         if(!finished) {
            ffree(voice);
            ffree(desc);
            ferite_error(script,"Inknown voice.");
            return;
         }
      } else {
         ffree(voice); ffree(desc);
         ferite_error(script,"Invalid parameters");
      }
      /* if here, the desc is good. */
      {
#define QAS(l,v) __ferite_uarray_add(script,VAUA(ret), fe_new_str(l,v),l,-1);
#define QAI(l,v) __ferite_uarray_add(script,VAUA(ret), fe_new_dbl(l,v),l,-1);
         FeriteVariable *ret = fe_new_array("Talk::getVoice",num);
         QAI("length",desc->length);
         QAI("version",desc->version);
         QAS("name",desc->name+1);
         QAS("comment",desc->comment+1);
         if(desc->gender == kNeuter) {
            QAS("gender","neuter");
         } else if(desc->gender == kMale) {
            QAS("gender","male");
         } else {
            QAS("gender","female");
         }
         QAI("age",desc->age);
         FE_RETURN_VAR(ret);
      }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( speech_Talk_say )
{
   char *what = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, what, &super, &self );

   { /* Main function body. */
 
      if(TalkObj->channel != NULL) {
         DisposeSpeechChannel(*(TalkObj->channel));
      }
      NewSpeechChannel(TalkObj->voice,TalkObj->channel);
      SpeakText(*(TalkObj->channel),what,strlen(what) * sizeof(char));
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( speech_Talk_busy )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      FE_RETURN_LONG(SpeechBusy());
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( speech_Talk_setVoice )
{
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 0 );

   { /* Main function body. */
 
      int cp = ferite_get_parameter_count(params);
      FeriteVariable *v;
      SInt16 num;
      int finish = 0;
      if(cp > 3) {
         ferite_error(script,"Invalid parameters.");
         return;
      }
      CountVoices(&num);
      v = params[0];
      if(v->type == F_VAR_NUM) {
         if(VAI(v) > num || num < 0) {
            ferite_error(script,"Invalid voice number.");
         } else {
            TalkObj->voice = fmalloc(sizeof(VoiceSpec));
            GetIndVoice(VAI(v),TalkObj->voice);
         }
      } else if(v->type = F_VAR_STR) {
         int i;
         for(i = 1; i <= num; i++) {
            VoiceDescription *desc = fmalloc(sizeof(VoiceDescription));
            VoiceSpec *voice = fmalloc(sizeof(VoiceDescription));
            GetIndVoice(i,voice);
            GetVoiceDescription(voice,desc,(SInt32)sizeof(VoiceDescription));
            if(!strcmp(desc->name+1,VAS(v))) {
               finish = 1;
               ffree(desc);
               if(TalkObj->voice != NULL) {
                  ffree(TalkObj->voice);
               }
               TalkObj->voice = voice;
               break;
            }
            ffree(desc);
         }
         if(!finish) {
            ferite_error(script,"Unknown voice '%s'\n",VAS(v));
            TalkObj->voice = NULL;
            return;
         }
      } else {
         ferite_error(script,"Invalid parameters.");
      }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( speech_Talk_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      if(TalkObj->channel != NULL) {
         DisposeSpeechChannel(*(TalkObj->channel));
         ffree(TalkObj->channel);
      }
      if(TalkObj->voice != NULL) {
         ffree(TalkObj->voice);
      }
      ffree(TalkObj);
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( speech_Talk_Talk )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      TalkObj = fmalloc(sizeof(TalkHolder));
      TalkObj->channel = fmalloc(sizeof(SpeechChannel));
      TalkObj->voice = NULL;
   
   }
   FE_RETURN_VOID;
}

