/* This file has been automatically generated by builder part of the ferite distribution */
#ifndef __system_HEADER__
#define __system_HEADER__

    /* Start user defined header code */

#include "../../config.h" /* so we can tell if we are within Solaris */
#ifdef USING_DARWIN
# include <crt_externs.h>
#else
   extern char **environ;
#endif
   
#include <errno.h>	/* pfv: */
#include <string.h>	/*  char *strerror(int errnum); */
#include <sys/types.h>	/* pfv: */
#include <sys/wait.h>	/*  pid_t waitpid(pid_t pid, int *status, int options); */
#include <signal.h>	/*  int kill(pid_t pid, int sig); */
#include <pwd.h>	/*  struct passwd *getpwuid(uid_t uid); */
#include <grp.h>	/*  struct group *getgrent(void); */
#include <unistd.h>	/*  pid_t getpid(void); pid_t getppid(void); */
#include "utility.h"	/*  store some data beyond user grasp - internal-use. */

#define SET_FE_NS_LONG(s,n) \
    { FeriteNamespaceBucket *nsb = \
	    __ferite_find_namespace( script,script->mainns, (s), FENS_VAR ); \
	if( nsb ) \
	{ FeriteVariable *var; \
	    var= (FeriteVariable*)(nsb->data); \
	    var->data.lval=(n); \
	} \
    }
#define SET_FE_NS_STRING(s,ss) \
    { FeriteNamespaceBucket *nsb = \
	    __ferite_find_namespace( script,script->mainns, (s), FENS_VAR ); \
	if( nsb ) \
	{ FeriteVariable *var; \
	    var= (FeriteVariable*)(nsb->data); \
	   if( VAS(var) != NULL ) { ffree( VAS(var) ); } \
	   VAS(var) = (ss); \
	} \
    }

/* pfv: Following 3 reorganized per yak with Chris.. */
#ifndef FE_ALLOC_STRING
#define FE_ALLOC_STRING(l)      fmalloc((l))
#endif /*  pfv.20011117 */

#ifndef FE_EMPTY_STRING
#define FE_EMPTY_STRING(s,l)    (memset( (s), '\0', (l) ))
#endif /*  pfv.20011118 */

#ifndef FE_VIRGIN_STRING
#define FE_VIRGIN_STRING(l)     FE_EMPTY_STRING(FE_ALLOC_STRING(l), (l))
#endif /*  pfv.20011118 */

#define SUGID_FAIL(s, ss) \
    __ferite_raise_script_error(script, \
    EPERM, "ERROR: User::%s(%s): %d (%s)\n", (s), (ss),\
    EPERM, strerror(EPERM) );

    /* End user defined header code */
FE_NS_FUNCTION( system_System_exec );
FE_NS_FUNCTION( system_System_gc );
FE_NS_FUNCTION( system_System_getcwd );
FE_NS_FUNCTION( system_System_signalpid );
FE_NS_FUNCTION( system_System_statusStopped );
FE_NS_FUNCTION( system_System_statusSignaled );
FE_NS_FUNCTION( system_System_statusExited );
FE_NS_FUNCTION( system_System_waitpid );
FE_NS_FUNCTION( system_System_scriptName );
FE_NS_FUNCTION( system_System_warning );
FE_NS_FUNCTION( system_System_fork );
FE_NS_FUNCTION( system_System_system );
FE_NS_FUNCTION( system_System_usleep );
FE_NS_FUNCTION( system_System_chdir );
FE_NS_FUNCTION( system_System_strerror );
FE_NS_FUNCTION( system_System_error );
FE_NS_FUNCTION( system_System_wait );
FE_NS_FUNCTION( system_System_exit );
FE_NS_FUNCTION( system_User_nameUid );
FE_NS_FUNCTION( system_User_nameGid );
FE_NS_FUNCTION( system_User_logid );
FE_NS_FUNCTION( system_User_tgid );
FE_NS_FUNCTION( system_User_tuid );
FE_NS_FUNCTION( system_User_egid );
FE_NS_FUNCTION( system_User_euid );
FE_NS_FUNCTION( system_User_rgid );
FE_NS_FUNCTION( system_User_ruid );
FE_NS_FUNCTION( system_User_home );
FE_NS_FUNCTION( system_User_name );
FE_NS_FUNCTION( system_User_uidOf );
FE_NS_FUNCTION( system_User_gidOf );
FE_NS_FUNCTION( system_User_shell );
FE_NS_FUNCTION( system_User_setEffectiveUser );
FE_NS_FUNCTION( system_User_groups );
FE_NS_FUNCTION( system_Environment_read );
FE_NS_FUNCTION( system_Environment_write );
FE_NS_FUNCTION( system_Environment_del );
FE_NS_FUNCTION( system_Environment_toArray );

#endif /* __system_HEADER__ */
