/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <ferite.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include "xml_header.h"
#include "sax_handlers.h"

xmlParserInputPtr sax_resolveEntity(void *ctxt, const xmlChar *publicId, const xmlChar *systemId)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_internalSubset(void *ctxt, const xmlChar *name, const xmlChar *ExternalID, const xmlChar *SystemID)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_externalSubset (void *ctxt, const xmlChar *name, const xmlChar *ExternalID, const xmlChar *SystemID)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

xmlEntityPtr sax_getEntity (void *ctxt, const xmlChar *name)
{ 
   xmlEntityPtr en = xmlGetPredefinedEntity(name);
   return en;
}

xmlEntityPtr sax_getParameterEntity (void *ctxt, const xmlChar *name)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_entityDecl (void *ctxt, const xmlChar *name, int type, const xmlChar *publicId, const xmlChar *systemId, xmlChar *content)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_notationDecl(void *ctxt, const xmlChar *name, const xmlChar *publicId, const xmlChar *systemId)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_attributeDecl(void *ctxt, const xmlChar *elem, const xmlChar *name, int type, int def, const xmlChar *defaultValue, xmlEnumerationPtr tree)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_elementDecl(void *ctxt, const xmlChar *name, int type, xmlElementContentPtr content)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_unparsedEntityDecl(void *ctxt, const xmlChar *name, const xmlChar *publicId, const xmlChar *systemId, const xmlChar *notationName)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_setDocumentLocator (void *ctxt, xmlSAXLocatorPtr loc)
{ 
/*   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );*/
}

void sax_startDocument( void *ctxt )
{ 
   SaxRecord             *sr = ctxt;
   FeriteObject          *obj = sr->obj;
   FeriteScript          *script = sr->script;
   FeriteFunction        *function = NULL;
   FeriteVariable        **params = NULL;
   
   if( (function = __ferite_hash_get( script, obj->functions, "startDocument" )) != NULL ){
	  params = __ferite_create_parameter_list_from_data( script, "oo", obj, obj );
      __ferite_variable_destroy( script, __ferite_call_function( sr->script, function, params ) );
      __ferite_delete_parameter_list( script, params );
   }
}

void sax_endDocument( void *ctxt )
{ 
   SaxRecord             *sr = ctxt;
   FeriteObject          *obj = sr->obj;
   FeriteScript          *script = sr->script;
   FeriteFunction        *function = NULL;
   FeriteVariable        **params = NULL;
   
   if( (function = __ferite_hash_get( script, obj->functions, "endDocument" )) != NULL ){
	  params = __ferite_create_parameter_list_from_data( script, "oo", obj, obj );
      __ferite_variable_destroy( script, __ferite_call_function( sr->script, function, params ) );
      __ferite_delete_parameter_list( script, params );
   }
}

void sax_startElement (void *ctxt, const xmlChar *name, const xmlChar **atts)
{ 
   FeriteVariable        *array;
   int i = 0;
   SaxRecord             *sr = ctxt;
   FeriteObject          *obj = sr->obj;
   FeriteScript          *script = sr->script;
   FeriteFunction        *function = NULL;
   FeriteVariable        **params = NULL, *var = NULL;
   
   if( (function = __ferite_hash_get( script, obj->functions, "startElement" )) != NULL ){
      array = __ferite_create_uarray_variable( "retval-string_split", 10 );
      if( atts != NULL ){		 
	 for( i = 0; atts[i] != NULL; i++ ){
	    var = fe_new_str( (char *)atts[i], (atts[i++] == NULL ? "" : (char *)atts[i]) );
	    __ferite_uarray_add( script, VAUA( array ), var, (char *)atts[i-1], -1 );
	 }		 
      }
      params = __ferite_create_parameter_list_from_data( script, "saoo", name, VAUA(array), obj, obj );
      __ferite_variable_destroy( script, __ferite_call_function( sr->script, function, params ) );
      __ferite_delete_parameter_list( script, params );
      __ferite_variable_destroy( script, array );
   }
}

void sax_endElement (void *ctxt, const xmlChar *name)
{ 
   SaxRecord             *sr = ctxt;
   FeriteObject          *obj = sr->obj;
   FeriteScript          *script = sr->script;
   FeriteFunction        *function = NULL;
   FeriteVariable        **params = NULL;
   
   if( (function = __ferite_hash_get( script, obj->functions, "endElement" )) != NULL ){
      params = __ferite_create_parameter_list_from_data( script, "soo", name, obj, obj );
      __ferite_variable_destroy( script, __ferite_call_function( sr->script, function, params ) );
      __ferite_delete_parameter_list( script, params );
   }
}

void sax_attribute (void *ctxt, const xmlChar *name, const xmlChar *value)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_reference (void *ctxt, const xmlChar *name)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_characters (void *ctxt, const xmlChar *ch, int len)
{ 
   SaxRecord             *sr = ctxt;
   FeriteObject          *obj = sr->obj;
   FeriteScript          *script = sr->script;
   FeriteFunction        *function = NULL;
   FeriteVariable        **params = NULL;
   char                  *buf = memset( fmalloc( len + 1 ), '\0', len + 1 );

   if( (function = __ferite_hash_get( script, obj->functions, "characters" )) != NULL ){
      strncpy( buf, ch, len );
      /*	  printf( "BUF>>>%s<<<BUF\n", buf );*/
      params = __ferite_create_parameter_list_from_data( script, "soo", buf, obj, obj );
      __ferite_variable_destroy( script, __ferite_call_function( sr->script, function, params ) );
      __ferite_delete_parameter_list( script, params );
   }
   ffree( buf );
}

void sax_ignorableWhitespace (void *ctxt, const xmlChar *ch, int len)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_processingInstruction (void *ctxt, const xmlChar *target, const xmlChar *data)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_comment (void *ctxt, const xmlChar *value)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_cdataBlock (void *ctxt, const xmlChar *value, int len)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_warning (void *ctxt, const char *msg, ...)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_error (void *ctxt, const char *msg, ...)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

void sax_fatalError (void *ctxt, const char *msg, ...)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_isStandalone (void *ctxt)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_hasInternalSubset (void *ctxt)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_hasExternalSubset (void *ctxt)
{ 
   printf( "In Function %s - %s\n", __FUNCTION__, ((SaxRecord*)ctxt)->obj->name );
}

int sax_xmlParseFile( xmlSAXHandlerPtr sax, SaxRecord *obj, char *filename )
{
   int ret = 0;
   xmlParserCtxtPtr ctxt = NULL;

   ctxt = xmlCreateFileParserCtxt( filename );
   if( ctxt == NULL )
   {
      ferite_error( obj->script, "Unable to find file %s\n", filename );
      return 0;
   }
   ctxt->sax = sax;
   ctxt->userData = obj;

   xmlParseDocument( ctxt );

   if( ctxt->wellFormed )
     ret = 1;
   else
     ret = 0;

   if( ctxt->sax != NULL )
     ctxt->sax = NULL;
   
   xmlFreeParserCtxt( ctxt );
   return ret;
}

int sax_xmlParseChunk( xmlSAXHandlerPtr sax, SaxRecord *obj, char *chunk )
{
   
}
