/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <ferite/freq.h>
#include <ferite/fstructs.h>

/*! This is only used within debug to check function call traces */
int                __ferite_call_level = 0;

/*! The global enviroment - holds the GC and other goodies*/
FeriteEnvironment *genv = NULL;

/*! A flag to say whether or not we should show debug output */
int                show_debug = 0;

/*! Should we hide memory use? */
int                hide_mem_use = 1;

/*! Generic function for memory management. Hides the actually memory manager */
void  (*__ferite_memory_init)(void);
/*! Generic function for memory management. Hides the actually memory manager */
void  (*__ferite_memory_deinit)(void);
/*! Generic function for memory management. Hides the actually memory manager */
void *(*__ferite_malloc)( size_t size, char *name, int line );
/*! Generic function for memory management. Hides the actually memory manager */
void *(*__ferite_calloc)( size_t size, size_t blk_size, char *name, int line );
/*! Generic function for memory management. Hides the actually memory manager */
void *(*__ferite_realloc)( void *ptr, size_t size );
/*! Generic function for memory management. Hides the actually memory manager */
void  (*__ferite_free)( void *ptr, char *file, int line );

/*! The ARGV for the scripts */
FeriteVariable *ARGV;
