/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "ferite.h"

FeriteStack *__ferite_create_stack( int size )
{
   FeriteStack *ptr;
   int i;
   
   FE_ENTER_FUNCTION;
   ptr = fmalloc( sizeof( FeriteStack ) );
   ptr->size = size;
   ptr->stack_ptr = 0;
   ptr->stack = fmalloc( sizeof( void * ) * size );
   for( i = 0; i < size; i++ ) /* clear the stack. make life easy */
      ptr->stack[i] = NULL;
   FE_LEAVE_FUNCTION( ptr );
}

void __ferite_stack_push( FeriteStack *stck, void *ptr )
{
   int i;
   
   FE_ENTER_FUNCTION;
   stck->stack_ptr++;
   if( stck->stack_ptr < stck->size )
     stck->stack[stck->stack_ptr] = ptr;
   else
   {
      FUD(("Resizing STACK\n"));
      /* stack aint big enough. make it bigger. */
      stck->size *= 2;
      stck->stack = frealloc( stck->stack, sizeof( void * ) * stck->size );
      for( i = stck->stack_ptr; i < stck->size; i++ )
	stck->stack[i] = NULL;
      stck->stack[stck->stack_ptr] = ptr;
   }
   FE_LEAVE_FUNCTION( NOWT );
}

void *__ferite_stack_pop( FeriteStack *stck )
{
   void *ptr = NULL;
   
   FE_ENTER_FUNCTION;
   ptr = stck->stack[stck->stack_ptr];
   stck->stack[stck->stack_ptr] = NULL;
   stck->stack_ptr--;
   if( stck->stack_ptr < 0 )
     stck->stack_ptr = 0;
   FE_LEAVE_FUNCTION( ptr );
}

void         __ferite_delete_stack( FeriteStack *stack )
{
   FE_ENTER_FUNCTION;
   if( stack )
   {
      ffree( stack->stack ); /* we dont need to free the stack items, it's the job of the push
			      * pullers to do that :)
			      */
      ffree( stack );
   }
   FE_LEAVE_FUNCTION( NOWT );
}

void *__ferite_stack_top( FeriteStack *stck )
{
   void *ptr = NULL;
   
   FE_ENTER_FUNCTION;
   ptr = stck->stack[stck->stack_ptr];
   FE_LEAVE_FUNCTION( ptr );   
}
