// This code conforms with the UFC specification version 1.4.1
// and was automatically generated by FFC version 0.9.3.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __RESTRICTEDELEMENT_H
#define __RESTRICTEDELEMENT_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class restrictedelement_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  restrictedelement_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1)))";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, -0.04123930, -0.02380952, 0.02898003, 0.02244783, 0.01296026, -0.03959426, -0.03346326, -0.02592053, -0.01496522, 0.03212473, 0.02833134, 0.02394436, 0.01854722, 0.01070824};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, 0.04123930, -0.02380952, 0.02898003, -0.02244783, 0.01296026, 0.03959426, -0.03346326, 0.02592053, -0.01496522, 0.03212473, -0.02833134, 0.02394436, -0.01854722, 0.01070824};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, 0.00000000, 0.04761905, 0.00000000, 0.00000000, 0.03888079, 0.00000000, 0.00000000, 0.00000000, 0.05986089, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.05354121};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.13196578, -0.02539683, 0.13910414, -0.07183307, 0.03110463, 0.06335081, 0.02677060, -0.06220926, 0.04788871, 0.00000000, 0.05666269, -0.08380525, 0.08346248, -0.05354121};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, 0.01099715, 0.00634921, 0.00000000, 0.18856181, -0.16329932, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.00000000, 0.00000000, 0.08380525, -0.13910414, 0.10708242};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.04398859, 0.12698413, 0.00000000, 0.03591653, 0.15552316, 0.00000000, 0.00000000, 0.10368211, -0.01197218, 0.00000000, 0.00000000, 0.00000000, 0.09273609, -0.10708242};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.13196578, -0.02539683, 0.13910414, 0.07183307, 0.03110463, -0.06335081, 0.02677060, 0.06220926, 0.04788871, 0.00000000, -0.05666269, -0.08380525, -0.08346248, -0.05354121};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, -0.01099715, 0.00634921, 0.00000000, -0.18856181, -0.16329932, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.00000000, 0.00000000, 0.08380525, 0.13910414, 0.10708242};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.04398859, 0.12698413, 0.00000000, -0.03591653, 0.15552316, 0.00000000, 0.00000000, -0.10368211, -0.01197218, 0.00000000, 0.00000000, 0.00000000, -0.09273609, -0.10708242};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.08797718, -0.10158730, 0.09273609, 0.10774960, 0.07257747, 0.07918852, -0.01338530, -0.05184105, -0.04190262, -0.12849890, -0.05666269, -0.01197218, 0.00927361, 0.01070824};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, 0.00000000, -0.01269841, -0.24343225, 0.00000000, 0.05443311, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.19274835, 0.00000000, -0.02394436, 0.00000000, 0.01070824};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.08797718, -0.10158730, 0.09273609, -0.10774960, 0.07257747, -0.07918852, -0.01338530, 0.05184105, -0.04190262, -0.12849890, 0.05666269, -0.01197218, -0.00927361, 0.01070824};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, -0.04123930, -0.02380952, 0.02898003, 0.02244783, 0.01296026, -0.03959426, -0.03346326, -0.02592053, -0.01496522, 0.03212473, 0.02833134, 0.02394436, 0.01854722, 0.01070824};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, 0.04123930, -0.02380952, 0.02898003, -0.02244783, 0.01296026, 0.03959426, -0.03346326, 0.02592053, -0.01496522, 0.03212473, -0.02833134, 0.02394436, -0.01854722, 0.01070824};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.00000000, 0.00000000, 0.04761905, 0.00000000, 0.00000000, 0.03888079, 0.00000000, 0.00000000, 0.00000000, 0.05986089, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.05354121};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.13196578, -0.02539683, 0.13910414, -0.07183307, 0.03110463, 0.06335081, 0.02677060, -0.06220926, 0.04788871, 0.00000000, 0.05666269, -0.08380525, 0.08346248, -0.05354121};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, 0.01099715, 0.00634921, 0.00000000, 0.18856181, -0.16329932, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.00000000, 0.00000000, 0.08380525, -0.13910414, 0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.04398859, 0.12698413, 0.00000000, 0.03591653, 0.15552316, 0.00000000, 0.00000000, 0.10368211, -0.01197218, 0.00000000, 0.00000000, 0.00000000, 0.09273609, -0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.13196578, -0.02539683, 0.13910414, 0.07183307, 0.03110463, -0.06335081, 0.02677060, 0.06220926, 0.04788871, 0.00000000, -0.05666269, -0.08380525, -0.08346248, -0.05354121};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, -0.01099715, 0.00634921, 0.00000000, -0.18856181, -0.16329932, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.00000000, 0.00000000, 0.08380525, 0.13910414, 0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.04398859, 0.12698413, 0.00000000, -0.03591653, 0.15552316, 0.00000000, 0.00000000, -0.10368211, -0.01197218, 0.00000000, 0.00000000, 0.00000000, -0.09273609, -0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, -0.08797718, -0.10158730, 0.09273609, 0.10774960, 0.07257747, 0.07918852, -0.01338530, -0.05184105, -0.04190262, -0.12849890, -0.05666269, -0.01197218, 0.00927361, 0.01070824};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.03142697, 0.00000000, -0.01269841, -0.24343225, 0.00000000, 0.05443311, 0.00000000, 0.09369712, 0.00000000, -0.04190262, 0.19274835, 0.00000000, -0.02394436, 0.00000000, 0.01070824};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 4; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 1; s < 4 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.12570787, 0.08797718, -0.10158730, 0.09273609, -0.10774960, 0.07257747, -0.07918852, -0.01338530, 0.05184105, -0.04190262, -0.12849890, 0.05666269, -0.01197218, -0.00927361, 0.01070824};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.29150262, 0.00000000, -2.99332591, 13.66260102, 0.00000000, 0.61101009, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.38178046, 0.00000000, 0.00000000, 12.52198067, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.46410162, 0.00000000, 7.83836718, 0.00000000, 0.00000000, 8.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 10.95445115, 0.00000000, 0.00000000, -3.83325939, 0.00000000, 17.74823935, 0.00000000, 0.55328334, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.73286383, 0.00000000, 3.34664011, 4.36435780, 0.00000000, -5.07468038, 0.00000000, 17.00840129, 0.00000000, 1.52127766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.44948974, 0.00000000, 0.00000000, 9.14285714, 0.00000000, 0.00000000, 0.00000000, 14.84614978, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.09838668, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 10.73312629, 0.00000000, 0.00000000, 0.00000000, 9.29516003, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[15][15] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.64575131, 5.18459256, -1.49666295, 6.83130051, -1.05830052, 0.30550505, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.23606798, 2.19089023, 2.52982213, 8.08290377, 6.26099034, -1.80739223, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.73205081, -5.09116882, 3.91918359, 0.00000000, 9.69948452, 4.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.00000000, 0.00000000, -2.82842712, 0.00000000, 0.00000000, 12.12435565, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.68328157, 5.47722558, -1.89736660, 7.42307489, -1.91662969, 0.66394000, 8.87411967, -1.07142857, 0.27664167, -0.09583148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.36643191, 2.89827535, 1.67332005, 2.18217890, 5.74704893, -2.53734019, 10.06230590, 8.50420064, -2.19577516, 0.76063883, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 1.22474487, 3.53553391, -7.37711114, 4.57142857, 1.64957220, 0.00000000, 11.49977817, 7.42307489, -2.57142857, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.54919334, 6.64078309, 3.83405790, 0.00000000, -6.19677335, 5.36656315, 0.00000000, 0.00000000, 13.41640786, 4.64758002, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.57770876, 0.00000000, 8.85437745, 0.00000000, 0.00000000, -3.09838668, 0.00000000, 0.00000000, 0.00000000, 16.09968944, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75000000*x[1][0] + 0.25000000*x[2][0];
      y[1] = 0.75000000*x[1][1] + 0.25000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25000000*x[1][0] + 0.75000000*x[2][0];
      y[1] = 0.25000000*x[1][1] + 0.75000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75000000*x[0][0] + 0.25000000*x[2][0];
      y[1] = 0.75000000*x[0][1] + 0.25000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25000000*x[0][0] + 0.75000000*x[2][0];
      y[1] = 0.25000000*x[0][1] + 0.75000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75000000*x[0][0] + 0.25000000*x[1][0];
      y[1] = 0.75000000*x[0][1] + 0.25000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25000000*x[0][0] + 0.75000000*x[1][0];
      y[1] = 0.25000000*x[0][1] + 0.75000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75000000*x[1][0] + 0.25000000*x[2][0];
    y[1] = 0.75000000*x[1][1] + 0.25000000*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25000000*x[1][0] + 0.75000000*x[2][0];
    y[1] = 0.25000000*x[1][1] + 0.75000000*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75000000*x[0][0] + 0.25000000*x[2][0];
    y[1] = 0.75000000*x[0][1] + 0.25000000*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25000000*x[0][0] + 0.75000000*x[2][0];
    y[1] = 0.25000000*x[0][1] + 0.75000000*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75000000*x[0][0] + 0.25000000*x[1][0];
    y[1] = 0.75000000*x[0][1] + 0.25000000*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25000000*x[0][0] + 0.75000000*x[1][0];
    y[1] = 0.25000000*x[0][1] + 0.75000000*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class restrictedelement_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  restrictedelement_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~restrictedelement_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1)))";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 3.00000000*m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 12;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.75000000*x[1][0] + 0.25000000*x[2][0];
    coordinates[3][1] = 0.75000000*x[1][1] + 0.25000000*x[2][1];
    coordinates[4][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[4][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[5][0] = 0.25000000*x[1][0] + 0.75000000*x[2][0];
    coordinates[5][1] = 0.25000000*x[1][1] + 0.75000000*x[2][1];
    coordinates[6][0] = 0.75000000*x[0][0] + 0.25000000*x[2][0];
    coordinates[6][1] = 0.75000000*x[0][1] + 0.25000000*x[2][1];
    coordinates[7][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[7][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[8][0] = 0.25000000*x[0][0] + 0.75000000*x[2][0];
    coordinates[8][1] = 0.25000000*x[0][1] + 0.75000000*x[2][1];
    coordinates[9][0] = 0.75000000*x[0][0] + 0.25000000*x[1][0];
    coordinates[9][1] = 0.75000000*x[0][1] + 0.25000000*x[1][1];
    coordinates[10][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[10][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[11][0] = 0.25000000*x[0][0] + 0.75000000*x[1][0];
    coordinates[11][1] = 0.25000000*x[0][1] + 0.75000000*x[1][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class restrictedelement_exterior_facet_integral_0_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  restrictedelement_exterior_facet_integral_0_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_exterior_facet_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 37
    // Total number of operations (multiply-add pairs):                  46
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.00000000;
      A[1] = 0.00000000;
      A[2] = 0.00000000;
      A[3] = 0.00000000;
      A[4] = 0.00000000;
      A[5] = 0.00000000;
      A[6] = 0.00000000;
      A[7] = 0.00000000;
      A[8] = 0.00000000;
      A[9] = 0.00000000;
      A[10] = 0.00000000;
      A[11] = 0.00000000;
      A[12] = 0.00000000;
      A[13] = 0.05149912*G0_;
      A[14] = -0.00511464*G0_;
      A[15] = 0.05220459*G0_;
      A[16] = -0.03068783*G0_;
      A[17] = 0.00987654*G0_;
      A[18] = 0.00000000;
      A[19] = 0.00000000;
      A[20] = 0.00000000;
      A[21] = 0.00000000;
      A[22] = 0.00000000;
      A[23] = 0.00000000;
      A[24] = 0.00000000;
      A[25] = -0.00511464*G0_;
      A[26] = 0.05149912*G0_;
      A[27] = 0.00987654*G0_;
      A[28] = -0.03068783*G0_;
      A[29] = 0.05220459*G0_;
      A[30] = 0.00000000;
      A[31] = 0.00000000;
      A[32] = 0.00000000;
      A[33] = 0.00000000;
      A[34] = 0.00000000;
      A[35] = 0.00000000;
      A[36] = 0.00000000;
      A[37] = 0.05220459*G0_;
      A[38] = 0.00987654*G0_;
      A[39] = 0.31604938*G0_;
      A[40] = -0.06772487*G0_;
      A[41] = 0.04514991*G0_;
      A[42] = 0.00000000;
      A[43] = 0.00000000;
      A[44] = 0.00000000;
      A[45] = 0.00000000;
      A[46] = 0.00000000;
      A[47] = 0.00000000;
      A[48] = 0.00000000;
      A[49] = -0.03068783*G0_;
      A[50] = -0.03068783*G0_;
      A[51] = -0.06772487*G0_;
      A[52] = 0.33015873*G0_;
      A[53] = -0.06772487*G0_;
      A[54] = 0.00000000;
      A[55] = 0.00000000;
      A[56] = 0.00000000;
      A[57] = 0.00000000;
      A[58] = 0.00000000;
      A[59] = 0.00000000;
      A[60] = 0.00000000;
      A[61] = 0.00987654*G0_;
      A[62] = 0.05220459*G0_;
      A[63] = 0.04514991*G0_;
      A[64] = -0.06772487*G0_;
      A[65] = 0.31604938*G0_;
      A[66] = 0.00000000;
      A[67] = 0.00000000;
      A[68] = 0.00000000;
      A[69] = 0.00000000;
      A[70] = 0.00000000;
      A[71] = 0.00000000;
      A[72] = 0.00000000;
      A[73] = 0.00000000;
      A[74] = 0.00000000;
      A[75] = 0.00000000;
      A[76] = 0.00000000;
      A[77] = 0.00000000;
      A[78] = 0.00000000;
      A[79] = 0.00000000;
      A[80] = 0.00000000;
      A[81] = 0.00000000;
      A[82] = 0.00000000;
      A[83] = 0.00000000;
      A[84] = 0.00000000;
      A[85] = 0.00000000;
      A[86] = 0.00000000;
      A[87] = 0.00000000;
      A[88] = 0.00000000;
      A[89] = 0.00000000;
      A[90] = 0.00000000;
      A[91] = 0.00000000;
      A[92] = 0.00000000;
      A[93] = 0.00000000;
      A[94] = 0.00000000;
      A[95] = 0.00000000;
      A[96] = 0.00000000;
      A[97] = 0.00000000;
      A[98] = 0.00000000;
      A[99] = 0.00000000;
      A[100] = 0.00000000;
      A[101] = 0.00000000;
      A[102] = 0.00000000;
      A[103] = 0.00000000;
      A[104] = 0.00000000;
      A[105] = 0.00000000;
      A[106] = 0.00000000;
      A[107] = 0.00000000;
      A[108] = 0.00000000;
      A[109] = 0.00000000;
      A[110] = 0.00000000;
      A[111] = 0.00000000;
      A[112] = 0.00000000;
      A[113] = 0.00000000;
      A[114] = 0.00000000;
      A[115] = 0.00000000;
      A[116] = 0.00000000;
      A[117] = 0.00000000;
      A[118] = 0.00000000;
      A[119] = 0.00000000;
      A[120] = 0.00000000;
      A[121] = 0.00000000;
      A[122] = 0.00000000;
      A[123] = 0.00000000;
      A[124] = 0.00000000;
      A[125] = 0.00000000;
      A[126] = 0.00000000;
      A[127] = 0.00000000;
      A[128] = 0.00000000;
      A[129] = 0.00000000;
      A[130] = 0.00000000;
      A[131] = 0.00000000;
      A[132] = 0.00000000;
      A[133] = 0.00000000;
      A[134] = 0.00000000;
      A[135] = 0.00000000;
      A[136] = 0.00000000;
      A[137] = 0.00000000;
      A[138] = 0.00000000;
      A[139] = 0.00000000;
      A[140] = 0.00000000;
      A[141] = 0.00000000;
      A[142] = 0.00000000;
      A[143] = 0.00000000;
        break;
      }
    case 1:
      {
        A[0] = 0.05149912*G0_;
      A[1] = 0.00000000;
      A[2] = -0.00511464*G0_;
      A[3] = 0.00000000;
      A[4] = 0.00000000;
      A[5] = 0.00000000;
      A[6] = 0.05220459*G0_;
      A[7] = -0.03068783*G0_;
      A[8] = 0.00987654*G0_;
      A[9] = 0.00000000;
      A[10] = 0.00000000;
      A[11] = 0.00000000;
      A[12] = 0.00000000;
      A[13] = 0.00000000;
      A[14] = 0.00000000;
      A[15] = 0.00000000;
      A[16] = 0.00000000;
      A[17] = 0.00000000;
      A[18] = 0.00000000;
      A[19] = 0.00000000;
      A[20] = 0.00000000;
      A[21] = 0.00000000;
      A[22] = 0.00000000;
      A[23] = 0.00000000;
      A[24] = -0.00511464*G0_;
      A[25] = 0.00000000;
      A[26] = 0.05149912*G0_;
      A[27] = 0.00000000;
      A[28] = 0.00000000;
      A[29] = 0.00000000;
      A[30] = 0.00987654*G0_;
      A[31] = -0.03068783*G0_;
      A[32] = 0.05220459*G0_;
      A[33] = 0.00000000;
      A[34] = 0.00000000;
      A[35] = 0.00000000;
      A[36] = 0.00000000;
      A[37] = 0.00000000;
      A[38] = 0.00000000;
      A[39] = 0.00000000;
      A[40] = 0.00000000;
      A[41] = 0.00000000;
      A[42] = 0.00000000;
      A[43] = 0.00000000;
      A[44] = 0.00000000;
      A[45] = 0.00000000;
      A[46] = 0.00000000;
      A[47] = 0.00000000;
      A[48] = 0.00000000;
      A[49] = 0.00000000;
      A[50] = 0.00000000;
      A[51] = 0.00000000;
      A[52] = 0.00000000;
      A[53] = 0.00000000;
      A[54] = 0.00000000;
      A[55] = 0.00000000;
      A[56] = 0.00000000;
      A[57] = 0.00000000;
      A[58] = 0.00000000;
      A[59] = 0.00000000;
      A[60] = 0.00000000;
      A[61] = 0.00000000;
      A[62] = 0.00000000;
      A[63] = 0.00000000;
      A[64] = 0.00000000;
      A[65] = 0.00000000;
      A[66] = 0.00000000;
      A[67] = 0.00000000;
      A[68] = 0.00000000;
      A[69] = 0.00000000;
      A[70] = 0.00000000;
      A[71] = 0.00000000;
      A[72] = 0.05220459*G0_;
      A[73] = 0.00000000;
      A[74] = 0.00987654*G0_;
      A[75] = 0.00000000;
      A[76] = 0.00000000;
      A[77] = 0.00000000;
      A[78] = 0.31604938*G0_;
      A[79] = -0.06772487*G0_;
      A[80] = 0.04514991*G0_;
      A[81] = 0.00000000;
      A[82] = 0.00000000;
      A[83] = 0.00000000;
      A[84] = -0.03068783*G0_;
      A[85] = 0.00000000;
      A[86] = -0.03068783*G0_;
      A[87] = 0.00000000;
      A[88] = 0.00000000;
      A[89] = 0.00000000;
      A[90] = -0.06772487*G0_;
      A[91] = 0.33015873*G0_;
      A[92] = -0.06772487*G0_;
      A[93] = 0.00000000;
      A[94] = 0.00000000;
      A[95] = 0.00000000;
      A[96] = 0.00987654*G0_;
      A[97] = 0.00000000;
      A[98] = 0.05220459*G0_;
      A[99] = 0.00000000;
      A[100] = 0.00000000;
      A[101] = 0.00000000;
      A[102] = 0.04514991*G0_;
      A[103] = -0.06772487*G0_;
      A[104] = 0.31604938*G0_;
      A[105] = 0.00000000;
      A[106] = 0.00000000;
      A[107] = 0.00000000;
      A[108] = 0.00000000;
      A[109] = 0.00000000;
      A[110] = 0.00000000;
      A[111] = 0.00000000;
      A[112] = 0.00000000;
      A[113] = 0.00000000;
      A[114] = 0.00000000;
      A[115] = 0.00000000;
      A[116] = 0.00000000;
      A[117] = 0.00000000;
      A[118] = 0.00000000;
      A[119] = 0.00000000;
      A[120] = 0.00000000;
      A[121] = 0.00000000;
      A[122] = 0.00000000;
      A[123] = 0.00000000;
      A[124] = 0.00000000;
      A[125] = 0.00000000;
      A[126] = 0.00000000;
      A[127] = 0.00000000;
      A[128] = 0.00000000;
      A[129] = 0.00000000;
      A[130] = 0.00000000;
      A[131] = 0.00000000;
      A[132] = 0.00000000;
      A[133] = 0.00000000;
      A[134] = 0.00000000;
      A[135] = 0.00000000;
      A[136] = 0.00000000;
      A[137] = 0.00000000;
      A[138] = 0.00000000;
      A[139] = 0.00000000;
      A[140] = 0.00000000;
      A[141] = 0.00000000;
      A[142] = 0.00000000;
      A[143] = 0.00000000;
        break;
      }
    case 2:
      {
        A[0] = 0.05149912*G0_;
      A[1] = -0.00511464*G0_;
      A[2] = 0.00000000;
      A[3] = 0.00000000;
      A[4] = 0.00000000;
      A[5] = 0.00000000;
      A[6] = 0.00000000;
      A[7] = 0.00000000;
      A[8] = 0.00000000;
      A[9] = 0.05220459*G0_;
      A[10] = -0.03068783*G0_;
      A[11] = 0.00987654*G0_;
      A[12] = -0.00511464*G0_;
      A[13] = 0.05149912*G0_;
      A[14] = 0.00000000;
      A[15] = 0.00000000;
      A[16] = 0.00000000;
      A[17] = 0.00000000;
      A[18] = 0.00000000;
      A[19] = 0.00000000;
      A[20] = 0.00000000;
      A[21] = 0.00987654*G0_;
      A[22] = -0.03068783*G0_;
      A[23] = 0.05220459*G0_;
      A[24] = 0.00000000;
      A[25] = 0.00000000;
      A[26] = 0.00000000;
      A[27] = 0.00000000;
      A[28] = 0.00000000;
      A[29] = 0.00000000;
      A[30] = 0.00000000;
      A[31] = 0.00000000;
      A[32] = 0.00000000;
      A[33] = 0.00000000;
      A[34] = 0.00000000;
      A[35] = 0.00000000;
      A[36] = 0.00000000;
      A[37] = 0.00000000;
      A[38] = 0.00000000;
      A[39] = 0.00000000;
      A[40] = 0.00000000;
      A[41] = 0.00000000;
      A[42] = 0.00000000;
      A[43] = 0.00000000;
      A[44] = 0.00000000;
      A[45] = 0.00000000;
      A[46] = 0.00000000;
      A[47] = 0.00000000;
      A[48] = 0.00000000;
      A[49] = 0.00000000;
      A[50] = 0.00000000;
      A[51] = 0.00000000;
      A[52] = 0.00000000;
      A[53] = 0.00000000;
      A[54] = 0.00000000;
      A[55] = 0.00000000;
      A[56] = 0.00000000;
      A[57] = 0.00000000;
      A[58] = 0.00000000;
      A[59] = 0.00000000;
      A[60] = 0.00000000;
      A[61] = 0.00000000;
      A[62] = 0.00000000;
      A[63] = 0.00000000;
      A[64] = 0.00000000;
      A[65] = 0.00000000;
      A[66] = 0.00000000;
      A[67] = 0.00000000;
      A[68] = 0.00000000;
      A[69] = 0.00000000;
      A[70] = 0.00000000;
      A[71] = 0.00000000;
      A[72] = 0.00000000;
      A[73] = 0.00000000;
      A[74] = 0.00000000;
      A[75] = 0.00000000;
      A[76] = 0.00000000;
      A[77] = 0.00000000;
      A[78] = 0.00000000;
      A[79] = 0.00000000;
      A[80] = 0.00000000;
      A[81] = 0.00000000;
      A[82] = 0.00000000;
      A[83] = 0.00000000;
      A[84] = 0.00000000;
      A[85] = 0.00000000;
      A[86] = 0.00000000;
      A[87] = 0.00000000;
      A[88] = 0.00000000;
      A[89] = 0.00000000;
      A[90] = 0.00000000;
      A[91] = 0.00000000;
      A[92] = 0.00000000;
      A[93] = 0.00000000;
      A[94] = 0.00000000;
      A[95] = 0.00000000;
      A[96] = 0.00000000;
      A[97] = 0.00000000;
      A[98] = 0.00000000;
      A[99] = 0.00000000;
      A[100] = 0.00000000;
      A[101] = 0.00000000;
      A[102] = 0.00000000;
      A[103] = 0.00000000;
      A[104] = 0.00000000;
      A[105] = 0.00000000;
      A[106] = 0.00000000;
      A[107] = 0.00000000;
      A[108] = 0.05220459*G0_;
      A[109] = 0.00987654*G0_;
      A[110] = 0.00000000;
      A[111] = 0.00000000;
      A[112] = 0.00000000;
      A[113] = 0.00000000;
      A[114] = 0.00000000;
      A[115] = 0.00000000;
      A[116] = 0.00000000;
      A[117] = 0.31604938*G0_;
      A[118] = -0.06772487*G0_;
      A[119] = 0.04514991*G0_;
      A[120] = -0.03068783*G0_;
      A[121] = -0.03068783*G0_;
      A[122] = 0.00000000;
      A[123] = 0.00000000;
      A[124] = 0.00000000;
      A[125] = 0.00000000;
      A[126] = 0.00000000;
      A[127] = 0.00000000;
      A[128] = 0.00000000;
      A[129] = -0.06772487*G0_;
      A[130] = 0.33015873*G0_;
      A[131] = -0.06772487*G0_;
      A[132] = 0.00987654*G0_;
      A[133] = 0.05220459*G0_;
      A[134] = 0.00000000;
      A[135] = 0.00000000;
      A[136] = 0.00000000;
      A[137] = 0.00000000;
      A[138] = 0.00000000;
      A[139] = 0.00000000;
      A[140] = 0.00000000;
      A[141] = 0.04514991*G0_;
      A[142] = -0.06772487*G0_;
      A[143] = 0.31604938*G0_;
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class restrictedelement_interior_facet_integral_0_0: public ufc::interior_facet_integral
{
public:

  /// Constructor
  restrictedelement_interior_facet_integral_0_0() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_interior_facet_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c0,
                               const ufc::cell& c1,
                               unsigned int facet0,
                               unsigned int facet1) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 450
    // Total number of operations (multiply-add pairs):                  462
    
    // Extract vertex coordinates
    const double * const * x0 = c0.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet0][0];
    const unsigned int v1 = edge_vertices[facet0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x0[v1][0] - x0[v0][0];
    const double dx1 = x0[v1][1] - x0[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_ = det;
    const double G1_ = det;
    const double G2_ = det;
    const double G3_ = det;
    
    // Compute element tensor
    switch (facet0)
    {
    case 0:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.00000000;
        A[1] = 0.00000000;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.00000000;
        A[13] = 0.00000000;
        A[14] = 0.00000000;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = 0.00000000;
        A[25] = 0.01287478*G3_;
        A[26] = -0.00127866*G3_;
        A[27] = 0.01305115*G3_;
        A[28] = -0.00767196*G3_;
        A[29] = 0.00246914*G3_;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.00000000;
        A[37] = 0.01287478*G2_;
        A[38] = -0.00127866*G2_;
        A[39] = 0.01305115*G2_;
        A[40] = -0.00767196*G2_;
        A[41] = 0.00246914*G2_;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = 0.00000000;
        A[49] = -0.00127866*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00246914*G3_;
        A[52] = -0.00767196*G3_;
        A[53] = 0.01305115*G3_;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = 0.00000000;
        A[61] = -0.00127866*G2_;
        A[62] = 0.01287478*G2_;
        A[63] = 0.00246914*G2_;
        A[64] = -0.00767196*G2_;
        A[65] = 0.01305115*G2_;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.01305115*G3_;
        A[74] = 0.00246914*G3_;
        A[75] = 0.07901235*G3_;
        A[76] = -0.01693122*G3_;
        A[77] = 0.01128748*G3_;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.01305115*G2_;
        A[86] = 0.00246914*G2_;
        A[87] = 0.07901235*G2_;
        A[88] = -0.01693122*G2_;
        A[89] = 0.01128748*G2_;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = -0.00767196*G3_;
        A[98] = -0.00767196*G3_;
        A[99] = -0.01693122*G3_;
        A[100] = 0.08253968*G3_;
        A[101] = -0.01693122*G3_;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = -0.00767196*G2_;
        A[110] = -0.00767196*G2_;
        A[111] = -0.01693122*G2_;
        A[112] = 0.08253968*G2_;
        A[113] = -0.01693122*G2_;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00246914*G3_;
        A[122] = 0.01305115*G3_;
        A[123] = 0.01128748*G3_;
        A[124] = -0.01693122*G3_;
        A[125] = 0.07901235*G3_;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00246914*G2_;
        A[134] = 0.01305115*G2_;
        A[135] = 0.01128748*G2_;
        A[136] = -0.01693122*G2_;
        A[137] = 0.07901235*G2_;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.00000000;
        A[289] = 0.00000000;
        A[290] = 0.00000000;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.00000000;
        A[301] = 0.00000000;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.00000000;
        A[313] = 0.01287478*G1_;
        A[314] = -0.00127866*G1_;
        A[315] = 0.01305115*G1_;
        A[316] = -0.00767196*G1_;
        A[317] = 0.00246914*G1_;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = 0.00000000;
        A[325] = 0.01287478*G0_;
        A[326] = -0.00127866*G0_;
        A[327] = 0.01305115*G0_;
        A[328] = -0.00767196*G0_;
        A[329] = 0.00246914*G0_;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = 0.00000000;
        A[337] = -0.00127866*G1_;
        A[338] = 0.01287478*G1_;
        A[339] = 0.00246914*G1_;
        A[340] = -0.00767196*G1_;
        A[341] = 0.01305115*G1_;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = 0.00000000;
        A[349] = -0.00127866*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00246914*G0_;
        A[352] = -0.00767196*G0_;
        A[353] = 0.01305115*G0_;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.01305115*G1_;
        A[362] = 0.00246914*G1_;
        A[363] = 0.07901235*G1_;
        A[364] = -0.01693122*G1_;
        A[365] = 0.01128748*G1_;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.01305115*G0_;
        A[374] = 0.00246914*G0_;
        A[375] = 0.07901235*G0_;
        A[376] = -0.01693122*G0_;
        A[377] = 0.01128748*G0_;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = -0.00767196*G1_;
        A[386] = -0.00767196*G1_;
        A[387] = -0.01693122*G1_;
        A[388] = 0.08253968*G1_;
        A[389] = -0.01693122*G1_;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = -0.00767196*G0_;
        A[398] = -0.00767196*G0_;
        A[399] = -0.01693122*G0_;
        A[400] = 0.08253968*G0_;
        A[401] = -0.01693122*G0_;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00246914*G1_;
        A[410] = 0.01305115*G1_;
        A[411] = 0.01128748*G1_;
        A[412] = -0.01693122*G1_;
        A[413] = 0.07901235*G1_;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00246914*G0_;
        A[422] = 0.01305115*G0_;
        A[423] = 0.01128748*G0_;
        A[424] = -0.01693122*G0_;
        A[425] = 0.07901235*G0_;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 1:
        {
          A[0] = 0.00000000;
        A[1] = 0.00000000;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.00000000;
        A[13] = 0.00000000;
        A[14] = 0.00000000;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = 0.00000000;
        A[25] = 0.01287478*G3_;
        A[26] = -0.00127866*G3_;
        A[27] = 0.01305115*G3_;
        A[28] = -0.00767196*G3_;
        A[29] = 0.00246914*G3_;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.01287478*G2_;
        A[37] = 0.00000000;
        A[38] = -0.00127866*G2_;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.01305115*G2_;
        A[43] = -0.00767196*G2_;
        A[44] = 0.00246914*G2_;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = 0.00000000;
        A[49] = -0.00127866*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00246914*G3_;
        A[52] = -0.00767196*G3_;
        A[53] = 0.01305115*G3_;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = -0.00127866*G2_;
        A[61] = 0.00000000;
        A[62] = 0.01287478*G2_;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00246914*G2_;
        A[67] = -0.00767196*G2_;
        A[68] = 0.01305115*G2_;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.01305115*G3_;
        A[74] = 0.00246914*G3_;
        A[75] = 0.07901235*G3_;
        A[76] = -0.01693122*G3_;
        A[77] = 0.01128748*G3_;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.01305115*G2_;
        A[85] = 0.00000000;
        A[86] = 0.00246914*G2_;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.07901235*G2_;
        A[91] = -0.01693122*G2_;
        A[92] = 0.01128748*G2_;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = -0.00767196*G3_;
        A[98] = -0.00767196*G3_;
        A[99] = -0.01693122*G3_;
        A[100] = 0.08253968*G3_;
        A[101] = -0.01693122*G3_;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = -0.00767196*G2_;
        A[109] = 0.00000000;
        A[110] = -0.00767196*G2_;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = -0.01693122*G2_;
        A[115] = 0.08253968*G2_;
        A[116] = -0.01693122*G2_;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00246914*G3_;
        A[122] = 0.01305115*G3_;
        A[123] = 0.01128748*G3_;
        A[124] = -0.01693122*G3_;
        A[125] = 0.07901235*G3_;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00246914*G2_;
        A[133] = 0.00000000;
        A[134] = 0.01305115*G2_;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.01128748*G2_;
        A[139] = -0.01693122*G2_;
        A[140] = 0.07901235*G2_;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.00000000;
        A[289] = 0.01287478*G1_;
        A[290] = -0.00127866*G1_;
        A[291] = 0.01305115*G1_;
        A[292] = -0.00767196*G1_;
        A[293] = 0.00246914*G1_;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.01287478*G0_;
        A[301] = 0.00000000;
        A[302] = -0.00127866*G0_;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.01305115*G0_;
        A[307] = -0.00767196*G0_;
        A[308] = 0.00246914*G0_;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.00000000;
        A[313] = 0.00000000;
        A[314] = 0.00000000;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = 0.00000000;
        A[325] = 0.00000000;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = 0.00000000;
        A[337] = -0.00127866*G1_;
        A[338] = 0.01287478*G1_;
        A[339] = 0.00246914*G1_;
        A[340] = -0.00767196*G1_;
        A[341] = 0.01305115*G1_;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = -0.00127866*G0_;
        A[349] = 0.00000000;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00246914*G0_;
        A[355] = -0.00767196*G0_;
        A[356] = 0.01305115*G0_;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.01305115*G1_;
        A[434] = 0.00246914*G1_;
        A[435] = 0.07901235*G1_;
        A[436] = -0.01693122*G1_;
        A[437] = 0.01128748*G1_;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.01305115*G0_;
        A[445] = 0.00000000;
        A[446] = 0.00246914*G0_;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.07901235*G0_;
        A[451] = -0.01693122*G0_;
        A[452] = 0.01128748*G0_;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = -0.00767196*G1_;
        A[458] = -0.00767196*G1_;
        A[459] = -0.01693122*G1_;
        A[460] = 0.08253968*G1_;
        A[461] = -0.01693122*G1_;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = -0.00767196*G0_;
        A[469] = 0.00000000;
        A[470] = -0.00767196*G0_;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = -0.01693122*G0_;
        A[475] = 0.08253968*G0_;
        A[476] = -0.01693122*G0_;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00246914*G1_;
        A[482] = 0.01305115*G1_;
        A[483] = 0.01128748*G1_;
        A[484] = -0.01693122*G1_;
        A[485] = 0.07901235*G1_;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00246914*G0_;
        A[493] = 0.00000000;
        A[494] = 0.01305115*G0_;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.01128748*G0_;
        A[499] = -0.01693122*G0_;
        A[500] = 0.07901235*G0_;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 2:
        {
          A[0] = 0.00000000;
        A[1] = 0.00000000;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.00000000;
        A[13] = 0.00000000;
        A[14] = 0.00000000;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = 0.00000000;
        A[25] = 0.01287478*G3_;
        A[26] = -0.00127866*G3_;
        A[27] = 0.01305115*G3_;
        A[28] = -0.00767196*G3_;
        A[29] = 0.00246914*G3_;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.01287478*G2_;
        A[37] = -0.00127866*G2_;
        A[38] = 0.00000000;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.01305115*G2_;
        A[46] = -0.00767196*G2_;
        A[47] = 0.00246914*G2_;
        A[48] = 0.00000000;
        A[49] = -0.00127866*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00246914*G3_;
        A[52] = -0.00767196*G3_;
        A[53] = 0.01305115*G3_;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = -0.00127866*G2_;
        A[61] = 0.01287478*G2_;
        A[62] = 0.00000000;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00246914*G2_;
        A[70] = -0.00767196*G2_;
        A[71] = 0.01305115*G2_;
        A[72] = 0.00000000;
        A[73] = 0.01305115*G3_;
        A[74] = 0.00246914*G3_;
        A[75] = 0.07901235*G3_;
        A[76] = -0.01693122*G3_;
        A[77] = 0.01128748*G3_;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.01305115*G2_;
        A[85] = 0.00246914*G2_;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.07901235*G2_;
        A[94] = -0.01693122*G2_;
        A[95] = 0.01128748*G2_;
        A[96] = 0.00000000;
        A[97] = -0.00767196*G3_;
        A[98] = -0.00767196*G3_;
        A[99] = -0.01693122*G3_;
        A[100] = 0.08253968*G3_;
        A[101] = -0.01693122*G3_;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = -0.00767196*G2_;
        A[109] = -0.00767196*G2_;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = -0.01693122*G2_;
        A[118] = 0.08253968*G2_;
        A[119] = -0.01693122*G2_;
        A[120] = 0.00000000;
        A[121] = 0.00246914*G3_;
        A[122] = 0.01305115*G3_;
        A[123] = 0.01128748*G3_;
        A[124] = -0.01693122*G3_;
        A[125] = 0.07901235*G3_;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00246914*G2_;
        A[133] = 0.01305115*G2_;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.01128748*G2_;
        A[142] = -0.01693122*G2_;
        A[143] = 0.07901235*G2_;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.00000000;
        A[289] = 0.01287478*G1_;
        A[290] = -0.00127866*G1_;
        A[291] = 0.01305115*G1_;
        A[292] = -0.00767196*G1_;
        A[293] = 0.00246914*G1_;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.01287478*G0_;
        A[301] = -0.00127866*G0_;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.01305115*G0_;
        A[310] = -0.00767196*G0_;
        A[311] = 0.00246914*G0_;
        A[312] = 0.00000000;
        A[313] = -0.00127866*G1_;
        A[314] = 0.01287478*G1_;
        A[315] = 0.00246914*G1_;
        A[316] = -0.00767196*G1_;
        A[317] = 0.01305115*G1_;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = -0.00127866*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00246914*G0_;
        A[334] = -0.00767196*G0_;
        A[335] = 0.01305115*G0_;
        A[336] = 0.00000000;
        A[337] = 0.00000000;
        A[338] = 0.00000000;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = 0.00000000;
        A[349] = 0.00000000;
        A[350] = 0.00000000;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.01305115*G1_;
        A[506] = 0.00246914*G1_;
        A[507] = 0.07901235*G1_;
        A[508] = -0.01693122*G1_;
        A[509] = 0.01128748*G1_;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.01305115*G0_;
        A[517] = 0.00246914*G0_;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.07901235*G0_;
        A[526] = -0.01693122*G0_;
        A[527] = 0.01128748*G0_;
        A[528] = 0.00000000;
        A[529] = -0.00767196*G1_;
        A[530] = -0.00767196*G1_;
        A[531] = -0.01693122*G1_;
        A[532] = 0.08253968*G1_;
        A[533] = -0.01693122*G1_;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = -0.00767196*G0_;
        A[541] = -0.00767196*G0_;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = -0.01693122*G0_;
        A[550] = 0.08253968*G0_;
        A[551] = -0.01693122*G0_;
        A[552] = 0.00000000;
        A[553] = 0.00246914*G1_;
        A[554] = 0.01305115*G1_;
        A[555] = 0.01128748*G1_;
        A[556] = -0.01693122*G1_;
        A[557] = 0.07901235*G1_;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00246914*G0_;
        A[565] = 0.01305115*G0_;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.01128748*G0_;
        A[574] = -0.01693122*G0_;
        A[575] = 0.07901235*G0_;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.00000000;
        A[2] = -0.00127866*G3_;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.01305115*G3_;
        A[7] = -0.00767196*G3_;
        A[8] = 0.00246914*G3_;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.00000000;
        A[13] = 0.01287478*G2_;
        A[14] = -0.00127866*G2_;
        A[15] = 0.01305115*G2_;
        A[16] = -0.00767196*G2_;
        A[17] = 0.00246914*G2_;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = 0.00000000;
        A[25] = 0.00000000;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.00000000;
        A[37] = 0.00000000;
        A[38] = 0.00000000;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = -0.00127866*G3_;
        A[49] = 0.00000000;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00246914*G3_;
        A[55] = -0.00767196*G3_;
        A[56] = 0.01305115*G3_;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = 0.00000000;
        A[61] = -0.00127866*G2_;
        A[62] = 0.01287478*G2_;
        A[63] = 0.00246914*G2_;
        A[64] = -0.00767196*G2_;
        A[65] = 0.01305115*G2_;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.01305115*G3_;
        A[145] = 0.00000000;
        A[146] = 0.00246914*G3_;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.07901235*G3_;
        A[151] = -0.01693122*G3_;
        A[152] = 0.01128748*G3_;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.01305115*G2_;
        A[158] = 0.00246914*G2_;
        A[159] = 0.07901235*G2_;
        A[160] = -0.01693122*G2_;
        A[161] = 0.01128748*G2_;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = -0.00767196*G3_;
        A[169] = 0.00000000;
        A[170] = -0.00767196*G3_;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = -0.01693122*G3_;
        A[175] = 0.08253968*G3_;
        A[176] = -0.01693122*G3_;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = -0.00767196*G2_;
        A[182] = -0.00767196*G2_;
        A[183] = -0.01693122*G2_;
        A[184] = 0.08253968*G2_;
        A[185] = -0.01693122*G2_;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00246914*G3_;
        A[193] = 0.00000000;
        A[194] = 0.01305115*G3_;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.01128748*G3_;
        A[199] = -0.01693122*G3_;
        A[200] = 0.07901235*G3_;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00246914*G2_;
        A[206] = 0.01305115*G2_;
        A[207] = 0.01128748*G2_;
        A[208] = -0.01693122*G2_;
        A[209] = 0.07901235*G2_;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.00000000;
        A[289] = 0.00000000;
        A[290] = 0.00000000;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.00000000;
        A[301] = 0.00000000;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.01287478*G1_;
        A[313] = 0.00000000;
        A[314] = -0.00127866*G1_;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.01305115*G1_;
        A[319] = -0.00767196*G1_;
        A[320] = 0.00246914*G1_;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = 0.00000000;
        A[325] = 0.01287478*G0_;
        A[326] = -0.00127866*G0_;
        A[327] = 0.01305115*G0_;
        A[328] = -0.00767196*G0_;
        A[329] = 0.00246914*G0_;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = -0.00127866*G1_;
        A[337] = 0.00000000;
        A[338] = 0.01287478*G1_;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00246914*G1_;
        A[343] = -0.00767196*G1_;
        A[344] = 0.01305115*G1_;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = 0.00000000;
        A[349] = -0.00127866*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00246914*G0_;
        A[352] = -0.00767196*G0_;
        A[353] = 0.01305115*G0_;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.01305115*G1_;
        A[361] = 0.00000000;
        A[362] = 0.00246914*G1_;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.07901235*G1_;
        A[367] = -0.01693122*G1_;
        A[368] = 0.01128748*G1_;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.01305115*G0_;
        A[374] = 0.00246914*G0_;
        A[375] = 0.07901235*G0_;
        A[376] = -0.01693122*G0_;
        A[377] = 0.01128748*G0_;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = -0.00767196*G1_;
        A[385] = 0.00000000;
        A[386] = -0.00767196*G1_;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = -0.01693122*G1_;
        A[391] = 0.08253968*G1_;
        A[392] = -0.01693122*G1_;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = -0.00767196*G0_;
        A[398] = -0.00767196*G0_;
        A[399] = -0.01693122*G0_;
        A[400] = 0.08253968*G0_;
        A[401] = -0.01693122*G0_;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00246914*G1_;
        A[409] = 0.00000000;
        A[410] = 0.01305115*G1_;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.01128748*G1_;
        A[415] = -0.01693122*G1_;
        A[416] = 0.07901235*G1_;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00246914*G0_;
        A[422] = 0.01305115*G0_;
        A[423] = 0.01128748*G0_;
        A[424] = -0.01693122*G0_;
        A[425] = 0.07901235*G0_;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 1:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.00000000;
        A[2] = -0.00127866*G3_;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.01305115*G3_;
        A[7] = -0.00767196*G3_;
        A[8] = 0.00246914*G3_;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.01287478*G2_;
        A[13] = 0.00000000;
        A[14] = -0.00127866*G2_;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.01305115*G2_;
        A[19] = -0.00767196*G2_;
        A[20] = 0.00246914*G2_;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = 0.00000000;
        A[25] = 0.00000000;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.00000000;
        A[37] = 0.00000000;
        A[38] = 0.00000000;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = -0.00127866*G3_;
        A[49] = 0.00000000;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00246914*G3_;
        A[55] = -0.00767196*G3_;
        A[56] = 0.01305115*G3_;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = -0.00127866*G2_;
        A[61] = 0.00000000;
        A[62] = 0.01287478*G2_;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00246914*G2_;
        A[67] = -0.00767196*G2_;
        A[68] = 0.01305115*G2_;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.01305115*G3_;
        A[145] = 0.00000000;
        A[146] = 0.00246914*G3_;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.07901235*G3_;
        A[151] = -0.01693122*G3_;
        A[152] = 0.01128748*G3_;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.01305115*G2_;
        A[157] = 0.00000000;
        A[158] = 0.00246914*G2_;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.07901235*G2_;
        A[163] = -0.01693122*G2_;
        A[164] = 0.01128748*G2_;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = -0.00767196*G3_;
        A[169] = 0.00000000;
        A[170] = -0.00767196*G3_;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = -0.01693122*G3_;
        A[175] = 0.08253968*G3_;
        A[176] = -0.01693122*G3_;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = -0.00767196*G2_;
        A[181] = 0.00000000;
        A[182] = -0.00767196*G2_;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = -0.01693122*G2_;
        A[187] = 0.08253968*G2_;
        A[188] = -0.01693122*G2_;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00246914*G3_;
        A[193] = 0.00000000;
        A[194] = 0.01305115*G3_;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.01128748*G3_;
        A[199] = -0.01693122*G3_;
        A[200] = 0.07901235*G3_;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00246914*G2_;
        A[205] = 0.00000000;
        A[206] = 0.01305115*G2_;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.01128748*G2_;
        A[211] = -0.01693122*G2_;
        A[212] = 0.07901235*G2_;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.01287478*G1_;
        A[289] = 0.00000000;
        A[290] = -0.00127866*G1_;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.01305115*G1_;
        A[295] = -0.00767196*G1_;
        A[296] = 0.00246914*G1_;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.01287478*G0_;
        A[301] = 0.00000000;
        A[302] = -0.00127866*G0_;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.01305115*G0_;
        A[307] = -0.00767196*G0_;
        A[308] = 0.00246914*G0_;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.00000000;
        A[313] = 0.00000000;
        A[314] = 0.00000000;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = 0.00000000;
        A[325] = 0.00000000;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = -0.00127866*G1_;
        A[337] = 0.00000000;
        A[338] = 0.01287478*G1_;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00246914*G1_;
        A[343] = -0.00767196*G1_;
        A[344] = 0.01305115*G1_;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = -0.00127866*G0_;
        A[349] = 0.00000000;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00246914*G0_;
        A[355] = -0.00767196*G0_;
        A[356] = 0.01305115*G0_;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.01305115*G1_;
        A[433] = 0.00000000;
        A[434] = 0.00246914*G1_;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.07901235*G1_;
        A[439] = -0.01693122*G1_;
        A[440] = 0.01128748*G1_;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.01305115*G0_;
        A[445] = 0.00000000;
        A[446] = 0.00246914*G0_;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.07901235*G0_;
        A[451] = -0.01693122*G0_;
        A[452] = 0.01128748*G0_;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = -0.00767196*G1_;
        A[457] = 0.00000000;
        A[458] = -0.00767196*G1_;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = -0.01693122*G1_;
        A[463] = 0.08253968*G1_;
        A[464] = -0.01693122*G1_;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = -0.00767196*G0_;
        A[469] = 0.00000000;
        A[470] = -0.00767196*G0_;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = -0.01693122*G0_;
        A[475] = 0.08253968*G0_;
        A[476] = -0.01693122*G0_;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00246914*G1_;
        A[481] = 0.00000000;
        A[482] = 0.01305115*G1_;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.01128748*G1_;
        A[487] = -0.01693122*G1_;
        A[488] = 0.07901235*G1_;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00246914*G0_;
        A[493] = 0.00000000;
        A[494] = 0.01305115*G0_;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.01128748*G0_;
        A[499] = -0.01693122*G0_;
        A[500] = 0.07901235*G0_;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 2:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.00000000;
        A[2] = -0.00127866*G3_;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.01305115*G3_;
        A[7] = -0.00767196*G3_;
        A[8] = 0.00246914*G3_;
        A[9] = 0.00000000;
        A[10] = 0.00000000;
        A[11] = 0.00000000;
        A[12] = 0.01287478*G2_;
        A[13] = -0.00127866*G2_;
        A[14] = 0.00000000;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.01305115*G2_;
        A[22] = -0.00767196*G2_;
        A[23] = 0.00246914*G2_;
        A[24] = 0.00000000;
        A[25] = 0.00000000;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00000000;
        A[34] = 0.00000000;
        A[35] = 0.00000000;
        A[36] = 0.00000000;
        A[37] = 0.00000000;
        A[38] = 0.00000000;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = -0.00127866*G3_;
        A[49] = 0.00000000;
        A[50] = 0.01287478*G3_;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00246914*G3_;
        A[55] = -0.00767196*G3_;
        A[56] = 0.01305115*G3_;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = -0.00127866*G2_;
        A[61] = 0.01287478*G2_;
        A[62] = 0.00000000;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00246914*G2_;
        A[70] = -0.00767196*G2_;
        A[71] = 0.01305115*G2_;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.01305115*G3_;
        A[145] = 0.00000000;
        A[146] = 0.00246914*G3_;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.07901235*G3_;
        A[151] = -0.01693122*G3_;
        A[152] = 0.01128748*G3_;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.01305115*G2_;
        A[157] = 0.00246914*G2_;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.07901235*G2_;
        A[166] = -0.01693122*G2_;
        A[167] = 0.01128748*G2_;
        A[168] = -0.00767196*G3_;
        A[169] = 0.00000000;
        A[170] = -0.00767196*G3_;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = -0.01693122*G3_;
        A[175] = 0.08253968*G3_;
        A[176] = -0.01693122*G3_;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = -0.00767196*G2_;
        A[181] = -0.00767196*G2_;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = -0.01693122*G2_;
        A[190] = 0.08253968*G2_;
        A[191] = -0.01693122*G2_;
        A[192] = 0.00246914*G3_;
        A[193] = 0.00000000;
        A[194] = 0.01305115*G3_;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.01128748*G3_;
        A[199] = -0.01693122*G3_;
        A[200] = 0.07901235*G3_;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00246914*G2_;
        A[205] = 0.01305115*G2_;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.01128748*G2_;
        A[214] = -0.01693122*G2_;
        A[215] = 0.07901235*G2_;
        A[216] = 0.00000000;
        A[217] = 0.00000000;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.00000000;
        A[226] = 0.00000000;
        A[227] = 0.00000000;
        A[228] = 0.00000000;
        A[229] = 0.00000000;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = 0.00000000;
        A[241] = 0.00000000;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = 0.00000000;
        A[250] = 0.00000000;
        A[251] = 0.00000000;
        A[252] = 0.00000000;
        A[253] = 0.00000000;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00000000;
        A[265] = 0.00000000;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.00000000;
        A[274] = 0.00000000;
        A[275] = 0.00000000;
        A[276] = 0.00000000;
        A[277] = 0.00000000;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.01287478*G1_;
        A[289] = 0.00000000;
        A[290] = -0.00127866*G1_;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.01305115*G1_;
        A[295] = -0.00767196*G1_;
        A[296] = 0.00246914*G1_;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.01287478*G0_;
        A[301] = -0.00127866*G0_;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.01305115*G0_;
        A[310] = -0.00767196*G0_;
        A[311] = 0.00246914*G0_;
        A[312] = -0.00127866*G1_;
        A[313] = 0.00000000;
        A[314] = 0.01287478*G1_;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00246914*G1_;
        A[319] = -0.00767196*G1_;
        A[320] = 0.01305115*G1_;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = -0.00127866*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00246914*G0_;
        A[334] = -0.00767196*G0_;
        A[335] = 0.01305115*G0_;
        A[336] = 0.00000000;
        A[337] = 0.00000000;
        A[338] = 0.00000000;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = 0.00000000;
        A[349] = 0.00000000;
        A[350] = 0.00000000;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.01305115*G1_;
        A[505] = 0.00000000;
        A[506] = 0.00246914*G1_;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.07901235*G1_;
        A[511] = -0.01693122*G1_;
        A[512] = 0.01128748*G1_;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.01305115*G0_;
        A[517] = 0.00246914*G0_;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.07901235*G0_;
        A[526] = -0.01693122*G0_;
        A[527] = 0.01128748*G0_;
        A[528] = -0.00767196*G1_;
        A[529] = 0.00000000;
        A[530] = -0.00767196*G1_;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = -0.01693122*G1_;
        A[535] = 0.08253968*G1_;
        A[536] = -0.01693122*G1_;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = -0.00767196*G0_;
        A[541] = -0.00767196*G0_;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = -0.01693122*G0_;
        A[550] = 0.08253968*G0_;
        A[551] = -0.01693122*G0_;
        A[552] = 0.00246914*G1_;
        A[553] = 0.00000000;
        A[554] = 0.01305115*G1_;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.01128748*G1_;
        A[559] = -0.01693122*G1_;
        A[560] = 0.07901235*G1_;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00246914*G0_;
        A[565] = 0.01305115*G0_;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.01128748*G0_;
        A[574] = -0.01693122*G0_;
        A[575] = 0.07901235*G0_;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.00127866*G3_;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.01305115*G3_;
        A[10] = -0.00767196*G3_;
        A[11] = 0.00246914*G3_;
        A[12] = 0.00000000;
        A[13] = 0.01287478*G2_;
        A[14] = -0.00127866*G2_;
        A[15] = 0.01305115*G2_;
        A[16] = -0.00767196*G2_;
        A[17] = 0.00246914*G2_;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = -0.00127866*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00246914*G3_;
        A[34] = -0.00767196*G3_;
        A[35] = 0.01305115*G3_;
        A[36] = 0.00000000;
        A[37] = -0.00127866*G2_;
        A[38] = 0.01287478*G2_;
        A[39] = 0.00246914*G2_;
        A[40] = -0.00767196*G2_;
        A[41] = 0.01305115*G2_;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = 0.00000000;
        A[49] = 0.00000000;
        A[50] = 0.00000000;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = 0.00000000;
        A[61] = 0.00000000;
        A[62] = 0.00000000;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.01305115*G3_;
        A[217] = 0.00246914*G3_;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.07901235*G3_;
        A[226] = -0.01693122*G3_;
        A[227] = 0.01128748*G3_;
        A[228] = 0.00000000;
        A[229] = 0.01305115*G2_;
        A[230] = 0.00246914*G2_;
        A[231] = 0.07901235*G2_;
        A[232] = -0.01693122*G2_;
        A[233] = 0.01128748*G2_;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = -0.00767196*G3_;
        A[241] = -0.00767196*G3_;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = -0.01693122*G3_;
        A[250] = 0.08253968*G3_;
        A[251] = -0.01693122*G3_;
        A[252] = 0.00000000;
        A[253] = -0.00767196*G2_;
        A[254] = -0.00767196*G2_;
        A[255] = -0.01693122*G2_;
        A[256] = 0.08253968*G2_;
        A[257] = -0.01693122*G2_;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00246914*G3_;
        A[265] = 0.01305115*G3_;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.01128748*G3_;
        A[274] = -0.01693122*G3_;
        A[275] = 0.07901235*G3_;
        A[276] = 0.00000000;
        A[277] = 0.00246914*G2_;
        A[278] = 0.01305115*G2_;
        A[279] = 0.01128748*G2_;
        A[280] = -0.01693122*G2_;
        A[281] = 0.07901235*G2_;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.00000000;
        A[289] = 0.00000000;
        A[290] = 0.00000000;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.00000000;
        A[298] = 0.00000000;
        A[299] = 0.00000000;
        A[300] = 0.00000000;
        A[301] = 0.00000000;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.01287478*G1_;
        A[313] = -0.00127866*G1_;
        A[314] = 0.00000000;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.01305115*G1_;
        A[322] = -0.00767196*G1_;
        A[323] = 0.00246914*G1_;
        A[324] = 0.00000000;
        A[325] = 0.01287478*G0_;
        A[326] = -0.00127866*G0_;
        A[327] = 0.01305115*G0_;
        A[328] = -0.00767196*G0_;
        A[329] = 0.00246914*G0_;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = -0.00127866*G1_;
        A[337] = 0.01287478*G1_;
        A[338] = 0.00000000;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00246914*G1_;
        A[346] = -0.00767196*G1_;
        A[347] = 0.01305115*G1_;
        A[348] = 0.00000000;
        A[349] = -0.00127866*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00246914*G0_;
        A[352] = -0.00767196*G0_;
        A[353] = 0.01305115*G0_;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.01305115*G1_;
        A[361] = 0.00246914*G1_;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.07901235*G1_;
        A[370] = -0.01693122*G1_;
        A[371] = 0.01128748*G1_;
        A[372] = 0.00000000;
        A[373] = 0.01305115*G0_;
        A[374] = 0.00246914*G0_;
        A[375] = 0.07901235*G0_;
        A[376] = -0.01693122*G0_;
        A[377] = 0.01128748*G0_;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = -0.00767196*G1_;
        A[385] = -0.00767196*G1_;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = -0.01693122*G1_;
        A[394] = 0.08253968*G1_;
        A[395] = -0.01693122*G1_;
        A[396] = 0.00000000;
        A[397] = -0.00767196*G0_;
        A[398] = -0.00767196*G0_;
        A[399] = -0.01693122*G0_;
        A[400] = 0.08253968*G0_;
        A[401] = -0.01693122*G0_;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00246914*G1_;
        A[409] = 0.01305115*G1_;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.01128748*G1_;
        A[418] = -0.01693122*G1_;
        A[419] = 0.07901235*G1_;
        A[420] = 0.00000000;
        A[421] = 0.00246914*G0_;
        A[422] = 0.01305115*G0_;
        A[423] = 0.01128748*G0_;
        A[424] = -0.01693122*G0_;
        A[425] = 0.07901235*G0_;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 1:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.00127866*G3_;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.01305115*G3_;
        A[10] = -0.00767196*G3_;
        A[11] = 0.00246914*G3_;
        A[12] = 0.01287478*G2_;
        A[13] = 0.00000000;
        A[14] = -0.00127866*G2_;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.01305115*G2_;
        A[19] = -0.00767196*G2_;
        A[20] = 0.00246914*G2_;
        A[21] = 0.00000000;
        A[22] = 0.00000000;
        A[23] = 0.00000000;
        A[24] = -0.00127866*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00246914*G3_;
        A[34] = -0.00767196*G3_;
        A[35] = 0.01305115*G3_;
        A[36] = -0.00127866*G2_;
        A[37] = 0.00000000;
        A[38] = 0.01287478*G2_;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00246914*G2_;
        A[43] = -0.00767196*G2_;
        A[44] = 0.01305115*G2_;
        A[45] = 0.00000000;
        A[46] = 0.00000000;
        A[47] = 0.00000000;
        A[48] = 0.00000000;
        A[49] = 0.00000000;
        A[50] = 0.00000000;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = 0.00000000;
        A[61] = 0.00000000;
        A[62] = 0.00000000;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.01305115*G3_;
        A[217] = 0.00246914*G3_;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.07901235*G3_;
        A[226] = -0.01693122*G3_;
        A[227] = 0.01128748*G3_;
        A[228] = 0.01305115*G2_;
        A[229] = 0.00000000;
        A[230] = 0.00246914*G2_;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.07901235*G2_;
        A[235] = -0.01693122*G2_;
        A[236] = 0.01128748*G2_;
        A[237] = 0.00000000;
        A[238] = 0.00000000;
        A[239] = 0.00000000;
        A[240] = -0.00767196*G3_;
        A[241] = -0.00767196*G3_;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = -0.01693122*G3_;
        A[250] = 0.08253968*G3_;
        A[251] = -0.01693122*G3_;
        A[252] = -0.00767196*G2_;
        A[253] = 0.00000000;
        A[254] = -0.00767196*G2_;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = -0.01693122*G2_;
        A[259] = 0.08253968*G2_;
        A[260] = -0.01693122*G2_;
        A[261] = 0.00000000;
        A[262] = 0.00000000;
        A[263] = 0.00000000;
        A[264] = 0.00246914*G3_;
        A[265] = 0.01305115*G3_;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.01128748*G3_;
        A[274] = -0.01693122*G3_;
        A[275] = 0.07901235*G3_;
        A[276] = 0.00246914*G2_;
        A[277] = 0.00000000;
        A[278] = 0.01305115*G2_;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.01128748*G2_;
        A[283] = -0.01693122*G2_;
        A[284] = 0.07901235*G2_;
        A[285] = 0.00000000;
        A[286] = 0.00000000;
        A[287] = 0.00000000;
        A[288] = 0.01287478*G1_;
        A[289] = -0.00127866*G1_;
        A[290] = 0.00000000;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.01305115*G1_;
        A[298] = -0.00767196*G1_;
        A[299] = 0.00246914*G1_;
        A[300] = 0.01287478*G0_;
        A[301] = 0.00000000;
        A[302] = -0.00127866*G0_;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.01305115*G0_;
        A[307] = -0.00767196*G0_;
        A[308] = 0.00246914*G0_;
        A[309] = 0.00000000;
        A[310] = 0.00000000;
        A[311] = 0.00000000;
        A[312] = 0.00000000;
        A[313] = 0.00000000;
        A[314] = 0.00000000;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00000000;
        A[322] = 0.00000000;
        A[323] = 0.00000000;
        A[324] = 0.00000000;
        A[325] = 0.00000000;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00000000;
        A[334] = 0.00000000;
        A[335] = 0.00000000;
        A[336] = -0.00127866*G1_;
        A[337] = 0.01287478*G1_;
        A[338] = 0.00000000;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00246914*G1_;
        A[346] = -0.00767196*G1_;
        A[347] = 0.01305115*G1_;
        A[348] = -0.00127866*G0_;
        A[349] = 0.00000000;
        A[350] = 0.01287478*G0_;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00246914*G0_;
        A[355] = -0.00767196*G0_;
        A[356] = 0.01305115*G0_;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.01305115*G1_;
        A[433] = 0.00246914*G1_;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.07901235*G1_;
        A[442] = -0.01693122*G1_;
        A[443] = 0.01128748*G1_;
        A[444] = 0.01305115*G0_;
        A[445] = 0.00000000;
        A[446] = 0.00246914*G0_;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.07901235*G0_;
        A[451] = -0.01693122*G0_;
        A[452] = 0.01128748*G0_;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = -0.00767196*G1_;
        A[457] = -0.00767196*G1_;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = -0.01693122*G1_;
        A[466] = 0.08253968*G1_;
        A[467] = -0.01693122*G1_;
        A[468] = -0.00767196*G0_;
        A[469] = 0.00000000;
        A[470] = -0.00767196*G0_;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = -0.01693122*G0_;
        A[475] = 0.08253968*G0_;
        A[476] = -0.01693122*G0_;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00246914*G1_;
        A[481] = 0.01305115*G1_;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.01128748*G1_;
        A[490] = -0.01693122*G1_;
        A[491] = 0.07901235*G1_;
        A[492] = 0.00246914*G0_;
        A[493] = 0.00000000;
        A[494] = 0.01305115*G0_;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.01128748*G0_;
        A[499] = -0.01693122*G0_;
        A[500] = 0.07901235*G0_;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.00000000;
        A[505] = 0.00000000;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.00000000;
        A[514] = 0.00000000;
        A[515] = 0.00000000;
        A[516] = 0.00000000;
        A[517] = 0.00000000;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.00000000;
        A[526] = 0.00000000;
        A[527] = 0.00000000;
        A[528] = 0.00000000;
        A[529] = 0.00000000;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = 0.00000000;
        A[538] = 0.00000000;
        A[539] = 0.00000000;
        A[540] = 0.00000000;
        A[541] = 0.00000000;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = 0.00000000;
        A[550] = 0.00000000;
        A[551] = 0.00000000;
        A[552] = 0.00000000;
        A[553] = 0.00000000;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.00000000;
        A[562] = 0.00000000;
        A[563] = 0.00000000;
        A[564] = 0.00000000;
        A[565] = 0.00000000;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.00000000;
        A[574] = 0.00000000;
        A[575] = 0.00000000;
          break;
        }
      case 2:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.00127866*G3_;
        A[2] = 0.00000000;
        A[3] = 0.00000000;
        A[4] = 0.00000000;
        A[5] = 0.00000000;
        A[6] = 0.00000000;
        A[7] = 0.00000000;
        A[8] = 0.00000000;
        A[9] = 0.01305115*G3_;
        A[10] = -0.00767196*G3_;
        A[11] = 0.00246914*G3_;
        A[12] = 0.01287478*G2_;
        A[13] = -0.00127866*G2_;
        A[14] = 0.00000000;
        A[15] = 0.00000000;
        A[16] = 0.00000000;
        A[17] = 0.00000000;
        A[18] = 0.00000000;
        A[19] = 0.00000000;
        A[20] = 0.00000000;
        A[21] = 0.01305115*G2_;
        A[22] = -0.00767196*G2_;
        A[23] = 0.00246914*G2_;
        A[24] = -0.00127866*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.00000000;
        A[27] = 0.00000000;
        A[28] = 0.00000000;
        A[29] = 0.00000000;
        A[30] = 0.00000000;
        A[31] = 0.00000000;
        A[32] = 0.00000000;
        A[33] = 0.00246914*G3_;
        A[34] = -0.00767196*G3_;
        A[35] = 0.01305115*G3_;
        A[36] = -0.00127866*G2_;
        A[37] = 0.01287478*G2_;
        A[38] = 0.00000000;
        A[39] = 0.00000000;
        A[40] = 0.00000000;
        A[41] = 0.00000000;
        A[42] = 0.00000000;
        A[43] = 0.00000000;
        A[44] = 0.00000000;
        A[45] = 0.00246914*G2_;
        A[46] = -0.00767196*G2_;
        A[47] = 0.01305115*G2_;
        A[48] = 0.00000000;
        A[49] = 0.00000000;
        A[50] = 0.00000000;
        A[51] = 0.00000000;
        A[52] = 0.00000000;
        A[53] = 0.00000000;
        A[54] = 0.00000000;
        A[55] = 0.00000000;
        A[56] = 0.00000000;
        A[57] = 0.00000000;
        A[58] = 0.00000000;
        A[59] = 0.00000000;
        A[60] = 0.00000000;
        A[61] = 0.00000000;
        A[62] = 0.00000000;
        A[63] = 0.00000000;
        A[64] = 0.00000000;
        A[65] = 0.00000000;
        A[66] = 0.00000000;
        A[67] = 0.00000000;
        A[68] = 0.00000000;
        A[69] = 0.00000000;
        A[70] = 0.00000000;
        A[71] = 0.00000000;
        A[72] = 0.00000000;
        A[73] = 0.00000000;
        A[74] = 0.00000000;
        A[75] = 0.00000000;
        A[76] = 0.00000000;
        A[77] = 0.00000000;
        A[78] = 0.00000000;
        A[79] = 0.00000000;
        A[80] = 0.00000000;
        A[81] = 0.00000000;
        A[82] = 0.00000000;
        A[83] = 0.00000000;
        A[84] = 0.00000000;
        A[85] = 0.00000000;
        A[86] = 0.00000000;
        A[87] = 0.00000000;
        A[88] = 0.00000000;
        A[89] = 0.00000000;
        A[90] = 0.00000000;
        A[91] = 0.00000000;
        A[92] = 0.00000000;
        A[93] = 0.00000000;
        A[94] = 0.00000000;
        A[95] = 0.00000000;
        A[96] = 0.00000000;
        A[97] = 0.00000000;
        A[98] = 0.00000000;
        A[99] = 0.00000000;
        A[100] = 0.00000000;
        A[101] = 0.00000000;
        A[102] = 0.00000000;
        A[103] = 0.00000000;
        A[104] = 0.00000000;
        A[105] = 0.00000000;
        A[106] = 0.00000000;
        A[107] = 0.00000000;
        A[108] = 0.00000000;
        A[109] = 0.00000000;
        A[110] = 0.00000000;
        A[111] = 0.00000000;
        A[112] = 0.00000000;
        A[113] = 0.00000000;
        A[114] = 0.00000000;
        A[115] = 0.00000000;
        A[116] = 0.00000000;
        A[117] = 0.00000000;
        A[118] = 0.00000000;
        A[119] = 0.00000000;
        A[120] = 0.00000000;
        A[121] = 0.00000000;
        A[122] = 0.00000000;
        A[123] = 0.00000000;
        A[124] = 0.00000000;
        A[125] = 0.00000000;
        A[126] = 0.00000000;
        A[127] = 0.00000000;
        A[128] = 0.00000000;
        A[129] = 0.00000000;
        A[130] = 0.00000000;
        A[131] = 0.00000000;
        A[132] = 0.00000000;
        A[133] = 0.00000000;
        A[134] = 0.00000000;
        A[135] = 0.00000000;
        A[136] = 0.00000000;
        A[137] = 0.00000000;
        A[138] = 0.00000000;
        A[139] = 0.00000000;
        A[140] = 0.00000000;
        A[141] = 0.00000000;
        A[142] = 0.00000000;
        A[143] = 0.00000000;
        A[144] = 0.00000000;
        A[145] = 0.00000000;
        A[146] = 0.00000000;
        A[147] = 0.00000000;
        A[148] = 0.00000000;
        A[149] = 0.00000000;
        A[150] = 0.00000000;
        A[151] = 0.00000000;
        A[152] = 0.00000000;
        A[153] = 0.00000000;
        A[154] = 0.00000000;
        A[155] = 0.00000000;
        A[156] = 0.00000000;
        A[157] = 0.00000000;
        A[158] = 0.00000000;
        A[159] = 0.00000000;
        A[160] = 0.00000000;
        A[161] = 0.00000000;
        A[162] = 0.00000000;
        A[163] = 0.00000000;
        A[164] = 0.00000000;
        A[165] = 0.00000000;
        A[166] = 0.00000000;
        A[167] = 0.00000000;
        A[168] = 0.00000000;
        A[169] = 0.00000000;
        A[170] = 0.00000000;
        A[171] = 0.00000000;
        A[172] = 0.00000000;
        A[173] = 0.00000000;
        A[174] = 0.00000000;
        A[175] = 0.00000000;
        A[176] = 0.00000000;
        A[177] = 0.00000000;
        A[178] = 0.00000000;
        A[179] = 0.00000000;
        A[180] = 0.00000000;
        A[181] = 0.00000000;
        A[182] = 0.00000000;
        A[183] = 0.00000000;
        A[184] = 0.00000000;
        A[185] = 0.00000000;
        A[186] = 0.00000000;
        A[187] = 0.00000000;
        A[188] = 0.00000000;
        A[189] = 0.00000000;
        A[190] = 0.00000000;
        A[191] = 0.00000000;
        A[192] = 0.00000000;
        A[193] = 0.00000000;
        A[194] = 0.00000000;
        A[195] = 0.00000000;
        A[196] = 0.00000000;
        A[197] = 0.00000000;
        A[198] = 0.00000000;
        A[199] = 0.00000000;
        A[200] = 0.00000000;
        A[201] = 0.00000000;
        A[202] = 0.00000000;
        A[203] = 0.00000000;
        A[204] = 0.00000000;
        A[205] = 0.00000000;
        A[206] = 0.00000000;
        A[207] = 0.00000000;
        A[208] = 0.00000000;
        A[209] = 0.00000000;
        A[210] = 0.00000000;
        A[211] = 0.00000000;
        A[212] = 0.00000000;
        A[213] = 0.00000000;
        A[214] = 0.00000000;
        A[215] = 0.00000000;
        A[216] = 0.01305115*G3_;
        A[217] = 0.00246914*G3_;
        A[218] = 0.00000000;
        A[219] = 0.00000000;
        A[220] = 0.00000000;
        A[221] = 0.00000000;
        A[222] = 0.00000000;
        A[223] = 0.00000000;
        A[224] = 0.00000000;
        A[225] = 0.07901235*G3_;
        A[226] = -0.01693122*G3_;
        A[227] = 0.01128748*G3_;
        A[228] = 0.01305115*G2_;
        A[229] = 0.00246914*G2_;
        A[230] = 0.00000000;
        A[231] = 0.00000000;
        A[232] = 0.00000000;
        A[233] = 0.00000000;
        A[234] = 0.00000000;
        A[235] = 0.00000000;
        A[236] = 0.00000000;
        A[237] = 0.07901235*G2_;
        A[238] = -0.01693122*G2_;
        A[239] = 0.01128748*G2_;
        A[240] = -0.00767196*G3_;
        A[241] = -0.00767196*G3_;
        A[242] = 0.00000000;
        A[243] = 0.00000000;
        A[244] = 0.00000000;
        A[245] = 0.00000000;
        A[246] = 0.00000000;
        A[247] = 0.00000000;
        A[248] = 0.00000000;
        A[249] = -0.01693122*G3_;
        A[250] = 0.08253968*G3_;
        A[251] = -0.01693122*G3_;
        A[252] = -0.00767196*G2_;
        A[253] = -0.00767196*G2_;
        A[254] = 0.00000000;
        A[255] = 0.00000000;
        A[256] = 0.00000000;
        A[257] = 0.00000000;
        A[258] = 0.00000000;
        A[259] = 0.00000000;
        A[260] = 0.00000000;
        A[261] = -0.01693122*G2_;
        A[262] = 0.08253968*G2_;
        A[263] = -0.01693122*G2_;
        A[264] = 0.00246914*G3_;
        A[265] = 0.01305115*G3_;
        A[266] = 0.00000000;
        A[267] = 0.00000000;
        A[268] = 0.00000000;
        A[269] = 0.00000000;
        A[270] = 0.00000000;
        A[271] = 0.00000000;
        A[272] = 0.00000000;
        A[273] = 0.01128748*G3_;
        A[274] = -0.01693122*G3_;
        A[275] = 0.07901235*G3_;
        A[276] = 0.00246914*G2_;
        A[277] = 0.01305115*G2_;
        A[278] = 0.00000000;
        A[279] = 0.00000000;
        A[280] = 0.00000000;
        A[281] = 0.00000000;
        A[282] = 0.00000000;
        A[283] = 0.00000000;
        A[284] = 0.00000000;
        A[285] = 0.01128748*G2_;
        A[286] = -0.01693122*G2_;
        A[287] = 0.07901235*G2_;
        A[288] = 0.01287478*G1_;
        A[289] = -0.00127866*G1_;
        A[290] = 0.00000000;
        A[291] = 0.00000000;
        A[292] = 0.00000000;
        A[293] = 0.00000000;
        A[294] = 0.00000000;
        A[295] = 0.00000000;
        A[296] = 0.00000000;
        A[297] = 0.01305115*G1_;
        A[298] = -0.00767196*G1_;
        A[299] = 0.00246914*G1_;
        A[300] = 0.01287478*G0_;
        A[301] = -0.00127866*G0_;
        A[302] = 0.00000000;
        A[303] = 0.00000000;
        A[304] = 0.00000000;
        A[305] = 0.00000000;
        A[306] = 0.00000000;
        A[307] = 0.00000000;
        A[308] = 0.00000000;
        A[309] = 0.01305115*G0_;
        A[310] = -0.00767196*G0_;
        A[311] = 0.00246914*G0_;
        A[312] = -0.00127866*G1_;
        A[313] = 0.01287478*G1_;
        A[314] = 0.00000000;
        A[315] = 0.00000000;
        A[316] = 0.00000000;
        A[317] = 0.00000000;
        A[318] = 0.00000000;
        A[319] = 0.00000000;
        A[320] = 0.00000000;
        A[321] = 0.00246914*G1_;
        A[322] = -0.00767196*G1_;
        A[323] = 0.01305115*G1_;
        A[324] = -0.00127866*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.00000000;
        A[327] = 0.00000000;
        A[328] = 0.00000000;
        A[329] = 0.00000000;
        A[330] = 0.00000000;
        A[331] = 0.00000000;
        A[332] = 0.00000000;
        A[333] = 0.00246914*G0_;
        A[334] = -0.00767196*G0_;
        A[335] = 0.01305115*G0_;
        A[336] = 0.00000000;
        A[337] = 0.00000000;
        A[338] = 0.00000000;
        A[339] = 0.00000000;
        A[340] = 0.00000000;
        A[341] = 0.00000000;
        A[342] = 0.00000000;
        A[343] = 0.00000000;
        A[344] = 0.00000000;
        A[345] = 0.00000000;
        A[346] = 0.00000000;
        A[347] = 0.00000000;
        A[348] = 0.00000000;
        A[349] = 0.00000000;
        A[350] = 0.00000000;
        A[351] = 0.00000000;
        A[352] = 0.00000000;
        A[353] = 0.00000000;
        A[354] = 0.00000000;
        A[355] = 0.00000000;
        A[356] = 0.00000000;
        A[357] = 0.00000000;
        A[358] = 0.00000000;
        A[359] = 0.00000000;
        A[360] = 0.00000000;
        A[361] = 0.00000000;
        A[362] = 0.00000000;
        A[363] = 0.00000000;
        A[364] = 0.00000000;
        A[365] = 0.00000000;
        A[366] = 0.00000000;
        A[367] = 0.00000000;
        A[368] = 0.00000000;
        A[369] = 0.00000000;
        A[370] = 0.00000000;
        A[371] = 0.00000000;
        A[372] = 0.00000000;
        A[373] = 0.00000000;
        A[374] = 0.00000000;
        A[375] = 0.00000000;
        A[376] = 0.00000000;
        A[377] = 0.00000000;
        A[378] = 0.00000000;
        A[379] = 0.00000000;
        A[380] = 0.00000000;
        A[381] = 0.00000000;
        A[382] = 0.00000000;
        A[383] = 0.00000000;
        A[384] = 0.00000000;
        A[385] = 0.00000000;
        A[386] = 0.00000000;
        A[387] = 0.00000000;
        A[388] = 0.00000000;
        A[389] = 0.00000000;
        A[390] = 0.00000000;
        A[391] = 0.00000000;
        A[392] = 0.00000000;
        A[393] = 0.00000000;
        A[394] = 0.00000000;
        A[395] = 0.00000000;
        A[396] = 0.00000000;
        A[397] = 0.00000000;
        A[398] = 0.00000000;
        A[399] = 0.00000000;
        A[400] = 0.00000000;
        A[401] = 0.00000000;
        A[402] = 0.00000000;
        A[403] = 0.00000000;
        A[404] = 0.00000000;
        A[405] = 0.00000000;
        A[406] = 0.00000000;
        A[407] = 0.00000000;
        A[408] = 0.00000000;
        A[409] = 0.00000000;
        A[410] = 0.00000000;
        A[411] = 0.00000000;
        A[412] = 0.00000000;
        A[413] = 0.00000000;
        A[414] = 0.00000000;
        A[415] = 0.00000000;
        A[416] = 0.00000000;
        A[417] = 0.00000000;
        A[418] = 0.00000000;
        A[419] = 0.00000000;
        A[420] = 0.00000000;
        A[421] = 0.00000000;
        A[422] = 0.00000000;
        A[423] = 0.00000000;
        A[424] = 0.00000000;
        A[425] = 0.00000000;
        A[426] = 0.00000000;
        A[427] = 0.00000000;
        A[428] = 0.00000000;
        A[429] = 0.00000000;
        A[430] = 0.00000000;
        A[431] = 0.00000000;
        A[432] = 0.00000000;
        A[433] = 0.00000000;
        A[434] = 0.00000000;
        A[435] = 0.00000000;
        A[436] = 0.00000000;
        A[437] = 0.00000000;
        A[438] = 0.00000000;
        A[439] = 0.00000000;
        A[440] = 0.00000000;
        A[441] = 0.00000000;
        A[442] = 0.00000000;
        A[443] = 0.00000000;
        A[444] = 0.00000000;
        A[445] = 0.00000000;
        A[446] = 0.00000000;
        A[447] = 0.00000000;
        A[448] = 0.00000000;
        A[449] = 0.00000000;
        A[450] = 0.00000000;
        A[451] = 0.00000000;
        A[452] = 0.00000000;
        A[453] = 0.00000000;
        A[454] = 0.00000000;
        A[455] = 0.00000000;
        A[456] = 0.00000000;
        A[457] = 0.00000000;
        A[458] = 0.00000000;
        A[459] = 0.00000000;
        A[460] = 0.00000000;
        A[461] = 0.00000000;
        A[462] = 0.00000000;
        A[463] = 0.00000000;
        A[464] = 0.00000000;
        A[465] = 0.00000000;
        A[466] = 0.00000000;
        A[467] = 0.00000000;
        A[468] = 0.00000000;
        A[469] = 0.00000000;
        A[470] = 0.00000000;
        A[471] = 0.00000000;
        A[472] = 0.00000000;
        A[473] = 0.00000000;
        A[474] = 0.00000000;
        A[475] = 0.00000000;
        A[476] = 0.00000000;
        A[477] = 0.00000000;
        A[478] = 0.00000000;
        A[479] = 0.00000000;
        A[480] = 0.00000000;
        A[481] = 0.00000000;
        A[482] = 0.00000000;
        A[483] = 0.00000000;
        A[484] = 0.00000000;
        A[485] = 0.00000000;
        A[486] = 0.00000000;
        A[487] = 0.00000000;
        A[488] = 0.00000000;
        A[489] = 0.00000000;
        A[490] = 0.00000000;
        A[491] = 0.00000000;
        A[492] = 0.00000000;
        A[493] = 0.00000000;
        A[494] = 0.00000000;
        A[495] = 0.00000000;
        A[496] = 0.00000000;
        A[497] = 0.00000000;
        A[498] = 0.00000000;
        A[499] = 0.00000000;
        A[500] = 0.00000000;
        A[501] = 0.00000000;
        A[502] = 0.00000000;
        A[503] = 0.00000000;
        A[504] = 0.01305115*G1_;
        A[505] = 0.00246914*G1_;
        A[506] = 0.00000000;
        A[507] = 0.00000000;
        A[508] = 0.00000000;
        A[509] = 0.00000000;
        A[510] = 0.00000000;
        A[511] = 0.00000000;
        A[512] = 0.00000000;
        A[513] = 0.07901235*G1_;
        A[514] = -0.01693122*G1_;
        A[515] = 0.01128748*G1_;
        A[516] = 0.01305115*G0_;
        A[517] = 0.00246914*G0_;
        A[518] = 0.00000000;
        A[519] = 0.00000000;
        A[520] = 0.00000000;
        A[521] = 0.00000000;
        A[522] = 0.00000000;
        A[523] = 0.00000000;
        A[524] = 0.00000000;
        A[525] = 0.07901235*G0_;
        A[526] = -0.01693122*G0_;
        A[527] = 0.01128748*G0_;
        A[528] = -0.00767196*G1_;
        A[529] = -0.00767196*G1_;
        A[530] = 0.00000000;
        A[531] = 0.00000000;
        A[532] = 0.00000000;
        A[533] = 0.00000000;
        A[534] = 0.00000000;
        A[535] = 0.00000000;
        A[536] = 0.00000000;
        A[537] = -0.01693122*G1_;
        A[538] = 0.08253968*G1_;
        A[539] = -0.01693122*G1_;
        A[540] = -0.00767196*G0_;
        A[541] = -0.00767196*G0_;
        A[542] = 0.00000000;
        A[543] = 0.00000000;
        A[544] = 0.00000000;
        A[545] = 0.00000000;
        A[546] = 0.00000000;
        A[547] = 0.00000000;
        A[548] = 0.00000000;
        A[549] = -0.01693122*G0_;
        A[550] = 0.08253968*G0_;
        A[551] = -0.01693122*G0_;
        A[552] = 0.00246914*G1_;
        A[553] = 0.01305115*G1_;
        A[554] = 0.00000000;
        A[555] = 0.00000000;
        A[556] = 0.00000000;
        A[557] = 0.00000000;
        A[558] = 0.00000000;
        A[559] = 0.00000000;
        A[560] = 0.00000000;
        A[561] = 0.01128748*G1_;
        A[562] = -0.01693122*G1_;
        A[563] = 0.07901235*G1_;
        A[564] = 0.00246914*G0_;
        A[565] = 0.01305115*G0_;
        A[566] = 0.00000000;
        A[567] = 0.00000000;
        A[568] = 0.00000000;
        A[569] = 0.00000000;
        A[570] = 0.00000000;
        A[571] = 0.00000000;
        A[572] = 0.00000000;
        A[573] = 0.01128748*G0_;
        A[574] = -0.01693122*G0_;
        A[575] = 0.07901235*G0_;
          break;
        }
      }
      
        break;
      }
    }
    
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class restrictedelement_form_0: public ufc::form
{
public:

  /// Constructor
  restrictedelement_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 0)), PositiveRestricted(Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 0)))), Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 1)), PositiveRestricted(Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 1))))), Measure('interior_facet', 0, None)), Integral(Product(Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 0), Argument(RestrictedElement(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 4), Cell('interval', 1, Space(1))), 1)), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 0;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 1;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 1;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_finite_element_0();
        break;
      }
    case 1:
      {
        return new restrictedelement_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_dof_map_0();
        break;
      }
    case 1:
      {
        return new restrictedelement_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_exterior_facet_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_interior_facet_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

};

#endif
