/* keyboard.c  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for handling keyboard events  */ 
/*
 * $Log: stk_keyboard.c,v $
 * Revision 1.2  2000/12/06 20:56:06  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.7  2000/02/21 03:33:50  moz
 * Removed debugging printf.
 *
 * Revision 1.6  2000/02/21 03:15:55  moz
 * Cleanup.
 * Menus swallow keypresses.
 *
 * Revision 1.5  2000/01/28 15:59:28  moz
 * Hopefully checking isprint() will not allow control chars.
 *
 * Revision 1.4  1999/08/08 20:55:30  moz
 * From clean up of structs.
 *
 * Revision 1.3  1999/05/20 03:22:33  moz
 * Fixes for control codes.
 *
 * Revision 1.2  1999/05/19 17:07:13  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:06:42  moz
 * Initial revision
 *
 */    

#include <X11/keysym.h> 
#include <string.h> 
#include <ctype.h> 
#include "include/stk_internal.h" 
#include "include/stk.h"
#include "include/stk_extern.h" 
 
int str_print(char *str);

int str_print(char *str)
{
	while (*str!='\0')
		{
		if (!isprint(*str))
			return FALSE;
		str++;		
		};

	return TRUE; 

}

Boolean 
stk_keyboard(XKeyPressedEvent *report)
{
	List l;
	stkInternalDialog *d=NULL; 
	stkInternalDialogTextEntry *t; 
	char str[50];
	int num=0; 
	KeySym keysym; 
	XEvent xmess;

	l = where_in_list(stk_window_list,report->window);

	/* regardless of target window, attempt to locate dialog  */  
	switch (l->type)
		{
		case DIALOG_TITLE_TYPE:
			d = DIALOGTITLE(l)->dialog;
			break;
		case DIALOG_TEXT_LIST_TYPE:
			d = TEXTLIST(l)->dialog;
			break;
		case DIALOG_TEXT_SLIDER_TYPE:
			d = SLIDER(l)->dialog;
			break;
		case DIALOG_TEXT_ENTRY_TYPE:
		case DIALOG_TEXT_ENTRY_ENTRY_TYPE:
			d = TEXTENTRY(l)->dialog;
			break;
		case DIALOG_TYPE:
			d = DIALOG(l);
			break;
		case BUTTON_TYPE:
			d = BUTTON(l)->dialog;
			break; 
		case DIALOG_CHOICE_TYPE:
			d = CHOICE(l)->dialog;
			break;
		case DIALOG_RADIO_CHOICE_TYPE:
			d = RCHOICE(l)->dialog;
			break;
		case DIALOG_VSLIDER_TYPE:
			d = VSLIDER(l)->dialog;
			break;
		case TOOL_WINDOW_TYPE: 
			return TRUE;
			break;
		case MENU_ICON_TYPE:
		case ICON_MENU_TYPE: 
		case MENU_TYPE:
			/* menus swallow grabbed keyboard events */ 
			return TRUE;
			break;
		};

	num = XLookupString(report,str,sizeof(str), &keysym, NULL);

	str[num]='\0'; 
	 
	if (d==NULL)
		return FALSE;

	/* return is equivalent to default button press  */  
	if (keysym==XK_Return && d!=NULL && d->defaultbutton!=NULL)
		{
		/* notify client program */
		xmess.xclient.type = ClientMessage;
		xmess.xclient.window = d->defaultbutton->window.win;
		xmess.xclient.message_type = STK_DIALOG_BUTTON_CLICKED;
		xmess.xclient.format = 32;
		/* first long contains (ulong)window of parent dialog */
		xmess.xclient.data.l[0] = (ulong)d->window.win;
		/* second long contains call value  */
		xmess.xclient.data.l[1] = (ulong)d->call; 
		XSendEvent(stk_display, d->defaultbutton->window.win, False, 0, &xmess);  
		return TRUE;
		};
					 
	/* tab to next text window  */ 
	if (d!=NULL && keysym==XK_Tab)
		{
		if (d->focus==NULL)
			{
			l = d->items;
			while (l!=NULL)
				{
				if (l->type==DIALOG_TEXT_ENTRY_TYPE)
					{
					d->focus = TEXTENTRY(l);
					TEXTENTRY(l)->charpos = 0;
					TEXTENTRY(l)->pos_x = 5;
					stk_redraw_dialog_text_entry_entry(TEXTENTRY(l));
					break;
					}; 
				l = l->next;
				};
			}
		else
			{
			void *f=d->focus;
			Boolean flag=FALSE; 

			d->focus->charpos = -1;
			stk_redraw_dialog_text_entry_entry(d->focus);
			 
			l = d->items;
			while (l!=NULL)
				{
				if (l->type==DIALOG_TEXT_ENTRY_TYPE)
					{ 
					if (flag)
						{
						d->focus = TEXTENTRY(l);
						TEXTENTRY(l)->charpos = 0;
						TEXTENTRY(l)->pos_x = 5;
						stk_redraw_dialog_text_entry_entry(TEXTENTRY(l));
						flag = FALSE; 
						}
					else if (l->data == f)
						flag = TRUE; 
					};

				l = l->next;
				};
				 
			if (flag)
				d->focus = NULL;
			}; 

		return TRUE;
		};
		 
	/* handle text editing with BS/DEL etc.  */ 
	if (d==NULL || d->focus==NULL)  
		return TRUE;

	t = d->focus;
			 
	if (!streq("", str) && str_print(str))
		{
		char a[200];

		strncpy(a,t->contents,(size_t)t->charpos);
		a[t->charpos] = '\0';
		strncat(a,str,100);
		strcat(a,t->contents+t->charpos);
		t->charpos+=strlen(str);
		strcpy(t->contents,a);
		t->pos_x = 5 + XTextWidth(stk_font,t->contents,t->charpos);
		stk_redraw_dialog_text_entry_entry(t);
		}
	else
		{
		/* not printable result, look for any special characters we may be interested in */ 
		switch (keysym)
			{
			case XK_Delete:
				if (((uint)t->charpos)<strlen(t->contents))
					{
					char a[200];

					strncpy(a,t->contents,(size_t)t->charpos);
					a[t->charpos] = '\0';
					strcat(a,t->contents+t->charpos+1);
					strcpy(t->contents,a);
					stk_redraw_dialog_text_entry_entry(t);
					};
				break;

			case XK_BackSpace:
				if (t->charpos>0)
					{
					char a[200];

					strncpy(a,t->contents,(size_t)(t->charpos-1));
					a[t->charpos-1]= '\0'; 
					strcat(a,t->contents+t->charpos);
					strcpy(t->contents,a);
					t->charpos--;
					t->pos_x = 5 + XTextWidth(stk_font, t->contents, t->charpos); 
					stk_redraw_dialog_text_entry_entry(t);
					};
				break;

			case XK_Left:
				if (t->charpos>0)
					{
					t->charpos--;
					t->pos_x = 5 + XTextWidth(stk_font, t->contents, t->charpos);
					stk_redraw_dialog_text_entry_entry(t);
					};
				break;

			case XK_Right:
				if (((uint)t->charpos)<strlen(t->contents))
					{
					t->charpos++;
					t->pos_x = 5 + XTextWidth(stk_font, t->contents, t->charpos);
					stk_redraw_dialog_text_entry_entry(t);
					};
				break;

			default:
				break;
			}; 
		};
	
	return TRUE; 
} 

 
