/* Functions used in STK */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_util.c,v $
 * Revision 1.2  2000/12/06 20:56:06  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/08 01:07:36  moz
 * Compile fixes.
 *
 * Revision 1.10  2000/02/18 02:17:52  moz
 * Compile fixes.
 *
 * Revision 1.9  2000/01/25 01:37:13  moz
 * Removed border setting.
 *
 * Revision 1.8  1999/11/15 23:04:16  moz
 * No change.
 *
 * Revision 1.7  1999/11/15 02:03:13  moz
 * Always set window border to 0.
 * Set window group hint.
 *
 * Revision 1.6  1999/07/04 15:02:20  moz
 * Removed extraneous gettimeofday (not used any more).
 *
 * Revision 1.5  1999/06/16 00:57:37  moz
 * New stk_unmap_tooltip() global function.
 *
 * Revision 1.4  1999/05/19 17:06:58  moz
 * 1.0 Checkin.
 *
 * Revision 1.3  1999/05/04 19:46:42  moz
 * Tooltip redraw fix.
 *
 * Revision 1.2  1999/04/27 21:15:04  moz
 * New stk_tooltips function to set/reset tooltips_on status.
 *
 * Revision 1.1  1999/03/30 00:06:56  moz
 * Initial revision
 *
 */    

#include <time.h> 
#include <string.h> 
#include <stdio.h> 
#include "include/stk_internal.h" 
#include "include/stk_extern.h"
#include "include/stk.h"

extern Atom windelete;

/* client-side toggle tooltips  */  
void
stk_tooltips(Boolean on)
{
	stk_tooltips_on = on;

	if (!stk_tooltips_on)
		XUnmapWindow(stk_display,tooltip_window->win);
}

inline void
stk_unmap_tooltip()
{
	if (tooltip_on)
		{ 
		XUnmapWindow(stk_display,tooltip_window->win);
		tooltip_on = FALSE;
		}; 
}
 
/* update tooltip window  */  
void 
stk_tooltip(Window w, Boolean change)
{
	Bool en=0;
	Window w1,w2;
	static char legend[30]; 
	int x1,y1,x2,y2;
	unsigned int d1; 

	if (!stk_tooltips_on)
		return;

	en = QLength(stk_display);

	if (en!=0)
		return;

	if (en==0 || tooltip_on)
		{
		List l;

		l = where_in_list(stk_window_list, (ulong)w);

		switch (l->type)
			{
			case ICON_TYPE:
			case MENU_ICON_TYPE: 
				if (!streq(ICON(l)->tooltip,""))
					{
					XClearWindow(stk_display,tooltip_window->win);
					XQueryPointer(stk_display, w, &w1, &w2, &x1, &y1, &x2, &y2, &d1);
					tooltip_window->x = x1 + 20;
					tooltip_window->y = y1 + 20; 
					if (change || !tooltip_on)
						{ 
						strncpy(legend,ICON(l)->tooltip,30); 
						tooltip_window->w = 10 
							+ XTextWidth(stk_font,legend,(signed)strlen(legend));
						tooltip_window->h = 6 
							+ stk_font->max_bounds.ascent 
							+ stk_font->max_bounds.descent;
						}; 
					XMoveResizeWindow(stk_display,tooltip_window->win, 
						tooltip_window->x,  tooltip_window->y,
						tooltip_window->w, tooltip_window->h);
					XRaiseWindow(stk_display,tooltip_window->win);
					if (!tooltip_on)
						{ 
						tooltip_on = TRUE;
						XMapWindow(stk_display,tooltip_window->win); 
						};
					stk_thin_outline(tooltip_window, 0, 0, tooltip_window->w, tooltip_window->h);
					SET_CLIP_WINDOW(fontgc,tooltip_window); 
					XDrawString(stk_display,tooltip_window->win, 
						fontgc, 5, 3 + stk_font->max_bounds.ascent, 
						legend, (signed)strlen(legend));
					}; 
				break;
			};
		};
		 
}

/* create a standard stk window  */  
/* override indicates an override_redirect window  */  
 
Boolean 
stk_create_window(WindowStruct *window, Window parent, uint type, void *data, Boolean override)
{
	XGCValues gcvalues; 
	List templ; 
	XSetWindowAttributes attr;
	
	XGetGCValues(stk_display, backgroundgc, (GCForeground | GCBackground), &gcvalues);  

	window->win = XCreateSimpleWindow(stk_display, parent,
					window->x,window->y,window->w,window->h,
					0, gcvalues.foreground, gcvalues.background );
	 
	if (override)
		{
		attr.override_redirect = TRUE;
		XChangeWindowAttributes(stk_display, window->win, CWOverrideRedirect, &attr);
		};
	
	if (parent==RootWindow(stk_display,DefaultScreen(stk_display)))
		XSetWMProtocols(stk_display,window->win, &windelete, 1);
		 
	XSelectInput(stk_display, window->win, KeyPressMask | ButtonPressMask 
					 | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask
					 | PointerMotionMask | ButtonMotionMask
					 | StructureNotifyMask | SubstructureNotifyMask
					 | ExposureMask | StructureNotifyMask | FocusChangeMask);

	XMoveResizeWindow(stk_display, window->win, window->x, window->y, window->w, window->h); 
	 
	templ = add_to_list(stk_window_list,(ulong)window->win,type,data);  
	 
	if (templ==NULL)
		return FALSE;
	
	stk_window_list = templ;
	  
	return TRUE;  
}

