% fireqos-match(5) FireQOS Reference | VERSION
% FireHOL Team
% Built DATE

# NAME

fireqos-match - QOS traffic match

# SYNOPSIS

{match|match4|match6|match46} *optional-match-params*

<!--
extra-manpage: fireqos-match46.5
extra-manpage: fireqos-match4.5
extra-manpage: fireqos-match6.5
  -->

# DESCRIPTION


Writing `match` inherits the IPv4/IPv6 version from its enclosing class
(see [fireqos-class(5)][keyword-fireqos-class-definition]).

Writing `match4` includes only IPv4 traffic in the match.

Writing `match6` includes only IPv6 traffic in the match.

Writing `match46` includes both IPv4 and IPv6 traffic in the match.

You can add as many `match` statements as you like to a FireQOS
configuration. They assign traffic to a class: by default to the
class after which they are declared.

The sequence that matches appear in the configuration defines their
priority, with the first match being given a `prio` of 10, with 10 added
for each subsequent match (10, 20, 30, ...).

Matches can have their priority assigned explicitly with the `prio`
parameter. See [fireqos-params-match(5)][keyword-fireqos-prio-match].

If one `match` statement generates multiple tc(8) `filter` statements, all
filters generated by the same `match` statement will have the same
`prio`.

> **Note**
>
> `match` rules are attached to the parent of the `class` they appear
> in. Within the configuration they are written under a class, but in
> reality they are attached to their class parent, so that they classify
> the parent's traffic that they match, into the class.

It is also possible to group all `match` statements together below the
classes. This allows them to be arranged in preferred order, without the
need for any explicit `prio` parameters. In this case however, each
match statement must specify to which class it classifies the packets it
matches, using the `class` parameter. See
[fireqos-params-match(5)][keyword-fireqos-class-param] and the examples below.

You can also write `client` and `server` statements, much like FireHOL
allows, with the same service definitions. For FireQOS however, the client
ports are ignored. `server` statements match the server ports on this linux
side, while `client` statements match the server ports on the remote side.

Example:

~~~~
    server_myrtp_ports="10000:10100"

    interface eth0 lan bidirectional rate 1Gbit
      class voip
        server sip
        client sip
        
        server myrtp

      class dns
        server dns

      class mail
        server smtp
~~~~

# PARAMETERS

*optional-match-params*
:   The set of optional parameters which describe this match.
    See [fireqos-params-match(5)][].

# EXAMPLES

Match traffic within classes:

~~~~
    interface eth0 lan output rate 1Gbit
      class voip
        match udp ports 5060,10000:10100
      class dns
        match udp port 53
      class mail
        match tcp port 25
~~~~

Matches split out and explicitly assigning traffic to classes (N.B.
without the `class` parameters, all traffic would be classified into
'mail'):

~~~~
    interface eth0 lan output rate 1Gbit
      class voip
      class dns
      class mail

      match udp ports 5060,10000:10100 class voip
      match tcp port 25 class mail
      match tcp port 80 class web
~~~~

# SEE ALSO

* [fireqos-params-match(5)][] - QOS match parameters
* [fireqos(1)][] - FireQOS program
* [fireqos.conf(5)][] - FireQOS configuration file
* [fireqos-interface(5)][keyword-fireqos-interface] - QOS interface definition
* [fireqos-class(5)][keyword-fireqos-class-definition] - QOS class definition
* [FireHOL Website](http://firehol.org/)
* [FireQOS Online PDF Manual](http://firehol.org/fireqos-manual.pdf)
* [FireQOS Online Documentation](http://firehol.org/documentation/)
* [tc(8)](http://lartc.org/manpages/tc.html) - show / manipulate traffic control settings
