/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

void sigint_caught_ALSA ( ) {
	
	printf ( "*** sample_alsa_pcm: Caught SIGINT, terminating ***\n" );
	snd_pcm_close ( capture_handle );
	exit ( EXIT_SUCCESS );
}

void sample_alsa_pcm ( char *device, int fd, int buf_size, unsigned int rate ) {
	
	int err;
	char *buf;
	snd_pcm_hw_params_t *hw_params;
	int channels = 2;

	signal ( SIGINT, sigint_caught_ALSA );

	fprintf ( stdout, "II sample_alsa_pcm: successfully forked\n" );
	
	buf = malloc ( buf_size );

	if ( ( err = snd_pcm_open ( &capture_handle, device, SND_PCM_STREAM_CAPTURE, 0 ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot open audio device %s ( %s )\n", device, snd_strerror ( err ) );
		exit ( EXIT_FAILURE );
	}
	if ( ( err = snd_pcm_hw_params_malloc ( &hw_params ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot allocate hardware parameter structure ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params_any ( capture_handle, hw_params ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot initialize hardware parameter structure ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params_set_access ( capture_handle, hw_params, SND_PCM_ACCESS_RW_INTERLEAVED ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot set access type ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params_set_format ( capture_handle, hw_params, SND_PCM_FORMAT_S16_LE ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot set sample format ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params_set_rate_near ( capture_handle, hw_params, &rate, 0 ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot set sample rate ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params_set_channels ( capture_handle, hw_params, channels ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot set channel count ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	if ( ( err = snd_pcm_hw_params ( capture_handle, hw_params ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot set parameters ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	snd_pcm_hw_params_free ( hw_params );
	if ( ( err = snd_pcm_prepare ( capture_handle ) ) < 0 ) {
		fprintf ( stderr, "EE sample_alsa_pcm: cannot prepare audio interface for use ( %s )\n", snd_strerror ( err ) );
		exit ( 1 );
	}
	
	fprintf ( stdout, "II sample_alsa_pcm: sampling\n" );
	while ( 1 ) {
		again:
		if ( ( err = snd_pcm_readi ( capture_handle, buf, XRes ) ) != ( XRes ) ) {
			if ( err == -EAGAIN ) {
				usleep ( 10000 );
				goto again;
			}
			if ( err == -EPIPE ) {
				snd_pcm_prepare ( capture_handle );
				goto again;
			}
		}
		if ( err == ( XRes ) ){
			write ( fd, buf, buf_size );
		}	
	}
	return;
}
