/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.1
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.1 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.1 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

class Configuration
{
	public:
		Configuration(int, char**);
		~Configuration();
		enum{ALSA, PULSE};
		int fpsTarget();
		const char* device();
		int X();
		int Y();
		int screenX();
		int screenY();
		bool fullscreen();
		bool multiThreaded();
		bool exitOnMouse();
		bool predictiveBeat();
		void togglePredictiveBeat();
		void toggleFullscreen();
		int audioDriver()
		{
			return __audioDriver;
		}
		
	private:
		const char* __alsaDevice;
		int __vecX;
		int __vecY;
		int __virtX;
		int __virtY;
		bool __fs;
		int __fps;
		bool __MT;
		bool __eom;
		bool __predictive;
		int __audioDriver;
		bool __writeConfig;
		void help();
		void set_geometry(char*);
		void set_virtual(char*);
		void set_device(char*);
		void set_driver(char*);
		void set_fullscreen(char*);
		void set_fps(char*);
		void set_single(char*);
		void set_predictive(char*);
		void set_eom(char*);
		void read_configfile();
		bool __eom_in_cfile, __pred_in_cfile, __single_in_cfile;
		void write_configfile();

};

#endif // CONFIGURATION_H
