#!/bin/bash

# Funcao para verificar se os programas a serem utilizados
# se encontram em PATH
esta_instalado(){
    prog=$1
    echo "Verificando se $prog est instalado ..."
    for caminho in ${PATH//:/ }
        do
            if [ -x "$caminho/$prog" ]; then
	        echo "     OK"
                return 0
            fi
        done
    echo "     $prog no foi encontrado"
    return 1
}

# saida do mario_fortunes -- deve ser usada no lugar de exit
mf_exit(){
    rm -f $ERRO
    rm -f $OPT
    rm -f $TMP
    exit $1
}

# Saida sem erro
saida(){
    $DIALOG --clear
    $DIALOG --msgbox "A instalao NO foi concluda com sucesso." 24 80
    $DIALOG --clear
    mf_exit 1
}

# Saida por causa de erro
saida_por_erro(){
    $DIALOG --clear
    $DIALOG --msgbox "Ocorreu um erro.\n\nA instalao NO foi concluda com sucesso.\n\n$1" 24 80
    $DIALOG --clear
    mf_exit 1
}

if esta_instalado Xdialog && [ ! -z $DISPLAY ]
then
    DIALOG=Xdialog
else
    esta_instalado dialog ||  mf_exit 1
    DIALOG=dialog
fi

[ $DIALOG = Xdialog ] && ALIGN="--left"

TMP=/tmp/mario_fortunes
OPT=/tmp/opt
ERRO=/tmp/erro

# Verifica se os programas utilizados no instalador estao
# disponiveis
esta_instalado gawk || esta_instalado awk || mf_exit 1
esta_instalado grep || mf_exit 1
esta_instalado strfile || mf_exit 1
esta_instalado fortune || mf_exit 1

# Verifica se e' possivel escrever em /tmp
touch $TMP || {
      echo "Nao e' possivel criar $TMP"
      mf_exit 1
}


#Iniciando a interface com o usuario
$DIALOG --msgbox "`cat Descricao`" 24 80

# Verifica onde o fortune le^ os arquivos de frases
DIRS=`fortune -f 2>&1 |grep "/"| gawk '{print $2}'`

CAMINHOS=""
CONT=0

for CAMINHO in $DIRS
do
    CAMINHOS="$CAMINHOS $(( $CONT + 1)) $CAMINHO"
    CONT=$(( $CONT + 1 ))
done
CAMINHOS="$CAMINHOS $(( $CONT + 1 )) Outro"

$DIALOG --menu "Escolha o diretrio para instalar o arquivo de frases" \
        24 80 15 \
        $CAMINHOS 2> $TMP

[ -z `cat $TMP` ] && saida

$DIALOG --clear

# Se o usuario prefere outro diretorio que nao um dos apresentados,
# deve-se deixar que ele digite um caminho
if [ `cat $TMP` = `expr $CONT + 1` ] 
then
    cat /dev/null > $TMP
    $DIALOG --inputbox \
       "Digite o diretrio para instalar o arquivo de frases" \
       24 80 2> $TMP
       echo -e "\ndigitou" >> $TMP
fi

[ -z `head -n1 $TMP` ] && saida_por_erro "Voc deve especificar o diretrio onde quer instalar o mario_fortunes."


# Se foi escolhido um dos caminhos sugeridos, coloca-se ele em $TMP
# Essa volta toda e' necessaria porque o dialog retorna a primeira
# coluna do menu (um numero) e queremos a segunda (caminho)
CONT=$(( $CONT * 2 ))
if [ ! `tail -n1 $TMP` = digitou ]
then
    echo $CAMINHOS | awk '{print $'$CONT'}' > $TMP
else
    CAMINHO=`head -n1 $TMP`
    echo $CAMINHO > $TMP
fi
    

# Se o diretorio nao existe, da'-se um jeito
[ -d `cat $TMP` ] || {
    $DIALOG --clear
    $DIALOG --menu "O diretrio especificado no existe. Deseja cri-lo?" \
	    24 80 15 \
	    1 Sim \
	    2 Nao \
	    2> $OPT

    [ -z `cat $OPT` ] && saida

    if [ `cat $OPT` = 1 ]
    then
	mkdir -p `cat $TMP` 2> $ERRO || saida_por_erro "`cat $ERRO`"
    else 
	saida
    fi
}

# Gerando o mario.fortunes.dat e copiando para o diretorio destino
DIR=`cat $TMP`
strfile mario.fortunes 2> $ERRO || saida_por_erro "`cat $ERRO`"
cp -f mario.fortunes mario.fortunes.dat $DIR 2> $ERRO || saida_por_erro "`cat $ERRO`"

# Mensagens finais
$DIALOG --clear
$DIALOG --msgbox "A instalao do mario_fortunes foi concluda com sucesso.\n\nVeja o arquivo DICAS para obter idias de como usar o mario_fortunes.\n\nSugestes de frases podem ser enviadas para mario@proxy.furg.br." 24 80

$DIALOG $ALIGN --msgbox "mario_fortunes\n\n`fortune $DIR/mario.fortunes`" 24 80

# Tchau
mf_exit 0


