/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/**
 * Maintains variables stored along with the game.
 * 
 * @deprecated This class will be replaced in the Trunk (0.8.0) version
 *      with a completely different system for storing variables.
 */
public class GameVariables {
    private static final Logger logger = Logger.getLogger(GameVariables.class.getName());
    
    public static final String TUTORIAL_BUILD_COLONY = "tutorialBuildColony",
                               TUTORIAL_COLONY_TILE  = "tutorialColonyTile",
                               TUTORIAL_COLONY_WORKLOCATIONS = "tutorialColonyWorkLocations",
                               TUTORIAL_EXPLORE_WITH_SHIP = "tutorialExploreWithShip",
                               TUTORIAL_SECOND_COLONIST = "tutorialSecondColonist",
                               TUTORIAL_EQUIP_COLONIST = "tutorialEquipColonist",
                               TUTORIAL_PIONEER = "tutorialPioneer",
                               TUTORIAL_LOAD_GOODS = "tutorialLoadGoods",
                               TUTORIAL_SELL_GOODS = "tutorialSellGoods",
                               TUTORIAL_EUROPE = "tutorialEurope",
                               TUTORIAL_EUROPE_PANEL = "tutorialEuropePanel",
                               TUTORIAL_BUILDINGS = "tutorialBuildings",
                               TUTORIAL_TOWN_HALL = "tutorialTownHall";

    private Map<String, Boolean> variables;
    
    
    public GameVariables() {
        variables = new HashMap<String, Boolean>();
    }
    
    public GameVariables(XMLStreamReader in) throws XMLStreamException {
        this();
        
        readFromXML(in);
    }
    
    
    /**
     * Gets a boolean value stored using the given id.
     * 
     * @param id The ID of the boolean value we should retrive.
     * @return The value.
     */
    public boolean getBoolean(String id) {
        Boolean b = variables.get(id);
        if (b == null) {
            return true;
        } else {
            return b.booleanValue();
        }
    }
    
    /**
     * Sets a boolean value using the given id.
     * 
     * @param id The ID.
     * @param value The value.
     */
    public void setBoolean(String id, boolean value) {
        variables.put(id, new Boolean(value));
    }
    
    /**
     * This method writes an XML-representation of this object to
     * the given stream.
     *  
     * @param out The target stream.
     * @throws XMLStreamException if there are any problems writing
     *      to the stream.
     */
    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(getXMLElementTagName());

        for (String key : variables.keySet()) {
            out.writeStartElement("variable");
            out.writeAttribute("key", key);
            out.writeAttribute("value", variables.get(key).toString());
            out.writeEndElement();
        }

        out.writeEndElement();
    }

    /**
     * Initializes this object from an XML-representation of this object.
     * 
     * @param in The input stream with the XML.
     * @throws XMLStreamException if there are any problems writing to the
     *      stream.
     */
    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        variables.clear();
        while (in.nextTag() != XMLStreamConstants.END_ELEMENT) {
            if (in.getLocalName().equals("variable")) {
                final String key = in.getAttributeValue(null, "key");
                final String value = in.getAttributeValue(null, "value");
                variables.put(key, Boolean.parseBoolean(value));
                in.nextTag();
            } else {
                logger.warning("Unknown tag: " + in.getLocalName());
            }
        }
    }
    
    /**
     * Gets the tag name of the root element representing this object.
     * @return "gameOptions".
     */
    public static String getXMLElementTagName() {
        return "gameVariables";
    }
}
