'''OpenGL extension VERSION.GL_3_3

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_3_3 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_3_3.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_3_3 import *
from OpenGL.raw.GL.VERSION.GL_3_3 import _EXTENSION_NAME

def glInitGl33VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glGenSamplers=wrapper.wrapper(glGenSamplers).setOutput(
    'samplers',size=lambda x:(x,),pnameArg='count',orPassIn=True
)
# INPUT glDeleteSamplers.samplers size not checked against count
glDeleteSamplers=wrapper.wrapper(glDeleteSamplers).setInputArraySize(
    'samplers', None
)
# INPUT glSamplerParameteriv.param size not checked against 'pname'
glSamplerParameteriv=wrapper.wrapper(glSamplerParameteriv).setInputArraySize(
    'param', None
)
# INPUT glSamplerParameterfv.param size not checked against 'pname'
glSamplerParameterfv=wrapper.wrapper(glSamplerParameterfv).setInputArraySize(
    'param', None
)
# INPUT glSamplerParameterIiv.param size not checked against 'pname'
glSamplerParameterIiv=wrapper.wrapper(glSamplerParameterIiv).setInputArraySize(
    'param', None
)
# INPUT glSamplerParameterIuiv.param size not checked against 'pname'
glSamplerParameterIuiv=wrapper.wrapper(glSamplerParameterIuiv).setInputArraySize(
    'param', None
)
glGetSamplerParameteriv=wrapper.wrapper(glGetSamplerParameteriv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetSamplerParameterIiv=wrapper.wrapper(glGetSamplerParameterIiv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetSamplerParameterfv=wrapper.wrapper(glGetSamplerParameterfv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetSamplerParameterIuiv=wrapper.wrapper(glGetSamplerParameterIuiv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetQueryObjecti64v=wrapper.wrapper(glGetQueryObjecti64v).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetQueryObjectui64v=wrapper.wrapper(glGetQueryObjectui64v).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glVertexAttribP1uiv=wrapper.wrapper(glVertexAttribP1uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP2uiv=wrapper.wrapper(glVertexAttribP2uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP3uiv=wrapper.wrapper(glVertexAttribP3uiv).setInputArraySize(
    'value', 1
)
glVertexAttribP4uiv=wrapper.wrapper(glVertexAttribP4uiv).setInputArraySize(
    'value', 1
)
glVertexP2uiv=wrapper.wrapper(glVertexP2uiv).setInputArraySize(
    'value', 1
)
glVertexP3uiv=wrapper.wrapper(glVertexP3uiv).setInputArraySize(
    'value', 1
)
glVertexP4uiv=wrapper.wrapper(glVertexP4uiv).setInputArraySize(
    'value', 1
)
glTexCoordP1uiv=wrapper.wrapper(glTexCoordP1uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP2uiv=wrapper.wrapper(glTexCoordP2uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP3uiv=wrapper.wrapper(glTexCoordP3uiv).setInputArraySize(
    'coords', 1
)
glTexCoordP4uiv=wrapper.wrapper(glTexCoordP4uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP1uiv=wrapper.wrapper(glMultiTexCoordP1uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP2uiv=wrapper.wrapper(glMultiTexCoordP2uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP3uiv=wrapper.wrapper(glMultiTexCoordP3uiv).setInputArraySize(
    'coords', 1
)
glMultiTexCoordP4uiv=wrapper.wrapper(glMultiTexCoordP4uiv).setInputArraySize(
    'coords', 1
)
glNormalP3uiv=wrapper.wrapper(glNormalP3uiv).setInputArraySize(
    'coords', 1
)
glColorP3uiv=wrapper.wrapper(glColorP3uiv).setInputArraySize(
    'color', 1
)
glColorP4uiv=wrapper.wrapper(glColorP4uiv).setInputArraySize(
    'color', 1
)
glSecondaryColorP3uiv=wrapper.wrapper(glSecondaryColorP3uiv).setInputArraySize(
    'color', 1
)
### END AUTOGENERATED SECTION
from OpenGL.GL.ARB.texture_multisample import *
from OpenGL.GL.ARB.blend_func_extended import *
from OpenGL.GL.ARB.sampler_objects import *
from OpenGL.GL.ARB.explicit_attrib_location import *
from OpenGL.GL.ARB.occlusion_query2 import *
from OpenGL.GL.ARB.shader_bit_encoding import *
from OpenGL.GL.ARB.texture_rgb10_a2ui import *
from OpenGL.GL.ARB.texture_swizzle import *
from OpenGL.GL.ARB.timer_query import *
from OpenGL.GL.ARB.vertex_type_2_10_10_10_rev import *
