/*  Gaby
 *  Copyright (C) 1998-1999 Frederic Peters
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome-pim.h"	/* generated by orbit-idl */

#include <gaby.h>
#include <libgnorba/gnorba.h>
#include <orb/orbit.h>
#include <tables.h>
#include <f_config.h>

/* action: init */

mstatic void gnomepim_init (struct action_param params[1], int *dec);

extern gnome_PIM_vCard_server impl_gnome_PIM_vCard_server__create(
		PortableServer_POA poa, CORBA_Environment * ev);
extern table *addressbook_table;

#ifndef FOLLOW_MIGUEL
void get_function_by_name(gchar *name, action *a)
{
#if 0
	a->function = NULL;
#ifdef USE_GNOME	/* this is useless */
	if ( strcmp(name, "init") == 0 )
		a->function = gnomepim_init;
#endif

#else
	return;
#endif
}
#endif

static void Exception (CORBA_Environment * ev)
{
	switch (ev->_major)
	{
		case CORBA_SYSTEM_EXCEPTION:
			g_log ("Gnome Card (Gaby) Server", G_LOG_LEVEL_DEBUG,
				"CORBA system exception %s.\n",
				CORBA_exception_id (ev));
		case CORBA_USER_EXCEPTION:
			g_log ("Gnome Card (Gaby) Server", G_LOG_LEVEL_DEBUG,
				"CORBA user exception: %s.\n",
				CORBA_exception_id (ev));
		default:
			break;
	}
}


mstatic void gnomepim_init (struct action_param params[1], int *dec)
{
	CORBA_ORB orb;
	CORBA_Environment ev;
	CORBA_Object server;
	CORBA_Object name_server;
	PortableServer_POA poa;
	PortableServer_POAManager pm;
	int nb = 1;
	char *argv[] = { "gaby" };
	
	CORBA_exception_init(&ev);
	orb = gnorba_CORBA_init(&nb, argv, GNORBA_INIT_SERVER_FUNC, &ev);
	Exception (&ev);
	
	poa = CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
	Exception (&ev);
	
	server = impl_gnome_PIM_vCard_server__create(poa, &ev);
	Exception (&ev);
	
	pm = PortableServer_POA__get_the_POAManager (poa, &ev);
	Exception (&ev);
	PortableServer_POAManager_activate (pm, &ev);
	Exception (&ev);
	
	name_server = gnome_name_service_get ();
	goad_server_register (name_server, server, "gaby", "object", &ev);
	
#ifdef DEBUG_GABY
	debug_print("gnome-pim-corba initialized\n");
#endif
	addressbook_table = params[0].table;

	(*dec)--;
}



