/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				count_nc_bonds.c

Purpose:
	For  N  atom of a  given residue,  count the number  of bonds with
	carbon atoms.

Input:
	(1) Pointer to  AtomS structure,  pointing to the first element of
	    the atomic array.
	(2) Index of the first atom of a given residue.
	(3) Index of the last atom of a given residue.

Output:
	Return value.

Return value:
	(1) The number of carbon atoms bound to N atom of a given residue.

========includes:============================================================*/

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "typedefs.h"

/*======count N-C bonds:=====================================================*/

int CountNCBonds_ (AtomS *first_atomSP, size_t atom_startI, size_t atom_endI)
{
int		NC_bondsN = 0;
size_t		atomI;
AtomS		*curr_atomSP;
short int	bondsN, bondI;
TrueBondS	*curr_bondSP;

/* Scan the given residue: */
for (atomI = atom_startI; atomI <= atom_endI; atomI++)
	{
	/* Pointer to the current atom: */
	curr_atomSP = first_atomSP + atomI;

	/* Check is it N atom: */
	if (strcmp (curr_atomSP->raw_atomS.pure_atom_nameA, "N") != 0)
		{
		continue;
		}

	/* If this point  is reached,  the current */
	/* atom is N atom; count bonds to C atoms: */
	bondsN = curr_atomSP->bondsN;
	for (bondI = 0; bondI < bondsN; bondI++)
		{
		/* Pointer to the current bond: */
		curr_bondSP = curr_atomSP->true_bondSA + bondI;

		/* Exclude hydrogen bonds: */
		if (curr_bondSP->bond_typeI == 0) continue;

		/* If this is nytrogen-carbon bond, increase count: */
		if (curr_bondSP->pairID == 2) NC_bondsN++;
		}

	/* Break from the loop, only one N atom is taken into account: */
	break;
	}

/* Return the number of extracted vectors: */
return NC_bondsN;
}

/*===========================================================================*/


