/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				select.c

Purpose:
	Execute  select  command.  Select  the specified  atoms  in all
	caught  macromolecular  complexes.  Three  selection modes  are
	available:  0 = overwrite,  1 = restrict,  2 = expand  previous
        selection.

Input:
	(1) Pointer to MolComplexS structure, with macromol. complexes.
	(2) Number of macromolecular complexes.
	(3) Pointer to RuntimeS structure, with some runtime data.
	(4) The selection string.
	(5) Selection mode index.

Output:
	(1) Selection flag changed for some or all atoms.
	(2) Return value.

Return value:
	(1) Positive (command) code on success.
	(3) Negative (error) code on failure.

========includes:============================================================*/

#include <stdio.h>

#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "commands.h"
#include "typedefs.h"

/*======function prototypes:=================================================*/

char		*ExtractToken_ (char *, int, char *, char *);
long		FullSelect_ (MolComplexS *, int, char *, int);
long		SpecialSelect_ (MolComplexS *, int, RuntimeS *, char *, int);
long		QuickSelect_ (MolComplexS *, int, char *, int);

/*======execute select command:==============================================*/

int Select_ (MolComplexS *mol_complexSP, int mol_complexesN,
	     RuntimeS *runtimeSP, char *stringP, int selection_modeI)
{
char		*remainderP;
char		tokenA[STRINGSIZE];
long		selected_atomsN;

/* The second token should contain  the selection */
/* criteria; it is called "the selection string": */
remainderP = ExtractToken_ (tokenA, STRINGSIZE, stringP, "\n\0");
if (!remainderP)
	{
	strcpy (runtimeSP->messageA, "Selection criteria missing!");
	runtimeSP->message_length = strlen (runtimeSP->messageA);
	return ERROR_SELECT;
	}

/* First try with the function which expects precise selection */
/* criteria;  the string is expected to contain three slashes: */
selected_atomsN = FullSelect_ (mol_complexSP, mol_complexesN,
			       tokenA, selection_modeI);

/* If  the previous  function  was  unable  to interpret the */
/* selection string try with the special selection function: */
if (selected_atomsN == -1)
	{
	selected_atomsN = SpecialSelect_ (mol_complexSP, mol_complexesN,
					  runtimeSP, tokenA, selection_modeI);
	}

/* If both previous attempts failed, try with the "quick" selection: */
if (selected_atomsN == -1)
	{
	selected_atomsN = QuickSelect_ (mol_complexSP, mol_complexesN,
					tokenA, selection_modeI);
	}

/* Write the number of selected atoms to the input window: */
if (selected_atomsN >= 0)
	{
	sprintf (runtimeSP->messageA,
		 "%ld atom(s) selected", selected_atomsN);
	runtimeSP->message_length = strlen (runtimeSP->messageA);
	}

/* If all selection functions failed, prepare error message: */
else
	{
	strcpy (runtimeSP->messageA, "Selection failed!");
	runtimeSP->message_length = strlen (runtimeSP->messageA);
	return ERROR_SELECT;
	}

/* If this point is reached, everything worked fine: */
return COMMAND_SELECT;
}

/*===========================================================================*/


