program fjf371;

uses GPC;

var Counter : Integer = 1;

procedure Test (Name, Value : CString);
begin
  if Value = nil then
    if CStringGetEnv (Name) <> nil then
      begin
        Writeln ('failed #', Counter, ': ', CString2String (Name), ' should not be set');
        Halt
      end
    else
  else
    if CStringGetEnv (Name) = nil then
      begin
        Writeln ('failed #', Counter, ': ', CString2String (Name), ' should be set');
        Halt
      end
    else if CStringComp (CStringGetEnv (Name), Value) <> 0 then
      begin
        Writeln ('failed #', Counter, ': ', CString2String (Name), '=', GetEnv (CString2String (Name)), ', should be ', CString2String (Value));
        Halt
      end
end;

procedure TestAll (Foo, Bar, Baz, Qux : CString);
begin
  Test ('foo', Foo);
  Test ('bar', Bar);
  Test ('baz', Baz);
  Test ('qux', Qux);
  Inc (Counter)
end;

begin
  TestAll ('qwe', 'asd', nil, nil);
  UnSetEnv ('foo');
  TestAll (nil, 'asd', nil, nil);
  UnSetEnv ('foo');
  TestAll (nil, 'asd', nil, nil);
  SetEnv ('bar', 'yxc');
  TestAll (nil, 'yxc', nil, nil);
  SetEnv ('bar', 'rtz');
  TestAll (nil, 'rtz', nil, nil);
  SetEnv ('bar', '');
  TestAll (nil, '', nil, nil);
  UnSetEnv ('bar');
  TestAll (nil, nil, nil, nil);
  SetEnv ('foo', '');
  TestAll ('', nil, nil, nil);
  UnSetEnv ('baz');
  TestAll ('', nil, nil, nil);
  SetEnv ('baz', 'fgh');
  TestAll ('', nil, 'fgh', nil);
  UnSetEnv ('baz');
  TestAll ('', nil, nil, nil);
  SetEnv ('qux', 'vbn');
  TestAll ('', nil, nil, 'vbn');
  SetEnv ('qux', 'uio');
  TestAll ('', nil, nil, 'uio');
  SetEnv ('qux', '');
  TestAll ('', nil, nil, '');
  UnSetEnv ('qux');
  TestAll ('', nil, nil, nil);
  SetEnv ('qux', '123');
  TestAll ('', nil, nil, '123');
  SetEnv ('bar', '456');
  TestAll ('', '456', nil, '123');
  Writeln ('OK')
end.
