#include "available-stubs.h"

/*#include "checker.h" */
#include <checker_api.h>

#ifdef HAVE_chkrfunc
/* From `../solaris/checker_api.h:119'.  */
int chkr_stub___chkr_read_bitmap (const void *addr, unsigned char *dst,
				  size_t len)
     __asm__ (CHKR_PREFIX ("__chkr_read_bitmap"));
int
chkr_stub___chkr_read_bitmap (const void *addr, unsigned char *dst,
			      size_t len)
{
  stubs_chkr_check_addr (dst, len, CHKR_WO, "dst");
#if USE_BI_JUMP
  __builtin_jump (__chkr_read_bitmap);
#else
  return __chkr_read_bitmap (addr, dst, len);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:120'.  */
int chkr_stub___chkr_write_bitmap (const void *addr, unsigned char *src,
				   size_t len)
     __asm__ (CHKR_PREFIX ("__chkr_write_bitmap"));
int
chkr_stub___chkr_write_bitmap (const void *addr, unsigned char *src,
			       size_t len)
{
  stubs_chkr_check_addr (src, len, CHKR_WO, "src");
#if USE_BI_JUMP
  __builtin_jump (__chkr_write_bitmap);
#else
  return __chkr_write_bitmap (addr, src, len);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:121'.  */
void chkr_stub___chkr_disp_map (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_map"));
void
chkr_stub___chkr_disp_map (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_map);
#else
  __chkr_disp_map ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:122'.  */
void chkr_stub___chkr_disp_right (const void *addr, size_t len)
     __asm__ (CHKR_PREFIX ("__chkr_disp_right"));
void
chkr_stub___chkr_disp_right (const void *addr, size_t len)
{
  stubs_chkr_check_addr (addr, sizeof (void), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_right);
#else
  __chkr_disp_right (addr, len);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:123'.  */
void chkr_stub___chkr_check_mdesc (struct mdesc *desc)
     __asm__ (CHKR_PREFIX ("__chkr_check_mdesc"));
void
chkr_stub___chkr_check_mdesc (struct mdesc *desc)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_check_mdesc);
#else
  __chkr_check_mdesc (desc);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:124'.  */
void chkr_stub___chkr_check_intern (void)
     __asm__ (CHKR_PREFIX ("__chkr_check_intern"));
void
chkr_stub___chkr_check_intern (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_check_intern);
#else
  __chkr_check_intern ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:125'.  */
void chkr_stub___chkr_disp_heaps (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_heaps"));
void
chkr_stub___chkr_disp_heaps (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_heaps);
#else
  __chkr_disp_heaps ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:126'.  */
void chkr_stub___chkr_disp_heapgraph (struct mdesc *desc)
     __asm__ (CHKR_PREFIX ("__chkr_disp_heapgraph"));
void
chkr_stub___chkr_disp_heapgraph (struct mdesc *desc)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_heapgraph);
#else
  __chkr_disp_heapgraph (desc);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:127'.  */
void chkr_stub___chkr_disp_statistics (struct mdesc *desc)
     __asm__ (CHKR_PREFIX ("__chkr_disp_statistics"));
void
chkr_stub___chkr_disp_statistics (struct mdesc *desc)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_statistics);
#else
  __chkr_disp_statistics (desc);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:128'.  */
void chkr_stub___chkr_dump_mheap (struct mdesc *desc)
     __asm__ (CHKR_PREFIX ("__chkr_dump_mheap"));
void
chkr_stub___chkr_dump_mheap (struct mdesc *desc)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_dump_mheap);
#else
  __chkr_dump_mheap (desc);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:129'.  */
void chkr_stub___chkr_dump_free (struct mdesc *desc)
     __asm__ (CHKR_PREFIX ("__chkr_dump_free"));
void
chkr_stub___chkr_dump_free (struct mdesc *desc)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_dump_free);
#else
  __chkr_dump_free (desc);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:130'.  */
void chkr_stub___chkr_dump_block (void *addr)
     __asm__ (CHKR_PREFIX ("__chkr_dump_block"));
void
chkr_stub___chkr_dump_block (void *addr)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_dump_block);
#else
  __chkr_dump_block (addr);
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:131'.  */
void chkr_stub___chkr_disp_shlibs (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_shlibs"));
void
chkr_stub___chkr_disp_shlibs (void )
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_shlibs);
#else
  __chkr_disp_shlibs ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:132'.  */
void chkr_stub___chkr_disp_siginfo (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_siginfo"));
void
chkr_stub___chkr_disp_siginfo (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_siginfo);
#else
  __chkr_disp_siginfo ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:133'.  */
void chkr_stub___chkr_disp_fd (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_fd"));
void
chkr_stub___chkr_disp_fd (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_fd);
#else
  __chkr_disp_fd ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:136'.  */
void chkr_stub___chkr_garbage_detector (void)
     __asm__ (CHKR_PREFIX ("__chkr_garbage_detector"));
void
chkr_stub___chkr_garbage_detector (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_garbage_detector);
#else
  __chkr_garbage_detector ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:137'.  */
void chkr_stub___chkr_disp_inuse (void)
     __asm__ (CHKR_PREFIX ("__chkr_disp_inuse"));
void
chkr_stub___chkr_disp_inuse (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_disp_inuse);
#else
  __chkr_disp_inuse ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:138'.  */
void chkr_stub___chkr_evol_detector (void)
     __asm__ (CHKR_PREFIX ("__chkr_evol_detector"));
void
chkr_stub___chkr_evol_detector (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_evol_detector);
#else
  __chkr_evol_detector ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:139'.  */
void chkr_stub___chkr_clear_leaks (void)
     __asm__ (CHKR_PREFIX ("__chkr_clear_leaks"));
void
chkr_stub___chkr_clear_leaks (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_clear_leaks);
#else
  __chkr_clear_leaks ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:140'.  */
void chkr_stub___chkr_evol_inuse (void)
     __asm__ (CHKR_PREFIX ("__chkr_evol_inuse"));
void
chkr_stub___chkr_evol_inuse (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_evol_inuse);
#else
  __chkr_evol_inuse ();
#endif /* !USE_BI_JUMP */
}

/* From `../solaris/checker_api.h:141'.  */
void chkr_stub___chkr_clear_inuse (void)
     __asm__ (CHKR_PREFIX ("__chkr_clear_inuse"));
void
chkr_stub___chkr_clear_inuse (void)
{
#if USE_BI_JUMP
  __builtin_jump (__chkr_clear_inuse);
#else
  __chkr_clear_inuse ();
#endif /* !USE_BI_JUMP */
}

void chkr_stub_chkr_check_addr (const PTR ptr, size_t len, unsigned char right)
     __asm__ (CHKR_PREFIX ("chkr_check_addr"));
void
chkr_stub_chkr_check_addr (const PTR ptr, size_t len, unsigned char right)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_check_addr);
#else
  chkr_check_addr (ptr, len, right);
#endif /* !USE_BI_JUMP */
}

void chkr_stub_chkr_set_right (const PTR ptr, size_t len, unsigned char right)
     __asm__ (CHKR_PREFIX ("chkr_set_right"));
void
chkr_stub_chkr_set_right (const PTR ptr, size_t len, unsigned char right)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_set_right);
#else
  chkr_set_right (ptr, len, right);
#endif /* !USE_BI_JUMP */
}

void chkr_stub_chkr_copy_bitmap (PTR ptr, PTR src, size_t len)
     __asm__ (CHKR_PREFIX ("chkr_copy_bitmap"));
void
chkr_stub_chkr_copy_bitmap (PTR ptr, PTR src, size_t len)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_copy_bitmap);
#else
  chkr_copy_bitmap (ptr, src, len);
#endif /* !USE_BI_JUMP */
}

void chkr_stub_chkr_check_exec (const PTR ptr)
     __asm__ (CHKR_PREFIX ("chkr_check_exec"));
void
chkr_stub_chkr_check_exec (const PTR ptr)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_check_exec);
#else
  chkr_check_exec (ptr);
#endif /* !USE_BI_JUMP */
}

void chkr_stub_chkr_check_str (const PTR ptr, unsigned char right)
     __asm__ (CHKR_PREFIX ("chkr_check_str"));
void
chkr_stub_chkr_check_str (const PTR ptr, unsigned char right)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_check_str);
#else
  chkr_check_str (ptr, right);
#endif /* !USE_BI_JUMP */
}

int chkr_stub_chkr_get_nbr_report (void) __asm__ (CHKR_PREFIX ("chkr_get_nbr_report"));
int
chkr_stub_chkr_get_nbr_report (void)
{
#if USE_BI_JUMP
  __builtin_jump (chkr_get_nbr_report);
#else
  return chkr_get_nbr_report ();
#endif /* !USE_BI_JUMP */
}

#if 0
/* A prototype.  */
void chkr_stub_XXX (void) __asm__ (CHKR_PREFIX ("XXX"));
void
chkr_stub_XXX (void)
{
#if USE_BI_JUMP
  __builtin_jump (XXX);
#else
  XXX (ptr);
#endif /* !USE_BI_JUMP */
}
#endif

#endif /* HAVE_chkrfunc */
