from ContainerTarget import ContainerTarget
from utils.TilingImage import TilingImage
from utils.datatypes import *

import gtk
import os

try:
    import gnomevfs
except ImportError:
    import gnome.vfs as gnomevfs

#
# Class for grouping different targets together.
#
class TargetGroup(ContainerTarget):

    def __init__(self, parent):

        # the background pixmap
        self.__pixbuf = None

        # flag for ensuring that only one collapse action takes place
        self.__block = 0

        # the maximum size values of all the children
        self.__max_size = (0, 0)

        ContainerTarget.__init__(self, parent)
        self.__layout = gtk.Fixed()
        self.__layout.show()

        #self.add(self.__layout)

        self.__image = TilingImage()
        self.__image.show()
        self.__layout.put(self.__image, 0, 0)

        self._register_property("window-flags", TYPE_LIST,
                                self._setp_container_stuff, self._getp)
        self._register_property("shape", TYPE_STRING,
                                self._setp_container_stuff, self._getp)
        self._register_property("icon", TYPE_STRING,
                                self._setp_container_stuff, self._getp)
        self._register_property("title", TYPE_STRING,
                                self._setp_container_stuff, self._getp)
        self._register_property("bg-uri", TYPE_STRING,
                                self._setp_bg_uri, self._getp)
        self._register_property("bg-color", TYPE_STRING,
                                self._setp_bg_color, self._getp)

        #self.connect("expose-event", self.__on_expose)
        self.add_observer(self.__on_observe_size)

        self._setp_container_stuff("window-flags", ["managed", "decorated"])


    def get_widget(self): return self.__layout


    def __on_observe_size(self, src, cmd):

        if (cmd == src.OBS_GEOMETRY):
            x, y, w, h = self.get_geometry()
            ow, oh = self.__image.size_request()
            if ((w.as_px(), h.as_px()) != (ow, oh)):
                self.__image.tile(w.as_px(), h.as_px())



    def new_child(self, childtype, settings, children):

        child = ContainerTarget.new_child(self, childtype, settings, children)
        if (not child.is_standalone()):
            x, y, w, h = child.get_geometry()
            self.__layout.put(child.get_widget(), x.as_px(), y.as_px())

        return child



    def child_observer(self, src, cmd):

        ContainerTarget.child_observer(self, src, cmd)

        if (cmd == src.OBS_GEOMETRY):
            x, y, w, h = src.get_geometry()

            if (src.get_widget() in self.__layout.get_children()):
                self.__layout.move(src.get_widget(), x.as_px(), y.as_px())



    #
    # Sets the background color.
    #
    def __set_color(self, color):

        self.__image.set_from_color(color)



    #
    # Sets the background image.
    #
    def __set_background(self, uri):

        if (not uri):
            self.__set_color("#00000000")
            return

        uri = self._get_display().get_full_path(uri)
        if (gnomevfs.exists(uri)):
            self.__image.set_from_file(uri)

        else:
            self.__set_color("#ffffffa0")

        #self.__image.set_size_request(width, height)



    #
    # Container properties.
    #
    def _setp_container_stuff(self, key, value):

        if (self._get_display() == self._get_parent()):
            self._get_display().set_prop(key, value)
            self._setp(key, value)



    #
    # "bg-uri" property.
    #
    def _setp_bg_uri(self, key, value):

        self.__set_background(value)
        self._setp(key, value)



    #
    # "bg-color" property.
    #
    def _setp_bg_color(self, key, value):

        self.__set_color(value)
        self._setp(key, value)
