/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "failover_functions.h"

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;



void populate_scope_treeview(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    gchar *utf8=NULL;
    GtkTreePath *path;
    gboolean edit=0;
    int set_cursorpath=0;
    long conf_size=0;
    char *line;
    char *nic;
    char *subnet;
    char *netmask;
    gchar *failover;

    gtk_list_store_clear(widgets->scope_store);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
       return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    nic = allocate(MAX_CONF_LINE);
    subnet = allocate(MAX_CONF_LINE);
    netmask = allocate(MAX_CONF_LINE);

    if( conf_size > 1 )    
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strstr(line, "subnet") && strstr(line, "netmask") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %s %*s %s", subnet, netmask);	    
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, "interface") && ! strstr(line, "#") )
		{
		    sscanf(line, "%*s %s", nic);
		    gtk_list_store_append(GTK_LIST_STORE(widgets->scope_store), &iter);

		    if( nic[strlen(nic)-1]==';')
		      nic[strlen(nic)-1]='\0';
		    
		    utf8 = g_locale_to_utf8(nic, strlen(nic), NULL, NULL, NULL);
		    gtk_list_store_set(GTK_LIST_STORE(widgets->scope_store), &iter, 0, utf8, -1);
		    
		    utf8 = g_locale_to_utf8(subnet, strlen(subnet), NULL, NULL, NULL);
		    gtk_list_store_set(GTK_LIST_STORE(widgets->scope_store), &iter, 1, utf8, -1);
		    
		    if( strstr(netmask, "{") )
		      netmask[strlen(netmask)-1]='\0';

		    utf8 = g_locale_to_utf8(netmask, strlen(netmask), NULL, NULL, NULL);
		    gtk_list_store_set(GTK_LIST_STORE(widgets->scope_store), &iter, 2, utf8, -1);
		    set_cursorpath = 1;
		    
		    /* Get the failover peer if any */
		    failover = get_failover(nic, subnet, netmask, "peer address");
		    utf8 = g_locale_to_utf8(failover, strlen(failover), NULL, NULL, NULL);
		    gtk_list_store_set(GTK_LIST_STORE(widgets->scope_store), &iter, 3, utf8, -1);
		    g_free(failover);

		    break;
		}
	    }
	}
    }
    fclose(fp);
    free(line);
    free(nic);
    free(subnet);
    free(netmask);

    if( utf8!=NULL )
      g_free(utf8);

    if( ! set_cursorpath )
      return;
    
    /* FIXME.. Scroll to the correct global nic subnet and netmask (and if its set) set as curpath */
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->scope_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
